/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.webserviceclient.weblicht;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import mpi.eudico.server.corpora.clomimpl.abstr.AbstractAnnotation;
import mpi.eudico.server.corpora.clomimpl.abstr.TierImpl;
import mpi.eudico.server.corpora.clomimpl.abstr.TranscriptionImpl;
import mpi.eudico.server.corpora.clomimpl.type.LinguisticType;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicAssociation;
import mpi.eudico.server.corpora.clomimpl.type.SymbolicSubdivision;
import mpi.eudico.webserviceclient.weblicht.TCFElement;
import mpi.eudico.webserviceclient.weblicht.TCFParser;
import mpi.eudico.webserviceclient.weblicht.TCFType;
import org.xml.sax.SAXException;

public class TCFtoTranscription {
    private TranscriptionImpl transcription;
    private TCFParser parser;
    private long defDuration = 5000L;
    private boolean includeTokens = true;
    private boolean includePOSTags = true;
    private boolean includeLemmas = true;

    public void setDefaultDuration(long duration) {
        this.defDuration = duration;
    }

    public void setTiersToInclude(boolean includeTokens, boolean includePOSTags, boolean includeLemmas) {
        this.includeTokens = includeTokens;
        this.includePOSTags = includePOSTags;
        this.includeLemmas = includeLemmas;
    }

    public TranscriptionImpl createTranscription(String tcbString) throws SAXException, IOException {
        if (tcbString != null) {
            this.parser = new TCFParser(tcbString);
            this.parser.parse();
            this.transcription = new TranscriptionImpl();
            this.transcription.setNotifying(false);
            this.createTiers();
            this.createAnnotations();
            return this.transcription;
        }
        throw new IOException("The TCB input is null.");
    }

    private void createTiers() {
        LinguisticType senType = new LinguisticType("sentence");
        senType.setTimeAlignable(true);
        this.transcription.addLinguisticType(senType);
        TierImpl senTier = new TierImpl("sentence", null, this.transcription, senType);
        this.transcription.addTier(senTier);
        if (this.includeTokens) {
            LinguisticType tokType = new LinguisticType("token");
            tokType.addConstraint(new SymbolicSubdivision());
            tokType.setTimeAlignable(false);
            this.transcription.addLinguisticType(tokType);
            TierImpl tokTier = new TierImpl(senTier, "token", null, this.transcription, tokType);
            this.transcription.addTier(tokTier);
            if (this.includePOSTags) {
                LinguisticType posType = new LinguisticType("POStags");
                posType.addConstraint(new SymbolicAssociation());
                posType.setTimeAlignable(false);
                this.transcription.addLinguisticType(posType);
                TierImpl posTagTier = new TierImpl(tokTier, "POStags", null, this.transcription, posType);
                this.transcription.addTier(posTagTier);
            }
            if (this.includeLemmas) {
                LinguisticType lemType = new LinguisticType("lemma");
                lemType.addConstraint(new SymbolicAssociation());
                lemType.setTimeAlignable(false);
                this.transcription.addLinguisticType(lemType);
                TierImpl lemTagTier = new TierImpl(tokTier, "lemma", null, this.transcription, lemType);
                this.transcription.addTier(lemTagTier);
            }
        }
    }

    private void createAnnotations() {
        if (this.parser == null || this.transcription == null) {
            return;
        }
        String SPACE = " ";
        List<TCFElement> sentences = this.parser.getElementsByType(TCFType.SENTENCE);
        long t = 0L;
        long dur = this.defDuration;
        int numProcessedTokens = 0;
        if (sentences != null) {
            for (TCFElement senEl : sentences) {
                String[] toks;
                List<TCFElement> tokens;
                if (senEl.getIdRefs() != null && (tokens = this.getTokensWithIDs(toks = senEl.getIdRefs().split(" "))) != null && tokens.size() > 0) {
                    TierImpl sentTier = this.transcription.getTierWithId("sentence");
                    if (sentTier == null) {
                        return;
                    }
                    AbstractAnnotation sentAnn = (AbstractAnnotation)sentTier.createAnnotation(t, t + dur);
                    if (sentAnn == null) {
                        return;
                    }
                    StringBuilder sentBuilder = new StringBuilder();
                    AbstractAnnotation curTokAnn = null;
                    for (int i = 0; i < tokens.size(); ++i) {
                        AbstractAnnotation lemAnn;
                        TCFElement lemEl;
                        AbstractAnnotation posAnn;
                        TCFElement posEl;
                        TCFElement tokEl = tokens.get(i);
                        if (i != 0 && tokEl.getText().length() > 0 && Character.getType(tokEl.getText().charAt(0)) != 22) {
                            sentBuilder.append(" ");
                        }
                        sentBuilder.append(tokEl.getText());
                        AbstractAnnotation nextAnnotation = null;
                        if (this.includeTokens && this.transcription.getTierWithId("token") != null) {
                            nextAnnotation = curTokAnn == null ? (AbstractAnnotation)this.transcription.getTierWithId("token").createAnnotation(t + dur / 2L, t + dur / 2L) : (AbstractAnnotation)this.transcription.getTierWithId("token").createAnnotationAfter(curTokAnn);
                        }
                        if (nextAnnotation == null) continue;
                        if (tokEl.getText() != null) {
                            nextAnnotation.setValue(tokEl.getText());
                        }
                        curTokAnn = nextAnnotation;
                        long mid = (nextAnnotation.getBeginTimeBoundary() + nextAnnotation.getEndTimeBoundary()) / 2L;
                        if (this.includePOSTags && this.transcription.getTierWithId("POStags") != null && (posEl = this.getDependentsForToken(tokEl.getId(), TCFType.TAG)) != null && (posAnn = (AbstractAnnotation)this.transcription.getTierWithId("POStags").createAnnotation(mid, mid)) != null && posEl.getText() != null) {
                            posAnn.setValue(posEl.getText());
                        }
                        if (!this.includeLemmas || this.transcription.getTierWithId("lemma") == null || (lemEl = this.getDependentsForToken(tokEl.getId(), TCFType.LEMMA)) == null || (lemAnn = (AbstractAnnotation)this.transcription.getTierWithId("lemma").createAnnotation(mid, mid)) == null || lemEl.getText() == null) continue;
                        lemAnn.setValue(lemEl.getText());
                    }
                    sentAnn.setValue(sentBuilder.toString());
                    numProcessedTokens += tokens.size();
                }
                t += dur;
            }
        }
    }

    private List<TCFElement> getTokensWithIDs(String[] ids) {
        if (ids == null || ids.length == 0) {
            return null;
        }
        ArrayList<TCFElement> tokEls = new ArrayList<TCFElement>(ids.length);
        block0: for (String id : ids) {
            for (TCFElement tokEl : this.parser.getElementsByType(TCFType.TOKEN)) {
                if (!id.equals(tokEl.getId())) continue;
                tokEls.add(tokEl);
                continue block0;
            }
        }
        return tokEls;
    }

    private TCFElement getDependentsForToken(String id, TCFType type) {
        if (id == null) {
            return null;
        }
        List<TCFElement> elemList = this.parser.getElementsByType(type);
        if (elemList != null) {
            for (TCFElement te : elemList) {
                String idRefString = te.getIdRefs();
                if (idRefString == null) continue;
                String[] idRefs = idRefString.split(" ");
                for (int i = 0; i < idRefs.length; ++i) {
                    if (!id.equals(idRefs[i])) continue;
                    return te;
                }
            }
        }
        return null;
    }
}

