/*
 * Decompiled with CFR 0.152.
 */
package mpi.eudico.webserviceclient.weblicht;

import java.io.IOException;
import java.util.HashMap;
import mpi.eudico.server.corpora.util.ServerLogger;
import mpi.eudico.webserviceclient.WsClientRest;

public class WebLichtWsClient {
    public static String baseUrl = "http://weblicht.sfs.uni-tuebingen.de/rws/";
    private String convertUrl = "http://weblicht.sfs.uni-tuebingen.de/rws/service-converter/convert/qp";
    private WsClientRest wsClient = new WsClientRest();

    public String convertPlainText(String text) throws IOException {
        if (text == null || text.length() == 0) {
            return text;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("informat", "plaintext");
        params.put("outformat", "tcf04");
        params.put("language", "unknown");
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("User-Agent", "ELAN");
        properties.put("Connection", "Keep-Alive");
        properties.put("Content-Type", "text/tcf+xml;charset=utf-8");
        try {
            String result = this.wsClient.callServicePostMethodWithString(this.convertUrl, params, properties, text, null, null, 0.0f, 0.0f);
            return result;
        }
        catch (IOException ioe) {
            ServerLogger.LOG.warning("Call failed: " + ioe.getMessage());
            throw ioe;
        }
        catch (Throwable t) {
            ServerLogger.LOG.warning("Call failed: " + t.getMessage());
            throw new IOException(t.getMessage());
        }
    }

    public String callWithTCF(String toolUrl, String tcfString) throws IOException {
        if (toolUrl == null) {
            ServerLogger.LOG.warning("No web service url specified.");
            throw new NullPointerException("No web service url specified.");
        }
        if (tcfString == null) {
            ServerLogger.LOG.warning("No input specified.");
            throw new NullPointerException("No input TCF specified.");
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("Accept", "text/tcf+xml");
        properties.put("User-Agent", "ELAN");
        properties.put("Connection", "Keep-Alive");
        properties.put("Content-Type", "text/tcf+xml;charset=utf-8");
        try {
            String result = this.wsClient.callServicePostMethodWithString(toolUrl, null, properties, tcfString, null, null, 0.0f, 0.0f);
            System.out.println(result);
            return result;
        }
        catch (IOException ioe) {
            ServerLogger.LOG.warning("Call failed: " + ioe.getMessage());
            throw ioe;
        }
        catch (Throwable t) {
            ServerLogger.LOG.warning("Call failed: " + t.getMessage());
            throw new IOException(t.getMessage());
        }
    }
}

