/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.content.query.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import mpi.search.content.query.model.Constraint;

public abstract class AbstractConstraint
implements Constraint {
    protected String mode = "Search.Constraint.Temporal";
    protected String quantifier = "Search.Constraint.Any";
    protected String[] tierNames = new String[0];
    private Constraint parent = null;
    private Map<String, String> attributes;
    private String patternString = "";
    private String unit;
    private List<Constraint> children = new ArrayList<Constraint>();
    private boolean isCaseSensitive = false;
    private boolean isRegEx = false;
    private long lowerBoundary = Long.MIN_VALUE;
    private long upperBoundary = Long.MAX_VALUE;

    public AbstractConstraint() {
    }

    public AbstractConstraint(String[] tierNames, String patternString, long lowerBoundary, long upperBoundary, String unit, boolean isRegEx, boolean isCaseSensitive, Map<String, String> attributes) {
        this.tierNames = tierNames;
        this.patternString = patternString;
        this.lowerBoundary = lowerBoundary;
        this.upperBoundary = upperBoundary;
        this.unit = unit;
        this.isRegEx = isRegEx;
        this.isCaseSensitive = isCaseSensitive;
        this.attributes = attributes;
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public void setAttributes(Map<String, String> h) {
        this.attributes = h;
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    @Override
    public void setCaseSensitive(boolean b) {
        this.isCaseSensitive = b;
    }

    @Override
    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }

    @Override
    public Constraint getChildAt(int i) {
        return this.children.get(i);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public String getId() {
        return this.parent != null ? this.parent.getId() + "." + this.parent.getIndex(this) : "C";
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.children.indexOf(node);
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    public void setLowerBoundary(long l) {
        this.lowerBoundary = l;
    }

    @Override
    public long getLowerBoundary() {
        return this.lowerBoundary;
    }

    @Override
    public String getLowerBoundaryAsString() {
        return this.lowerBoundary == Long.MIN_VALUE ? "-X" : "" + this.lowerBoundary;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public void setParent(MutableTreeNode parent) {
        this.setParent((Constraint)parent);
    }

    @Override
    public void setParent(Constraint parent) {
        this.parent = parent;
    }

    @Override
    public Constraint getParent() {
        return this.parent;
    }

    @Override
    public void setPattern(String s) {
        this.patternString = s;
    }

    @Override
    public String getPattern() {
        return this.patternString;
    }

    @Override
    public String getQuantifier() {
        return this.quantifier;
    }

    @Override
    public void setRegEx(boolean b) {
        this.isRegEx = b;
    }

    @Override
    public boolean isRegEx() {
        return this.isRegEx;
    }

    public void setTierName(String s) {
        this.tierNames = new String[]{s};
    }

    @Override
    public String getTierName() {
        return this.tierNames.length > 0 ? this.tierNames[0] : null;
    }

    @Override
    public void setTierNames(String[] s) {
        this.tierNames = s;
    }

    @Override
    public String[] getTierNames() {
        return this.tierNames;
    }

    @Override
    public void setUnit(String s) {
        this.unit = s;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    @Override
    public void setUpperBoundary(long l) {
        this.upperBoundary = l;
    }

    @Override
    public long getUpperBoundary() {
        return this.upperBoundary;
    }

    @Override
    public String getUpperBoundaryAsString() {
        return this.upperBoundary == Long.MAX_VALUE ? "+X" : "" + this.upperBoundary;
    }

    @Override
    public void setUserObject(Object object) {
    }

    @Override
    public void addAttribute(String name, String value) {
        this.attributes.put(name, value);
    }

    @Override
    public Enumeration<Constraint> children() {
        return Collections.enumeration(this.children);
    }

    @Override
    public Object clone() {
        AbstractConstraint newConstraint = null;
        try {
            newConstraint = (AbstractConstraint)super.clone();
            newConstraint.setTierNames(this.getTierNames());
            newConstraint.setPattern(this.getPattern());
            newConstraint.setCaseSensitive(this.isCaseSensitive());
            newConstraint.setRegEx(this.isRegEx());
            newConstraint.setUnit(this.getUnit());
            newConstraint.setLowerBoundary(this.getLowerBoundary());
            newConstraint.setUpperBoundary(this.getUpperBoundary());
            newConstraint.setAttributes(this.getAttributes());
            newConstraint.children = new ArrayList<Constraint>();
            newConstraint.parent = null;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return newConstraint;
    }

    public boolean equals(Object object) {
        if (!(object instanceof AbstractConstraint)) {
            return false;
        }
        AbstractConstraint constraint = (AbstractConstraint)object;
        if (constraint.isCaseSensitive() != this.isCaseSensitive()) {
            return false;
        }
        if (constraint.isRegEx() != this.isRegEx()) {
            return false;
        }
        if (!constraint.getPattern().equals(this.getPattern())) {
            return false;
        }
        if (constraint.getLowerBoundary() != this.getLowerBoundary()) {
            return false;
        }
        if (constraint.getUpperBoundary() != this.getUpperBoundary()) {
            return false;
        }
        if (constraint.getUnit() == null && this.getUnit() != null || constraint.getUnit() != null && !constraint.getUnit().equals(this.getUnit())) {
            return false;
        }
        return (constraint.getAttributes() != null || constraint.getAttributes() == null) && (constraint.getAttributes() == null || constraint.getAttributes().equals(this.getAttributes()));
    }

    @Override
    public void insert(MutableTreeNode child, int index) {
        this.insert((Constraint)child, index);
    }

    @Override
    public void insert(Constraint child, int index) {
        this.children.add(index, child);
        child.setParent(this);
    }

    @Override
    public void remove(int index) {
        Constraint child = this.children.get(index);
        this.children.remove(index);
        child.setParent(null);
    }

    @Override
    public void remove(MutableTreeNode node) {
        this.children.remove(node);
        node.setParent(null);
    }

    @Override
    public void removeFromParent() {
        if (this.parent != null) {
            this.parent.remove(this);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Quantifier:\t" + this.quantifier + "\n");
        for (String tierName : this.tierNames) {
            sb.append("Tier name:\t" + tierName + "\n");
        }
        sb.append("Pattern:\t" + this.patternString + "\n");
        sb.append("Unit:\t" + this.unit + "\n");
        sb.append("Lower boundary:\t" + this.lowerBoundary + "\n");
        sb.append("Upper boundary:\t" + this.upperBoundary + "\n");
        return sb.toString();
    }
}

