/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.content.query.viewer;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import mpi.search.content.model.CorpusType;
import mpi.search.content.query.model.AnchorConstraint;
import mpi.search.content.query.model.Constraint;
import mpi.search.content.query.viewer.AbstractDistancePanel;
import mpi.search.content.query.viewer.AnchorTemporalDistancePanel;
import mpi.search.content.query.viewer.DependentTemporalDistancePanel;
import mpi.search.content.query.viewer.StructuralDistancePanel;

public class RelationPanel
extends JPanel {
    protected AbstractDistancePanel structuralDistancePanel;
    protected AbstractDistancePanel temporalDistancePanel;
    protected final JComboBox<String> quantifierComboBox = new JComboBox<String>(Constraint.QUANTIFIERS);
    private final CardLayout distanceInputLayout = new CardLayout();
    private final JPanel distancePanelPlaceHolder = new JPanel(this.distanceInputLayout);

    public RelationPanel(CorpusType type, Constraint constraint) {
        this.setLayout(new FlowLayout(0, 0, 0));
        GridBagConstraints c = new GridBagConstraints();
        this.temporalDistancePanel = constraint instanceof AnchorConstraint ? new AnchorTemporalDistancePanel() : new DependentTemporalDistancePanel();
        this.structuralDistancePanel = new StructuralDistancePanel();
        this.distancePanelPlaceHolder.add((Component)this.structuralDistancePanel, "Search.Constraint.Structural");
        this.distancePanelPlaceHolder.add((Component)this.temporalDistancePanel, "Search.Constraint.Temporal");
        c.gridwidth = 1;
        c.gridy = 1;
        c.gridx = -1;
        c.fill = 0;
        this.add(this.distancePanelPlaceHolder);
        c.anchor = 17;
        if (constraint instanceof AnchorConstraint && !type.allowsTemporalConstraints()) {
            this.setVisible(false);
        } else {
            this.setDistanceMode(constraint.getMode());
        }
    }

    public void setDistanceMode(String mode) {
        this.distanceInputLayout.show(this.distancePanelPlaceHolder, mode);
    }

    public void setLowerBoundary(long boundary) {
        (this.temporalDistancePanel.isVisible() ? this.temporalDistancePanel : this.structuralDistancePanel).setLowerBoundary(boundary);
    }

    public long getLowerBoundary() {
        return (!this.isVisible() || this.temporalDistancePanel.isVisible() ? this.temporalDistancePanel : this.structuralDistancePanel).getLowerBoundary();
    }

    public void setUnit(String unit) {
        if (unit != null) {
            (this.temporalDistancePanel.isVisible() ? this.temporalDistancePanel : this.structuralDistancePanel).setUnit(unit);
        }
    }

    public String getUnit() {
        return (this.temporalDistancePanel.isVisible() ? this.temporalDistancePanel : this.structuralDistancePanel).getUnit();
    }

    public JComboBox<String> getUnitComboBox() {
        return ((StructuralDistancePanel)this.structuralDistancePanel).getUnitComboBox();
    }

    public void setUpperBoundary(long boundary) {
        (this.temporalDistancePanel.isVisible() ? this.temporalDistancePanel : this.structuralDistancePanel).setUpperBoundary(boundary);
    }

    public long getUpperBoundary() {
        return (!this.isVisible() || this.temporalDistancePanel.isVisible() ? this.temporalDistancePanel : this.structuralDistancePanel).getUpperBoundary();
    }
}

