/*
 * Decompiled with CFR 0.152.
 */
package mpi.search.result.viewer;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import mpi.search.result.model.Result;
import mpi.search.result.model.ResultEvent;
import mpi.search.result.viewer.ResultViewer;

public abstract class AbstractResultViewer
extends JPanel
implements ResultViewer {
    protected final Action nextAction;
    protected final Action previousAction;
    protected final JLabel currentLabel;
    protected final JPanel controlPanel = new JPanel(new FlowLayout(1, 5, 0));
    protected Result result;

    public AbstractResultViewer() {
        this.currentLabel = new JLabel();
        this.nextAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractResultViewer.this.result.pageUp();
                AbstractResultViewer.this.updateButtons();
            }
        };
        this.nextAction.putValue("Name", ">");
        this.previousAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractResultViewer.this.result.pageDown();
                AbstractResultViewer.this.updateButtons();
            }
        };
        this.previousAction.putValue("Name", "<");
        this.nextAction.setEnabled(false);
        this.previousAction.setEnabled(false);
    }

    public JPanel getControlPanel() {
        return this.controlPanel;
    }

    @Override
    public void reset() {
        this.nextAction.setEnabled(false);
        this.previousAction.setEnabled(false);
        this.controlPanel.setVisible(false);
    }

    @Override
    public abstract void showResult(Result var1);

    @Override
    public void resultChanged(ResultEvent e) {
        this.result = (Result)e.getSource();
        if (this.result.getRealSize() == 0) {
            this.reset();
        } else if (e.getType() == 2 || e.getType() == 1 && (this.result.getStatus() == 1 || this.result.getStatus() == -1)) {
            this.updateButtons();
        }
    }

    protected int[] getNextInterval() {
        if (this.result.getPageOffset() < this.result.getPageCount()) {
            return new int[]{(this.result.getPageOffset() + 1) * this.result.getPageSize() + 1, Math.min((this.result.getPageOffset() + 2) * this.result.getPageSize() + 1, this.result.getRealSize())};
        }
        return null;
    }

    protected int[] getPreviousInterval() {
        if (this.result.getPageOffset() > 0) {
            return new int[]{(this.result.getPageOffset() - 1) * this.result.getPageSize() + 1, this.result.getPageOffset() * this.result.getPageSize()};
        }
        return null;
    }

    protected String intervalToString(int[] interval) {
        return interval != null ? interval[0] + (String)(interval[0] != interval[1] ? "-" + interval[1] : "") : null;
    }

    protected void updateButtons() {
        this.previousAction.setEnabled(this.result.getPageOffset() > 0);
        this.nextAction.setEnabled(this.result.getPageOffset() < this.result.getPageCount() - 1);
        this.currentLabel.setText(this.intervalToString(new int[]{this.result.getFirstShownRealIndex() + 1, this.result.getLastShownRealIndex() + 1}));
        this.previousAction.putValue("ShortDescription", this.intervalToString(this.getPreviousInterval()));
        this.nextAction.putValue("ShortDescription", this.intervalToString(this.getNextInterval()));
    }
}

