/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.avf.frame;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteBuffer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AVFFrameGrabber {
    private static final Logger LOG;
    static boolean nativeLibLoaded;
    static boolean nativeLogLoaded;
    private static boolean isAarch64;
    private String mediaPath;
    private long id;
    private boolean fieldsInited = false;
    private int numBytesPerFrame;
    private int numBytesPerRow;
    private int numBitsPerPixel;
    private int numBitsPerPixelComponent;
    private int imageWidth;
    private int imageHeight;
    private String colorModelCG;
    private String alphaInfo;
    private String bitmapInfo;
    private int videoWidth;
    private int videoHeight;
    private long videoDuration;
    private ByteBuffer byteBuffer;
    private ColorModel colorModel;
    private byte[] byteArray;
    private boolean useByteArray = false;
    private static boolean debugMode;

    public AVFFrameGrabber(String mediaPath) {
        this.mediaPath = mediaPath;
        if (!nativeLibLoaded) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.log(Level.WARNING, "The AVFoundation based FrameGrabber library could not be loaded");
            }
            return;
        }
        if (mediaPath.startsWith("file:///")) {
            this.mediaPath = mediaPath.substring(5);
        }
        this.id = this.initNativeAsset(this.mediaPath);
        if (this.id > 0L) {
            this.fieldsInited = true;
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.warning("The AVFoundation based FrameGrabber could not be initialized");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized BufferedImage getVideoFrameImage(long sampleTime) {
        if (!this.fieldsInited) {
            if (!LOG.isLoggable(Level.WARNING)) return null;
            LOG.warning("No Image: the FrameGrabber was not correctly initialized");
            return null;
        }
        if (this.numBytesPerFrame == 0) {
            this.numBytesPerFrame = this.numBytesPerRow * this.imageHeight;
        }
        int numBytes = 0;
        if (this.useByteArray) {
            if (this.byteArray == null) {
                this.byteArray = new byte[this.numBytesPerFrame];
            }
            numBytes = this.grabVideoFrameBA(this.id, sampleTime, this.byteArray);
        } else {
            if (this.byteBuffer == null) {
                this.byteBuffer = ByteBuffer.allocateDirect(this.numBytesPerFrame);
            } else {
                this.byteBuffer.position(0);
            }
            numBytes = this.grabVideoFrame(this.id, sampleTime, this.byteBuffer);
        }
        if (numBytes > 0) {
            try {
                byte[] dataBytes = null;
                if (this.useByteArray) {
                    dataBytes = this.byteArray;
                } else if (this.byteBuffer.hasArray()) {
                    dataBytes = this.byteBuffer.array();
                } else {
                    dataBytes = new byte[numBytes];
                    this.byteBuffer.get(dataBytes, 0, numBytes);
                }
                DataBufferByte dataBufferByte = new DataBufferByte(dataBytes, numBytes);
                WritableRaster raster = Raster.createInterleavedRaster(dataBufferByte, this.imageWidth, this.imageHeight, this.numBytesPerRow, this.numBitsPerPixel / this.numBitsPerPixelComponent, this.getBandOffsets(), null);
                if (this.colorModel != null) return new BufferedImage(this.colorModel, raster, true, null);
                this.colorModel = this.createCorrespondingColorModel();
                return new BufferedImage(this.colorModel, raster, true, null);
            }
            catch (Throwable t) {
                if (!LOG.isLoggable(Level.WARNING)) return null;
                LOG.warning("Error converting frame bytes to Java image: " + t.getMessage());
                return null;
            }
        } else {
            if (!LOG.isLoggable(Level.WARNING)) return null;
            LOG.warning("Error retrieving frame bytes from the AVFoundation image generator ");
        }
        return null;
    }

    private ColorModel createCorrespondingColorModel() {
        ComponentColorModel comModel = new ComponentColorModel(ColorSpace.getInstance(1000), true, true, 1, 0);
        return comModel;
    }

    private int[] getBandOffsets() {
        if (!isAarch64) {
            return new int[]{1, 2, 3, 0};
        }
        return new int[]{2, 1, 0, 3};
    }

    public int grabVideoFrame(long sampleTime, ByteBuffer buffer) {
        if (!this.fieldsInited) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("No pixel bytes: the FrameGrabber was not correctly initialized");
            }
            return 0;
        }
        return this.grabVideoFrame(this.id, sampleTime, buffer);
    }

    public int grabVideoFrameByteArray(long sampleTime, byte[] byteArray) {
        if (!this.fieldsInited) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("No pixel bytes: the FrameGrabber was not correctly initialized");
            }
            return 0;
        }
        return this.grabVideoFrameBA(this.id, sampleTime, byteArray);
    }

    public boolean saveFrameNativeAVF(String imageURL, long sampleTime) {
        if (!this.fieldsInited) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Could not save the image: the FrameGrabber was not correctly initialized");
            }
            return false;
        }
        return this.saveFrameNativeAVF(this.id, imageURL, sampleTime);
    }

    public void release() {
        if (this.id > 0L) {
            this.release(this.id);
        }
    }

    public static void enableDebugMode(boolean enable) {
        debugMode = enable;
        AVFFrameGrabber.setDebugMode(debugMode);
    }

    static native void initLog(String var0, String var1);

    private native long initNativeAsset(String var1);

    private native int grabVideoFrame(long var1, long var3, ByteBuffer var5);

    private native int grabVideoFrameBA(long var1, long var3, byte[] var5);

    private native boolean saveFrameNativeAVF(long var1, String var3, long var4);

    private native void release(long var1);

    private static native void setDebugMode(boolean var0);

    public int getNumBytesPerFrame() {
        return this.numBytesPerFrame;
    }

    public int getNumBytesPerRow() {
        return this.numBytesPerRow;
    }

    public int getNumBitsPerPixel() {
        return this.numBitsPerPixel;
    }

    public int getNumBitsPerPixelComponent() {
        return this.numBitsPerPixelComponent;
    }

    public int getImageWidth() {
        return this.imageWidth;
    }

    public int getImageHeight() {
        return this.imageHeight;
    }

    public String getColorModelCG() {
        return this.colorModelCG;
    }

    public int getVideoWidth() {
        return this.videoWidth;
    }

    public int getVideoHeight() {
        return this.videoHeight;
    }

    public long getVideoDuration() {
        return this.videoDuration;
    }

    public boolean isUseByteArray() {
        return this.useByteArray;
    }

    public void setUseByteArray(boolean useByteArray) {
        this.useByteArray = useByteArray;
    }

    static {
        String osArch;
        block16: {
            block15: {
                block14: {
                    LOG = Logger.getLogger("NativeLogger");
                    nativeLibLoaded = false;
                    nativeLogLoaded = false;
                    isAarch64 = false;
                    try {
                        System.loadLibrary("JNIUtil");
                        nativeLogLoaded = true;
                    }
                    catch (UnsatisfiedLinkError ule) {
                        if (LOG.isLoggable(Level.WARNING)) {
                            LOG.log(Level.WARNING, "Could not load native utility library (libJNIUtil.dylib): " + ule.getMessage());
                        }
                    }
                    catch (Throwable t) {
                        if (!LOG.isLoggable(Level.WARNING)) break block14;
                        LOG.log(Level.WARNING, "Could not load native utility library (libJNIUtil.dylib): " + t.getMessage());
                    }
                }
                try {
                    System.loadLibrary("AVFFrameGrabber");
                    nativeLibLoaded = true;
                }
                catch (SecurityException se) {
                    if (LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "Could not load native library (libAVFFrameGrabber.dylib): " + se.getMessage());
                    }
                }
                catch (UnsatisfiedLinkError ule) {
                    if (LOG.isLoggable(Level.WARNING)) {
                        LOG.log(Level.WARNING, "Could not load native library (libAVFFrameGrabber.dylib): " + ule.getMessage());
                    }
                }
                catch (Throwable t) {
                    if (!LOG.isLoggable(Level.WARNING)) break block15;
                    LOG.log(Level.WARNING, "Could not load native library (libAVFFrameGrabber.dylib): " + t.getMessage());
                }
            }
            if (nativeLogLoaded && nativeLibLoaded) {
                try {
                    AVFFrameGrabber.initLog("nl/mpi/jni/NativeLogger", "nlog");
                }
                catch (Throwable thr) {
                    if (!LOG.isLoggable(Level.WARNING)) break block16;
                    LOG.log(Level.WARNING, "Error while configuring native logging: " + thr.getMessage());
                }
            }
        }
        if ((osArch = System.getProperty("os.arch")) != null && osArch.length() > 0 && osArch.toLowerCase().matches("a.+64")) {
            isAarch64 = true;
        }
        debugMode = false;
    }
}

