/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.avf.player;

import java.awt.Component;
import java.awt.Dimension;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.mpi.avf.player.AVFBasePlayer;
import nl.mpi.avf.player.JAVFPlayerException;

public class AVFBaseMediaPlayer {
    static final Logger LOG = Logger.getLogger("NativeLogger");
    AVFBasePlayer avfPlayer;
    String mediaPath;
    float videoScaleFactor = 1.0f;
    int vdx = 0;
    int vdy = 0;
    double vxToTlcPerc = 0.0;
    double vyToTlcPerc = 0.0;
    Dimension originalSize = null;
    double durationSec = -1.0;
    long durationMs = -1L;
    double frameDurationSec = -1.0;
    double frameRate = -1.0;

    public AVFBaseMediaPlayer(String mediaPath) throws JAVFPlayerException {
        if (mediaPath == null) {
            throw new JAVFPlayerException("The media path is null");
        }
        this.mediaPath = mediaPath;
        if (LOG.getLevel() != null) {
            AVFBasePlayer.setLogLevel(LOG.getLevel());
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("Media URL for AVFPlayer: " + this.mediaPath);
        }
        this.initMediaPlayer();
    }

    public Component getVisualComponent() {
        return null;
    }

    void initMediaPlayer() throws JAVFPlayerException {
        try {
            this.avfPlayer = new AVFBasePlayer(this.mediaPath);
        }
        catch (JAVFPlayerException je) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("Cannot create %s, message: %s", AVFBasePlayer.class.getName(), je.getMessage()));
            }
            throw je;
        }
    }

    public void setDebugMode(boolean debugMode) {
        AVFBasePlayer.enableDebugMode(debugMode);
    }

    public void start() {
        if (this.avfPlayer != null) {
            this.avfPlayer.start();
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Cannot start AVFPlayer: null");
        }
    }

    public void stop() {
        if (this.avfPlayer != null) {
            this.avfPlayer.stop();
            this.avfPlayer.removeStopTime();
        } else if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Cannot stop AVFPlayer: null");
        }
    }

    void stopAndWait() {
        if (this.avfPlayer.isPlaying()) {
            this.stop();
            int count = 0;
            while (this.avfPlayer.isPlaying() && count < 50) {
                try {
                    Thread.sleep(5L);
                    ++count;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void frameForward(boolean toFrameBegin) {
        double curTime;
        double targetTime;
        if (this.avfPlayer.isPlaying()) {
            this.stopAndWait();
        }
        if ((targetTime = (curTime = this.avfPlayer.getMediaTimeSeconds()) + this.avfPlayer.getTimePerFrame() / 1000.0) > this.avfPlayer.getDurationSeconds()) {
            targetTime = this.avfPlayer.getDurationSeconds();
        }
        this.setMediaTimeSeconds(targetTime);
    }

    public void frameBackward(boolean toFrameBegin) {
        double curTime;
        double targetTime;
        if (this.avfPlayer.isPlaying()) {
            this.stopAndWait();
        }
        if ((targetTime = (curTime = this.avfPlayer.getMediaTimeSeconds()) - this.avfPlayer.getTimePerFrame() / 1000.0) < 0.0) {
            targetTime = 0.0;
        }
        this.setMediaTimeSeconds(targetTime);
    }

    public void setMediaTime(long mediaTimeMS) {
        if (this.avfPlayer.isPlaying()) {
            this.stopAndWait();
        }
        this.avfPlayer.setMediaTime(mediaTimeMS);
    }

    public void setMediaTimeSeconds(double mediaTime) {
        if (this.avfPlayer.isPlaying()) {
            this.stopAndWait();
        }
        this.avfPlayer.setMediaTimeSeconds(mediaTime);
    }

    public void setStopTime(long stopTimeMS) {
        if (this.avfPlayer.isPlaying()) {
            this.stopAndWait();
        }
        this.avfPlayer.setStopTime(stopTimeMS);
    }

    public void setStopTimeSecond(double stopTimeSec) {
        if (this.avfPlayer.isPlaying()) {
            this.stopAndWait();
        }
        this.avfPlayer.setStopTimeSeconds(stopTimeSec);
    }

    public void removeStopTime() {
        if (this.avfPlayer.isPlaying()) {
            this.stopAndWait();
        }
        this.avfPlayer.removeStopTime();
    }

    public void setRate(float rate) {
        this.avfPlayer.setRate(rate);
    }

    public void setVolume(float volume) {
        this.avfPlayer.setVolume(volume);
    }

    public void deletePlayer() {
        this.avfPlayer.deletePlayer();
    }

    public boolean isPlaying() {
        return this.avfPlayer.isPlaying();
    }

    public long getMediaTime() {
        return this.avfPlayer.getMediaTime();
    }

    public double getMediaTimeSecond() {
        return this.avfPlayer.getMediaTimeSeconds();
    }

    public long getDuration() {
        if (this.durationMs > 0L) {
            return this.durationMs;
        }
        this.durationMs = this.avfPlayer.getDuration();
        return this.durationMs;
    }

    public double getDurationSeconds() {
        if (this.durationSec > 0.0) {
            return this.durationSec;
        }
        this.durationSec = this.avfPlayer.getDurationSeconds();
        return this.durationSec;
    }

    public double getFrameDuration() {
        if (this.frameDurationSec > 0.0) {
            return this.frameDurationSec;
        }
        this.frameDurationSec = this.avfPlayer.getTimePerFrame();
        return this.frameDurationSec;
    }

    public double getFrameRate() {
        if (this.frameRate > 0.0) {
            return this.frameRate;
        }
        this.frameRate = this.avfPlayer.getFrameRate();
        return this.frameRate;
    }

    public float getRate() {
        return this.avfPlayer.getRate();
    }

    public float getVolume() {
        return this.avfPlayer.getVolume();
    }

    public Dimension getOriginalSize() {
        if (this.originalSize != null) {
            return this.originalSize;
        }
        this.originalSize = this.avfPlayer.getOriginalSize();
        return this.originalSize;
    }

    public void setVideoScaleFactor(float scaleFactor) {
        this.videoScaleFactor = scaleFactor;
    }

    public float getVideoScaleFactor() {
        return this.videoScaleFactor;
    }

    public void repaintVideo() {
    }

    public void setVideoBounds(int x, int y, int w, int h) {
        if (this.videoScaleFactor == 1.0f) {
            return;
        }
    }

    public int[] getVideoBounds() {
        return null;
    }

    public void moveVideoPos(int dx, int dy) {
    }
}

