/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.avf.player;

import java.awt.Image;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.mpi.avf.player.JAVFImageProducer;
import nl.mpi.avf.player.JAVFMediaPlayer;
import nl.mpi.avf.player.TimedImage;
import nl.mpi.avf.player.TimedImageSequence;

public class JAVFVideoLoadController {
    private final Logger LOG = Logger.getLogger("NativeLogger");
    private final JAVFMediaPlayer javfMediaPlayer;
    private static final int BUFFER_LENGTH_MS = 500;
    private int bufferLengthMs = 500;
    private double bufferLengthSeconds = (double)this.bufferLengthMs / 1000.0;
    private int numBytesPerFrame = 0;
    int numFramesPerBuffer = 0;
    private ByteBuffer loadByteBuffer;
    private final ReentrantLock byteBufferLock = new ReentrantLock();
    private TimedImageSequence headSequence;
    private TimedImageSequence bodySequence;
    private TimedImageSequence tailSequence;
    private final ReentrantLock sequencesLock = new ReentrantLock();
    private JAVFImageProducer imageProducer;
    private BackgroundLoader sequenceLoader;

    public JAVFVideoLoadController(JAVFMediaPlayer javfMediaPlayer) {
        this(javfMediaPlayer, 500);
    }

    public JAVFVideoLoadController(JAVFMediaPlayer javfMediaPlayer, int bufferLengthMs) {
        this.javfMediaPlayer = javfMediaPlayer;
        this.bufferLengthMs = bufferLengthMs;
        this.bufferLengthSeconds = (double)this.bufferLengthMs / 1000.0;
        this.headSequence = new TimedImageSequence();
        this.bodySequence = new TimedImageSequence();
        this.tailSequence = new TimedImageSequence();
        this.imageProducer = new JAVFImageProducer();
        this.init();
    }

    private void init() {
        if (this.javfMediaPlayer != null) {
            this.headSequence.setMediaDuration(this.javfMediaPlayer.getDurationSeconds());
            this.bodySequence.setMediaDuration(this.javfMediaPlayer.getDurationSeconds());
            this.tailSequence.setMediaDuration(this.javfMediaPlayer.getDurationSeconds());
            this.numBytesPerFrame = this.javfMediaPlayer.getBytesPerFrame();
            this.numFramesPerBuffer = (int)((double)this.bufferLengthMs / this.javfMediaPlayer.getFrameDuration());
            this.loadByteBuffer = ByteBuffer.allocateDirect(this.numBytesPerFrame * this.numFramesPerBuffer);
            if (this.LOG.isLoggable(Level.INFO)) {
                this.LOG.info(String.format("Byte Buffer Size (Mb): %f", Float.valueOf((float)(this.numBytesPerFrame * this.numFramesPerBuffer) / 1048576.0f)));
            }
            this.preloadBuffer(0.01, this.bodySequence);
            this.javfMediaPlayer.getVideoComponent().setImage(this.bodySequence.getFirstTime(), this.bodySequence.getImageForTime(this.bodySequence.getFirstTime()));
            double lt = this.bodySequence.getLastTime();
            new BackgroundLoader(lt, this.headSequence).start();
        }
    }

    public JAVFImageProducer getImageProducer() {
        return this.imageProducer;
    }

    public Image getImageForTime(long time) {
        double tt = (double)time / 1000.0;
        if (this.bodySequence.hasTime(tt)) {
            return this.bodySequence.getImageForTime(tt);
        }
        if (this.headSequence.hasTime(tt)) {
            return this.headSequence.getImageForTime(tt);
        }
        if (this.tailSequence.hasTime(tt)) {
            return this.tailSequence.getImageForTime(tt);
        }
        return null;
    }

    public void prepareForPlay(double time) {
        if (this.bodySequence.hasTime(time)) {
            return;
        }
        if (this.headSequence.hasTime(time)) {
            this.swapSequences(true);
        }
        if (this.tailSequence.hasTime(time)) {
            this.swapSequences(false);
        }
        this.preloadBuffer(time, this.bodySequence);
    }

    public void preloadHeadBufferCond() {
        if (this.headSequence.getFirstTime() - this.bodySequence.getLastTime() <= this.javfMediaPlayer.getFrameDuration() && (this.sequenceLoader == null || !this.sequenceLoader.isAlive())) {
            this.sequenceLoader = new BackgroundLoader(this.bodySequence.getLastTime(), this.headSequence);
            this.sequenceLoader.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeUpdateSeconds(double timeInSeconds) {
        double curBT;
        if (this.LOG.isLoggable(Level.FINER)) {
            this.LOG.finer("Time update: " + timeInSeconds);
        }
        if (timeInSeconds >= (curBT = this.javfMediaPlayer.getVideoComponent().getCurrentImageTimeSeconds()) && timeInSeconds < curBT + this.javfMediaPlayer.getFrameDuration() / 1000.0) {
            if (this.LOG.isLoggable(Level.FINE)) {
                this.LOG.fine(String.format("No frame update needed, current image: %d, new media time %d", curBT, this.javfMediaPlayer.getFrameDuration()));
            }
            return;
        }
        int rotateDir = 0;
        this.sequencesLock.lock();
        if (this.LOG.isLoggable(Level.FINE)) {
            this.LOG.fine("Acquired sequences lock");
        }
        try {
            TimedImage ti = this.bodySequence.getTimedImageForTime(timeInSeconds);
            if (ti != null) {
                if (this.LOG.isLoggable(Level.FINER)) {
                    this.LOG.finer("Time update 3: " + ti.t);
                }
                this.javfMediaPlayer.getVideoComponent().setImage(ti);
                return;
            }
            if (this.LOG.isLoggable(Level.FINER)) {
                this.LOG.finer("Time update 4: next image is from head sequence");
            }
            if ((ti = this.headSequence.getTimedImageForTime(timeInSeconds)) != null) {
                this.javfMediaPlayer.getVideoComponent().setImage(ti);
                rotateDir = 1;
            } else {
                ti = this.tailSequence.getTimedImageForTime(timeInSeconds);
                if (ti != null) {
                    this.javfMediaPlayer.getVideoComponent().setImage(ti);
                    rotateDir = -1;
                }
            }
            if (this.LOG.isLoggable(Level.FINER)) {
                this.LOG.finer("Update 5: next image is " + ti + "  Rotate: " + rotateDir);
            }
        }
        finally {
            if (this.LOG.isLoggable(Level.FINER)) {
                this.LOG.finer("Releasing sequences lock");
            }
            this.sequencesLock.unlock();
        }
        if (rotateDir == 1) {
            if (this.LOG.isLoggable(Level.FINER)) {
                this.LOG.finer("Rotating sequence forward");
            }
            double lastTime = this.headSequence.getLastTime();
            this.swapSequences(true);
            new BackgroundLoader(lastTime, this.headSequence).start();
        } else if (rotateDir == -1) {
            if (this.LOG.isLoggable(Level.FINER)) {
                this.LOG.finer("Rotating sequence backward");
            }
            this.swapSequences(false);
            double firstTime = this.bodySequence.getFirstTime();
            new BackgroundLoader(firstTime - this.bufferLengthSeconds, this.tailSequence).start();
        } else {
            double seqStartTime;
            if (this.LOG.isLoggable(Level.FINER)) {
                this.LOG.finer("Required image in none of the sequences, loading new sequence");
            }
            seqStartTime = (seqStartTime = timeInSeconds - (double)this.bufferLengthMs / 2000.0) >= 0.0 ? seqStartTime : 0.0;
            this.preloadBuffer(seqStartTime, this.bodySequence);
            TimedImage ti = this.bodySequence.getTimedImageForTime(timeInSeconds);
            if (ti != null) {
                if (this.LOG.isLoggable(Level.FINER)) {
                    this.LOG.finer("Update 6: next image is " + ti.t);
                }
                this.javfMediaPlayer.getVideoComponent().setImage(ti);
            }
            double lastTime = this.bodySequence.getLastTime();
            new BackgroundLoader(lastTime, this.headSequence).start();
        }
    }

    public void timeUpdateMs(long timeInMs) {
        this.timeUpdateSeconds((double)timeInMs / 1000.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preloadBuffer(double fromTime, TimedImageSequence targetSequence) {
        if (fromTime < 0.0) {
            if (this.LOG.isLoggable(Level.FINE)) {
                this.LOG.fine("Illegal start time to load images from: " + fromTime);
            }
            return;
        }
        if (this.loadByteBuffer == null) {
            this.init();
        }
        if (this.javfMediaPlayer != null) {
            this.byteBufferLock.lock();
            try {
                Image[] images;
                double[] frameSequence = this.javfMediaPlayer.getVideoFrameSequenceSeconds(fromTime, fromTime + this.bufferLengthSeconds, this.loadByteBuffer);
                if (frameSequence != null && (images = this.imageProducer.produceImagesFromBuffer(this.loadByteBuffer, this.numBytesPerFrame, this.numFramesPerBuffer, this.javfMediaPlayer.getVideoImageWidth(), this.javfMediaPlayer.getVideoImageHeight())) != null) {
                    targetSequence.setSequence(frameSequence, images);
                }
            }
            finally {
                this.byteBufferLock.unlock();
            }
        }
    }

    private void swapSequences(boolean forward) {
        if (this.LOG.isLoggable(Level.FINE)) {
            String s = forward ? "forward" : "backward";
            this.LOG.fine(String.format("Swapping image sequences in %s direction", s));
        }
        this.sequencesLock.lock();
        if (this.LOG.isLoggable(Level.FINER)) {
            this.LOG.finer("Swap sequence acquired lock");
        }
        try {
            if (forward) {
                this.bodySequence.copySequenceTo(this.tailSequence);
                this.headSequence.copySequenceTo(this.bodySequence);
            } else {
                this.bodySequence.copySequenceTo(this.headSequence);
                this.tailSequence.copySequenceTo(this.bodySequence);
            }
        }
        finally {
            this.sequencesLock.unlock();
            if (this.LOG.isLoggable(Level.FINER)) {
                this.LOG.finer("Swap sequence released lock");
            }
        }
    }

    public void close() {
        if (this.sequenceLoader != null && this.sequenceLoader.isAlive()) {
            this.sequenceLoader.interrupt();
            this.sequenceLoader = null;
        }
        this.bodySequence.clear();
        this.headSequence.clear();
        this.tailSequence.clear();
        this.bodySequence = null;
        this.headSequence = null;
        this.tailSequence = null;
    }

    private class BackgroundLoader
    extends Thread {
        private double fromTime;
        private TimedImageSequence tiSequence;

        public BackgroundLoader(double fromTime, TimedImageSequence tiSequence) {
            this.setPriority(1);
            this.fromTime = fromTime;
            this.tiSequence = tiSequence;
        }

        @Override
        public void run() {
            if (JAVFVideoLoadController.this.LOG.isLoggable(Level.FINE)) {
                JAVFVideoLoadController.this.LOG.fine("Background loading from time: " + this.fromTime);
            }
            JAVFVideoLoadController.this.preloadBuffer(this.fromTime, this.tiSequence);
        }
    }
}

