/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.avf.player;

import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.AffineTransform;
import nl.mpi.avf.player.JAVFComponent;
import nl.mpi.avf.player.TimedImage;

public class JAVFVisualCanvas
extends Canvas
implements JAVFComponent {
    private ComponentListener compListener;
    private Dimension naturalVideoSize;
    private AffineTransform pixelsToVideoSizeTransform = null;
    private boolean pixelToImageTransformChecked = false;
    private boolean paintBackground = false;
    private Image currentImage;
    private double currentTimeSeconds = -1.0;
    private long currentTime = -1L;
    private final double MS_SEC = 1000.0;
    private float forcedAspectRatio = -1.0f;
    private AffineTransform displayTransform = null;

    public JAVFVisualCanvas() {
        this.initCanvas();
    }

    public JAVFVisualCanvas(GraphicsConfiguration gc) {
        this.initCanvas();
    }

    private void initCanvas() {
        this.setBackground(Color.CYAN);
        this.compListener = new SelfListener();
        this.addComponentListener(this.compListener);
    }

    @Override
    public void setImage(long time, Image image) {
        this.currentTime = time;
        this.currentTimeSeconds = (double)time / 1000.0;
        this.currentImage = image;
        if (!this.pixelToImageTransformChecked) {
            this.calculatePixelToVideoImageTransform();
        }
        if (this.displayTransform == null) {
            this.calculateTransform();
        }
        this.repaint();
    }

    @Override
    public void setNaturalVideoSize(Dimension naturalSize) {
        if (naturalSize != null) {
            this.naturalVideoSize = new Dimension(naturalSize);
            if (!this.pixelToImageTransformChecked) {
                this.calculatePixelToVideoImageTransform();
            }
            this.displayTransform = null;
        }
    }

    @Override
    public void setImage(double timeInSeconds, Image image) {
        this.currentTimeSeconds = timeInSeconds;
        this.currentTime = (long)(timeInSeconds * 1000.0);
        this.currentImage = image;
        if (!this.pixelToImageTransformChecked) {
            this.calculatePixelToVideoImageTransform();
        }
        if (this.displayTransform == null) {
            this.calculateTransform();
        }
        this.repaint();
    }

    @Override
    public void setImage(TimedImage timedImage) {
        if (timedImage != null) {
            this.setImage(timedImage.t, timedImage.img);
        }
    }

    @Override
    public long getCurrentImageTime() {
        return this.currentTime;
    }

    @Override
    public double getCurrentImageTimeSeconds() {
        return this.currentTimeSeconds;
    }

    @Override
    public Image getCurrentImage() {
        return this.currentImage;
    }

    @Override
    public void setAspectRatio(float aspectRatio) {
        if (aspectRatio == this.forcedAspectRatio) {
            return;
        }
        this.forcedAspectRatio = aspectRatio;
        this.calculatePixelToVideoImageTransform();
    }

    @Override
    public void resetAspectRatio() {
        this.forcedAspectRatio = -1.0f;
        this.calculatePixelToVideoImageTransform();
    }

    @Override
    public void paint(Graphics g) {
        if (this.paintBackground) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        Graphics2D g2d = (Graphics2D)g;
        if (this.currentImage != null) {
            if (this.displayTransform == null) {
                this.calculateTransform();
            }
            if (this.displayTransform == null) {
                g2d.drawImage(this.currentImage, 0, 0, null);
            } else {
                g2d.drawImage(this.currentImage, this.displayTransform, null);
            }
        }
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    private void calculatePixelToVideoImageTransform() {
        if (this.naturalVideoSize != null && this.currentImage != null) {
            if (this.naturalVideoSize.width != this.currentImage.getWidth(null) || this.naturalVideoSize.height != this.currentImage.getHeight(null)) {
                double videoImageSW = this.naturalVideoSize.getWidth() / (double)this.currentImage.getWidth(null);
                double videoImageSH = this.naturalVideoSize.getHeight() / (double)this.currentImage.getHeight(null);
                this.pixelsToVideoSizeTransform = this.forcedAspectRatio == -1.0f ? AffineTransform.getScaleInstance(videoImageSW, videoImageSH) : AffineTransform.getScaleInstance((double)this.forcedAspectRatio / videoImageSW, videoImageSH);
            } else if (this.forcedAspectRatio != -1.0f) {
                double imgAR = (double)this.currentImage.getWidth(null) / (double)this.currentImage.getHeight(null);
                this.pixelsToVideoSizeTransform = AffineTransform.getScaleInstance((double)this.forcedAspectRatio / imgAR, 1.0);
            }
            this.pixelToImageTransformChecked = true;
        } else {
            if (this.forcedAspectRatio != -1.0f && this.currentImage != null) {
                double imgAR = (double)this.currentImage.getWidth(null) / (double)this.currentImage.getHeight(null);
                this.pixelsToVideoSizeTransform = imgAR != (double)this.forcedAspectRatio ? AffineTransform.getScaleInstance((double)this.forcedAspectRatio / imgAR, 1.0) : null;
            }
            this.pixelsToVideoSizeTransform = null;
        }
    }

    private void calculateTransform() {
        if (this.currentImage == null) {
            return;
        }
        double srcWidth = 0.0;
        double srcHeight = 0.0;
        if (this.naturalVideoSize != null) {
            srcWidth = this.naturalVideoSize.getWidth();
            srcHeight = this.naturalVideoSize.getHeight();
        } else {
            srcWidth = this.currentImage.getWidth(null);
            srcHeight = this.currentImage.getHeight(null);
        }
        int w = this.getWidth();
        int h = this.getHeight();
        if (w > 0 && h > 0 && srcWidth > 0.0 && srcHeight > 0.0) {
            double vs = (double)h / srcHeight;
            double hs = (double)w / srcWidth;
            if (vs > hs) {
                vs = hs;
            } else if (hs > vs) {
                hs = vs;
            }
            if (this.pixelsToVideoSizeTransform != null) {
                hs *= this.pixelsToVideoSizeTransform.getScaleX();
                vs *= this.pixelsToVideoSizeTransform.getScaleY();
            }
            double xImg = ((double)w - hs * (double)this.currentImage.getWidth(null)) / 2.0;
            double yImg = ((double)h - vs * (double)this.currentImage.getHeight(null)) / 2.0;
            this.displayTransform = new AffineTransform(hs, 0.0, 0.0, vs, xImg, yImg);
        } else {
            this.displayTransform = null;
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.naturalVideoSize != null) {
            return this.naturalVideoSize;
        }
        if (this.currentImage != null) {
            return new Dimension(this.currentImage.getWidth(null), this.currentImage.getHeight(null));
        }
        return super.getPreferredSize();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.calculateTransform();
        this.repaint();
    }

    @Override
    public void repaint() {
        super.repaint();
    }

    @Override
    protected AWTEvent coalesceEvents(AWTEvent existingEvent, AWTEvent newEvent) {
        return super.coalesceEvents(existingEvent, newEvent);
    }

    private class SelfListener
    extends ComponentAdapter {
        private SelfListener() {
        }

        @Override
        public void componentResized(ComponentEvent e) {
            JAVFVisualCanvas.this.calculateTransform();
            JAVFVisualCanvas.this.repaint();
        }

        @Override
        public void componentShown(ComponentEvent e) {
            JAVFVisualCanvas.this.calculateTransform();
            JAVFVisualCanvas.this.repaint();
        }
    }
}

