/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.jmmf;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import nl.mpi.jmmf.DIBInfoHeader;
import nl.mpi.jmmf.JMMFException;

public class JMMFPlayer {
    private static final System.Logger LOG;
    private static final int MS_TO_REF_TIME = 10000;
    public static final int STATE_STOP = 0;
    public static final int STATE_PAUSE = 1;
    public static final int STATE_RUN = 2;
    private static String initError;
    private static boolean nativeLogLoaded;
    private String mediaPath;
    private long id = -1L;
    private Component visualComponent;
    private boolean stopTimeSupported = true;
    private boolean allowVideoScaling = true;
    private float videoScaleFactor = 1.0f;
    private int vx = 0;
    private int vy = 0;
    private int vw = 0;
    private int vh = 0;
    private int vdx = 0;
    private int vdy = 0;
    private boolean synchronousMode = false;

    public JMMFPlayer() throws JMMFException {
        if (initError != null) {
            throw new JMMFException(initError);
        }
        this.id = this.initPlayer(this.synchronousMode);
        if (this.id > 0L) {
            if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
                LOG.log(System.Logger.Level.DEBUG, "The native JMMFPlayer was initialized successfully");
            }
        } else {
            if (LOG.isLoggable(System.Logger.Level.WARNING)) {
                LOG.log(System.Logger.Level.WARNING, "The native JMMFPlayer could not be initialized");
            }
            throw new JMMFException("The native JMMFPlayer could not be initialized.");
        }
    }

    public JMMFPlayer(boolean synchronous) throws JMMFException {
        if (initError != null) {
            throw new JMMFException(initError);
        }
        this.synchronousMode = synchronous;
        this.id = this.initPlayer(this.synchronousMode);
        if (this.id > 0L) {
            if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
                LOG.log(System.Logger.Level.DEBUG, String.format("The native JMMFPlayer was initialized in %s mode successfully", synchronous ? "synchronous" : "asynchronous"));
            }
        } else {
            if (LOG.isLoggable(System.Logger.Level.WARNING)) {
                LOG.log(System.Logger.Level.WARNING, String.format("The native JMMFPlayer could not be initialized (in %s mode)", synchronous ? "synchronous" : "asynchronous"));
            }
            throw new JMMFException(String.format("The native JMMFPlayer could not be initialized (in %s mode)", synchronous ? "synchronous" : "asynchronous"));
        }
    }

    public JMMFPlayer(String mediaPath) throws JMMFException {
        if (initError != null) {
            throw new JMMFException(initError);
        }
        this.mediaPath = mediaPath;
        this.id = this.initWithFile(this.mediaPath, this.synchronousMode);
        if (this.id > 0L) {
            if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
                LOG.log(System.Logger.Level.DEBUG, String.format("The native JMMFPlayer was initialized successfully for %s", mediaPath));
            }
        } else {
            if (LOG.isLoggable(System.Logger.Level.WARNING)) {
                LOG.log(System.Logger.Level.WARNING, String.format("The native JMMFPlayer could not be initialized for %s", mediaPath));
            }
            throw new JMMFException(String.format("The native JMMFPlayer could not be initialized for %s", mediaPath));
        }
    }

    public JMMFPlayer(String mediaPath, boolean synchronous) throws JMMFException {
        if (initError != null) {
            throw new JMMFException(initError);
        }
        this.mediaPath = mediaPath;
        this.synchronousMode = synchronous;
        this.id = this.initWithFile(this.mediaPath, this.synchronousMode);
        if (this.id > 0L) {
            if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
                LOG.log(System.Logger.Level.DEBUG, String.format("The native JMMFPlayer was initialized successfully for %s in %s mode", mediaPath, synchronous ? "synchronous" : "asynchronous"));
            }
        } else {
            if (LOG.isLoggable(System.Logger.Level.WARNING)) {
                LOG.log(System.Logger.Level.WARNING, String.format("The native JMMFPlayer could not be initialized for %s (in %s mode)", mediaPath, synchronous ? "synchronous" : "asynchronous"));
            }
            throw new JMMFException(String.format("The native JMMFPlayer could not be initialized for %s (in %s mode)", mediaPath, synchronous ? "synchronous" : "asynchronous"));
        }
    }

    public boolean isSynchronousMode() {
        return this.synchronousMode;
    }

    public void start() {
        this.start(this.id);
    }

    public void stop() {
        this.pause(this.id);
    }

    public void pause() {
        this.pause(this.id);
    }

    public boolean isPlaying() {
        return this.isPlaying(this.id);
    }

    public int getState() {
        return this.getState(this.id);
    }

    public void setRate(float rate) {
        this.setRate(this.id, rate);
    }

    public float getRate() {
        return this.getRate(this.id);
    }

    public void setVolume(float volume) {
        this.setVolume(this.id, volume);
    }

    public float getVolume() {
        return this.getVolume(this.id);
    }

    public void setMediaTime(long time) {
        this.setMediaTime(this.id, 10000L * time);
    }

    public long getMediaTime() {
        return this.getMediaTime(this.id) / 10000L;
    }

    public long getDuration() {
        return this.getDuration(this.id) / 10000L;
    }

    public double nextFrame(boolean atFrameBegin) {
        return this.nextFrameInternal(this.id, atFrameBegin) / 10000.0;
    }

    public double previousFrame(boolean atFrameBegin) {
        return this.previousFrameInternal(this.id, atFrameBegin) / 10000.0;
    }

    public boolean isStopTimeSupported() {
        return this.stopTimeSupported;
    }

    public void setStopTime(long time) {
        block3: {
            if (this.stopTimeSupported) {
                try {
                    this.setStopTime(this.id, 10000L * time);
                }
                catch (JMMFException jds) {
                    this.stopTimeSupported = false;
                    if (!LOG.isLoggable(System.Logger.Level.WARNING)) break block3;
                    LOG.log(System.Logger.Level.WARNING, jds.getMessage());
                }
            }
        }
    }

    public long getStopTime() {
        if (this.stopTimeSupported) {
            return this.getStopTime(this.id) / 10000L;
        }
        return 0L;
    }

    public double getFrameRate() {
        return this.getFrameRate(this.id);
    }

    public double getTimePerFrame() {
        return this.getTimePerFrame(this.id) * 1000.0;
    }

    public float getAspectRatio() {
        return this.getAspectRatio(this.id);
    }

    public Dimension getOriginalSize() {
        return this.getOriginalSize(this.id);
    }

    public boolean isVisualMedia() {
        return this.isVisualMedia(this.id);
    }

    public int[] getPreferredAspectRatio() {
        return this.getPreferredAspectRatio(this.id);
    }

    public int getSourceHeight() {
        return this.getSourceHeight(this.id);
    }

    public int getSourceWidth() {
        return this.getSourceWidth(this.id);
    }

    public void setVisualComponent(Component component) {
        if (this.visualComponent == null) {
            this.visualComponent = component;
            this.setVisualComponent(this.id, component);
        } else {
            this.visualComponent = component;
            this.setVisualComponent(this.id, component);
        }
    }

    public Component getVisualComponent() {
        return this.visualComponent;
    }

    public void setVisualComponentSize(int w, int h) {
        this.repositionVideoRect();
    }

    public void setVisible(boolean visible) {
        this.setVisible(this.id, visible);
    }

    public void setVideoSourcePos(float x, float y, float w, float h) {
        this.setVideoSourcePos(this.id, x, y, w, h);
    }

    public void setVideoDestinationPos(int x, int y, int w, int h) {
        this.setVideoDestinationPos(this.id, x, y, w, h);
    }

    public void setVideoSourceAndDestPos(float sx, float sy, float sw, float sh, int x, int y, int w, int h) {
        this.setVideoSourceAndDestPos(this.id, sx, sy, sw, sh, x, y, w, h);
    }

    public int[] getVideoDestinationPos() {
        return this.getVideoDestinationPos(this.id);
    }

    public float getVideoScaleFactor() {
        return this.videoScaleFactor;
    }

    public void setVideoScaleFactor(float videoScaleFactor) {
        this.videoScaleFactor = videoScaleFactor;
        this.repositionVideoRect();
    }

    public void moveVideoPos(int dx, int dy) {
        if (this.videoScaleFactor == 1.0f && this.allowVideoScaling) {
            return;
        }
        this.vdx += dx;
        this.vdy += dy;
        this.repositionVideoRect();
    }

    public int[] getVideoTranslation() {
        if (!this.isVisualMedia() || this.videoScaleFactor == 1.0f) {
            return new int[]{0, 0};
        }
        return new int[]{this.vx, this.vy};
    }

    public int[] getScaledVideoRect() {
        if (!this.isVisualMedia() || this.videoScaleFactor == 1.0f) {
            return new int[]{0, 0};
        }
        return new int[]{this.vw, this.vh};
    }

    public boolean isAllowVideoScaling() {
        return this.allowVideoScaling;
    }

    public void setAllowVideoScaling(boolean allowVideoScaling) {
        this.allowVideoScaling = allowVideoScaling;
    }

    public byte[] getCurrentImageData(DIBInfoHeader dih) {
        return this.getCurrentImage(this.id, dih);
    }

    public byte[] getImageDataAtTime(long time, DIBInfoHeader dih) {
        return this.getImageAtTime(this.id, dih, 10000L * time);
    }

    public void cleanUpOnClose() {
        long startTime;
        int STOP_TO = 7000;
        int CLOSE_TO = 10000;
        boolean stopped = false;
        boolean closed = false;
        if (this.getState(this.id) != PlayerState.STOPPED.value) {
            this.stop(this.id);
            startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < 7000L) {
                block14: {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException ie) {
                        if (!LOG.isLoggable(System.Logger.Level.DEBUG)) break block14;
                        LOG.log(System.Logger.Level.DEBUG, "Interrupted while waiting for player to stop");
                    }
                }
                if (this.getState(this.id) != PlayerState.STOPPED.value) continue;
                if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
                    LOG.log(System.Logger.Level.DEBUG, "Player stopped successfully");
                }
                stopped = true;
                break;
            }
        }
        if (!stopped) {
            // empty if block
        }
        if (this.getState(this.id) != PlayerState.CLOSING.value) {
            this.closeSession(this.id);
            startTime = System.currentTimeMillis();
            while (System.currentTimeMillis() - startTime < 10000L) {
                block15: {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException ie) {
                        if (!LOG.isLoggable(System.Logger.Level.DEBUG)) break block15;
                        LOG.log(System.Logger.Level.DEBUG, "Interrupted while waiting for player to close the session");
                    }
                }
                if (this.getState(this.id) != PlayerState.CLOSED.value) continue;
                if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
                    LOG.log(System.Logger.Level.DEBUG, "Player session successfully closed");
                }
                closed = true;
                break;
            }
        }
        if (!closed) {
            if (LOG.isLoggable(System.Logger.Level.INFO)) {
                LOG.log(System.Logger.Level.INFO, "Error: failed to close the player gracefully");
            }
        } else {
            this.deletePlayer(this.id);
        }
    }

    public long getID() {
        return this.id;
    }

    private void repositionVideoRect() {
        if (this.visualComponent != null && this.allowVideoScaling) {
            int compW = this.visualComponent.getWidth();
            int compH = this.visualComponent.getHeight();
            AffineTransform defTrans = this.visualComponent.getGraphicsConfiguration().getDefaultTransform();
            if (defTrans != null && !defTrans.isIdentity()) {
                compW = (int)Math.round((double)compW * defTrans.getScaleX());
                compH = (int)Math.round((double)compH * defTrans.getScaleY());
            }
            if (this.videoScaleFactor == 1.0f) {
                this.setVideoSourceAndDestPos(0.0f, 0.0f, 1.0f, 1.0f, 0, 0, compW, compH);
            } else {
                this.vw = (int)((float)compW * this.videoScaleFactor);
                this.vh = (int)((float)compH * this.videoScaleFactor);
                this.vx = this.vdx;
                this.vy = this.vdy;
                if (this.vx + this.vw < compW) {
                    this.vx = compW - this.vw;
                }
                if (this.vx > 0) {
                    this.vx = 0;
                }
                if (this.vy + this.vh < compH) {
                    this.vy = compH - this.vh;
                }
                if (this.vy > 0) {
                    this.vy = 0;
                }
                float sx1 = (float)(-this.vx) / (float)this.vw;
                float sy1 = (float)(-this.vy) / (float)this.vh;
                float sx2 = sx1 + (float)compW / (float)this.vw;
                float sy2 = sy1 + (float)compH / (float)this.vh;
                this.setVideoSourceAndDestPos(sx1, sy1, sx2, sy2, 0, 0, compW, compH);
            }
        }
    }

    public void repaintVideo() {
        if (this.visualComponent != null) {
            this.repaintVideo(this.id);
        }
    }

    private double nextFrameInternal(long id, boolean atFrameBegin) {
        double nextMediaPosition;
        long curTime = this.getMediaTime(id);
        double perFrame = this.getTimePerFrame(id);
        double perFrameNano = perFrame * 1000.0 * 10000.0;
        if (atFrameBegin) {
            long curFrame = (long)((double)curTime / perFrameNano);
            nextMediaPosition = (double)(curFrame + 1L) * perFrameNano;
        } else {
            nextMediaPosition = (double)curTime + perFrameNano;
        }
        this.setMediaTime(id, (long)Math.ceil(nextMediaPosition));
        return nextMediaPosition;
    }

    private double previousFrameInternal(long id, boolean atFrameBegin) {
        double nextMediaPosition;
        long curTime = this.getMediaTime(id);
        double perFrame = this.getTimePerFrame(id);
        double perFrameNano = perFrame * 1000.0 * 10000.0;
        if (atFrameBegin) {
            long curFrame = (long)((double)curTime / perFrameNano);
            nextMediaPosition = curFrame == 0L ? 0.0 : (double)(curFrame - 1L) * perFrameNano;
        } else {
            nextMediaPosition = (double)curTime - perFrameNano;
            if (nextMediaPosition < 0.0) {
                nextMediaPosition = 0.0;
            }
        }
        this.setMediaTime(id, (long)Math.ceil(nextMediaPosition));
        return nextMediaPosition;
    }

    static native void initLog(String var0, String var1);

    private native long initPlayer(boolean var1);

    private native void start(long var1);

    private native void stop(long var1);

    private native void pause(long var1);

    private native boolean isPlaying(long var1);

    private native int getState(long var1);

    private native void setRate(long var1, float var3);

    private native float getRate(long var1);

    private native void setVolume(long var1, float var3);

    private native float getVolume(long var1);

    private native void setMediaTime(long var1, long var3);

    private native long getMediaTime(long var1);

    private native long getDuration(long var1);

    private native double getFrameRate(long var1);

    private native double getTimePerFrame(long var1);

    private native float getAspectRatio(long var1);

    private native Dimension getOriginalSize(long var1);

    private native void setVisualComponent(long var1, Component var3);

    private native void setVisible(long var1, boolean var3);

    private native void setVideoSourcePos(long var1, float var3, float var4, float var5, float var6);

    private native void setVideoDestinationPos(long var1, int var3, int var4, int var5, int var6);

    private native void setVideoSourceAndDestPos(long var1, float var3, float var4, float var5, float var6, int var7, int var8, int var9, int var10);

    private native int[] getVideoDestinationPos(long var1);

    private native long initWithFile(String var1, boolean var2) throws JMMFException;

    public native String getFileType(String var1);

    private native boolean isVisualMedia(long var1);

    private native void setStopTime(long var1, long var3) throws JMMFException;

    private native long getStopTime(long var1);

    private native int getSourceHeight(long var1);

    private native int getSourceWidth(long var1);

    private native int[] getPreferredAspectRatio(long var1);

    private native byte[] getCurrentImage(long var1, DIBInfoHeader var3);

    private native byte[] getImageAtTime(long var1, DIBInfoHeader var3, long var4);

    private native void repaintVideo(long var1);

    public static native void enableDebugMode(boolean var0);

    public static native void correctAtPause(boolean var0);

    private native void clean(long var1);

    private native void closeSession(long var1);

    private native void deletePlayer(long var1);

    static {
        block20: {
            block19: {
                LOG = System.getLogger("NativeLogger");
                initError = null;
                nativeLogLoaded = false;
                try {
                    System.loadLibrary("JNIUtil");
                    nativeLogLoaded = true;
                }
                catch (UnsatisfiedLinkError ule) {
                    if (LOG.isLoggable(System.Logger.Level.WARNING)) {
                        LOG.log(System.Logger.Level.WARNING, "Could not load native utility library (JNIUtil.dll): " + ule.getMessage());
                    }
                }
                catch (Throwable t) {
                    if (!LOG.isLoggable(System.Logger.Level.WARNING)) break block19;
                    LOG.log(System.Logger.Level.WARNING, "Could not load native utility library (JNIUtil.dll): " + t.getMessage());
                }
            }
            try {
                String correctAtPause;
                if (System.getProperty("os.name").indexOf("Vista") > -1) {
                    System.loadLibrary("MMFPlayerVista");
                } else {
                    System.loadLibrary("MMFPlayer");
                }
                String debug = System.getProperty("JMMFDebug");
                if (debug != null && debug.toLowerCase().equals("true")) {
                    JMMFPlayer.enableDebugMode(true);
                }
                if ((correctAtPause = System.getProperty("JMMFCorrectAtPause")) != null) {
                    if (correctAtPause.toLowerCase().equals("true")) {
                        JMMFPlayer.correctAtPause(true);
                    } else if (correctAtPause.toLowerCase().equals("false")) {
                        JMMFPlayer.correctAtPause(false);
                    }
                }
            }
            catch (UnsatisfiedLinkError ue) {
                if (LOG.isLoggable(System.Logger.Level.WARNING)) {
                    LOG.log(System.Logger.Level.WARNING, "Could not load native player library (MMFPlayer.dll): " + ue.getMessage());
                }
                initError = ue.getMessage();
            }
            catch (Throwable th) {
                if (LOG.isLoggable(System.Logger.Level.WARNING)) {
                    LOG.log(System.Logger.Level.WARNING, "Could not load native player library (MMFPlayer.dll): " + th.getMessage());
                }
                initError = th.getMessage();
            }
            if (nativeLogLoaded) {
                try {
                    JMMFPlayer.initLog("nl/mpi/jni/NativeLogger", "nlog");
                }
                catch (Throwable t) {
                    if (!LOG.isLoggable(System.Logger.Level.WARNING)) break block20;
                    LOG.log(System.Logger.Level.WARNING, "Error while configuring native logging: " + t.getMessage());
                }
            }
        }
    }

    public static enum PlayerState {
        NO_SESSION(0),
        READY(1),
        OPENING(2),
        STARTED(3),
        PAUSED(4),
        SEEKING(5),
        STOPPED(6),
        CLOSING(7),
        CLOSED(8);

        public int value;

        private PlayerState(int value) {
            this.value = value;
        }
    }
}

