/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.jsound;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import nl.mpi.jsound.SegmentAudioInputStream;

public class WaveClipper {
    private final Logger LOG = Logger.getLogger("JavaSoundMPI");
    private String filePath;
    private AudioInputStream audioIn;

    public WaveClipper() {
    }

    public WaveClipper(String filePath) throws IOException, UnsupportedAudioFileException {
        this.filePath = filePath;
        this.initReader();
    }

    private void initReader() throws IOException, UnsupportedAudioFileException {
        block6: {
            try {
                File f = new File(this.filePath);
                BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
                this.audioIn = AudioSystem.getAudioInputStream(is);
            }
            catch (IOException ioe) {
                if (this.LOG.isLoggable(Level.WARNING)) {
                    this.LOG.warning("Cannot create audio reader stream: " + ioe.getMessage());
                }
                throw ioe;
            }
            catch (UnsupportedAudioFileException uafe) {
                if (this.LOG.isLoggable(Level.WARNING)) {
                    this.LOG.warning("Unsupported audio file: " + uafe.getMessage());
                }
                throw uafe;
            }
            catch (Throwable t) {
                if (!this.LOG.isLoggable(Level.WARNING)) break block6;
                this.LOG.warning("Cannot create audio reader: " + t.getMessage());
            }
        }
    }

    public synchronized boolean exportClip(String targetPath, long t1, long t2) throws IOException, UnsupportedAudioFileException {
        if (this.audioIn == null) {
            if (this.LOG.isLoggable(Level.WARNING)) {
                this.LOG.warning("Cannot export a clip, there is no audio input stream");
            }
            return false;
        }
        OutputStream out = null;
        try {
            File fileOut = new File(targetPath);
            out = new BufferedOutputStream(new FileOutputStream(fileOut));
            SegmentAudioInputStream saiStream = new SegmentAudioInputStream(this.audioIn, t1, t2);
            int numWr = AudioSystem.write((AudioInputStream)saiStream, AudioFileFormat.Type.WAVE, out);
            if (this.LOG.isLoggable(Level.FINE)) {
                this.LOG.fine(String.format("Wrote %d bytes to file %s", numWr, targetPath));
            }
            boolean bl = numWr > 0;
            return bl;
        }
        catch (IOException ioe) {
            if (this.LOG.isLoggable(Level.WARNING)) {
                this.LOG.warning("An error ocurred while writing the file: " + ioe.getMessage());
            }
            throw ioe;
        }
        catch (Throwable t) {
            if (this.LOG.isLoggable(Level.WARNING)) {
                this.LOG.warning("Cannot create an audio file reader: " + t.getMessage());
            }
            throw new IOException("Cannot write the file because of an error: " + t.getMessage());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    public boolean exportClip(String sourceFile, String targetPath, long t1, long t2) throws IOException, UnsupportedAudioFileException {
        AudioInputStream audioSourceStream = null;
        OutputStream out = null;
        AudioInputStream saiStream = null;
        try {
            File f = new File(sourceFile);
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(f));
            audioSourceStream = AudioSystem.getAudioInputStream(is);
            File fileOut = new File(targetPath);
            out = new BufferedOutputStream(new FileOutputStream(fileOut));
            saiStream = new SegmentAudioInputStream(audioSourceStream, t1, t2);
            int numWr = AudioSystem.write(saiStream, AudioFileFormat.Type.WAVE, out);
            if (this.LOG.isLoggable(Level.FINE)) {
                this.LOG.fine(String.format("Wrote %d bytes to file %s", numWr, targetPath));
            }
            boolean bl = numWr > 0;
            return bl;
        }
        catch (IOException ioe) {
            if (this.LOG.isLoggable(Level.WARNING)) {
                this.LOG.warning("Cannot create an audio reader stream: " + ioe.getMessage());
            }
            throw ioe;
        }
        catch (UnsupportedAudioFileException uafe) {
            if (this.LOG.isLoggable(Level.WARNING)) {
                this.LOG.warning("Unsupported audio file: " + uafe.getMessage());
            }
            throw uafe;
        }
        catch (Throwable t) {
            if (this.LOG.isLoggable(Level.WARNING)) {
                this.LOG.warning("Cannot create an audio file reader: " + t.getMessage());
            }
            throw new IOException("Cannot write the file because of an error: " + t.getMessage());
        }
        finally {
            try {
                if (saiStream != null) {
                    saiStream.close();
                }
                if (audioSourceStream != null) {
                    audioSourceStream.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (Throwable thr) {
                thr.printStackTrace();
            }
        }
    }

    protected void finalize() throws Throwable {
        if (this.audioIn != null) {
            try {
                this.audioIn.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

