/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.media;

import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import nl.mpi.media.UnsupportedMediaException;

public class AudioExtractor {
    private static final System.Logger LOG;
    private String mediaPath;
    private long id;
    private int sampleFrequency = 0;
    private int numberOfChannels = 0;
    private int bitsPerSample = 0;
    private long mediaDuration = 0L;
    private double mediaDurationSec = 0.0;
    private long sampleBufferDuration = 0L;
    private double sampleBufferDurationSec = 0.0;
    private long sampleBufferSize = 0L;
    private double curMediaPosition;
    private ReentrantLock samplerLock = new ReentrantLock();
    private int failedLoadsCount = 0;
    private static boolean threadedSampleLoading;
    private static boolean nativeLibLoaded;
    private static boolean nativeLogLoaded;

    public AudioExtractor(String mediaPath) throws UnsupportedMediaException {
        if (!nativeLibLoaded) {
            throw new UnsupportedMediaException("The native library was not found or could not be loaded");
        }
        this.mediaPath = mediaPath;
        this.id = this.initNative(mediaPath);
        if (this.id > 0L) {
            if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
                LOG.log(System.Logger.Level.DEBUG, "The native AudioExtractor was initialized successfully");
            }
        } else {
            if (LOG.isLoggable(System.Logger.Level.WARNING)) {
                LOG.log(System.Logger.Level.WARNING, "The native AudioExtractor could not be initialized");
            }
            throw new UnsupportedMediaException("The native AudioExtractor could not be initialized.");
        }
    }

    public int getSampleFrequency() {
        if (this.sampleFrequency == 0) {
            this.sampleFrequency = this.getSampleFrequency(this.id);
        }
        return this.sampleFrequency;
    }

    public int getBitsPerSample() {
        if (this.bitsPerSample == 0) {
            this.bitsPerSample = this.getBitsPerSample(this.id);
            if (this.bitsPerSample == 0) {
                // empty if block
            }
        }
        return this.bitsPerSample;
    }

    public int getNumberOfChannels() {
        if (this.numberOfChannels == 0) {
            this.numberOfChannels = this.getNumberOfChannels(this.id);
        }
        return this.numberOfChannels;
    }

    public long getDuration() {
        if (this.mediaDuration == 0L) {
            this.mediaDuration = this.getDurationMs(this.id);
        }
        return this.mediaDuration;
    }

    public double getDurationSec() {
        if (this.mediaDurationSec == 0.0) {
            this.mediaDurationSec = this.getDurationSec(this.id);
        }
        return this.mediaDurationSec;
    }

    public long getSampleBufferSize() {
        if (this.sampleBufferSize <= 1L) {
            this.sampleBufferSize = this.getSampleBufferSize(this.id);
        }
        return this.sampleBufferSize;
    }

    public long getSampleBufferDurationMs() {
        if (this.sampleBufferDuration == 0L) {
            this.sampleBufferDuration = this.getSampleBufferDurationMs(this.id);
        }
        return this.sampleBufferDuration;
    }

    public double getSampleBufferDurationSec() {
        if (this.sampleBufferDurationSec == 0.0) {
            this.sampleBufferDurationSec = this.getSampleBufferDurationSec(this.id);
        }
        return this.sampleBufferDurationSec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getSamples(double fromTime, double toTime) {
        if (this.id == 0L) {
            return null;
        }
        if (toTime <= fromTime) {
            return null;
        }
        if (fromTime >= this.getDurationSec()) {
            return null;
        }
        if (toTime > this.getDurationSec()) {
            toTime = this.getDurationSec();
        }
        double timeSpan = toTime - fromTime;
        int numBytes = 0;
        double bufferDur = this.getSampleBufferDurationSec();
        if (bufferDur > 0.0) {
            double numBuffers = timeSpan / bufferDur;
            int nb = (int)(numBuffers * (double)this.getSampleBufferSize());
            numBytes = nb + (int)this.getSampleBufferSize();
        } else {
            numBytes = (int)(timeSpan * (double)(this.getSampleFrequency() * (this.getBitsPerSample() / 8) * this.getNumberOfChannels()));
            numBytes += 1024;
        }
        if (!threadedSampleLoading) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(numBytes);
            int numRead2 = this.getSamples(this.id, fromTime, toTime, byteBuffer2);
            this.curMediaPosition = toTime + this.getSampleBufferDurationSec();
            byte[] ba = new byte[numRead2];
            byteBuffer2.get(ba, 0, numRead2);
            return ba;
        }
        try {
            if (!this.samplerLock.tryLock(20L, TimeUnit.MILLISECONDS)) return null;
            try {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(numBytes);
                LoadRunner lr = new LoadRunner(fromTime, toTime, byteBuffer);
                Thread loadThr = new Thread(lr);
                try {
                    loadThr.start();
                    loadThr.join(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                int numRead = lr.numRead;
                if (numRead == 0) {
                    if (loadThr.isAlive()) {
                        loadThr.interrupt();
                    }
                    ++this.failedLoadsCount;
                    if (this.failedLoadsCount > 5) {
                        this.id = 0L;
                    }
                    byte[] byArray = null;
                    return byArray;
                }
                this.curMediaPosition = toTime + this.getSampleBufferDurationSec();
                byte[] ba = new byte[numRead];
                byteBuffer.get(ba, 0, numRead);
                byte[] byArray = ba;
                return byArray;
            }
            finally {
                this.samplerLock.unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] getSample(double forTime) {
        if (this.id == 0L) {
            return null;
        }
        if (!threadedSampleLoading) {
            ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect((int)this.getSampleBufferSize());
            int numBytes = this.getSample(this.id, forTime, byteBuffer2);
            this.curMediaPosition = forTime + this.getSampleBufferDurationSec();
            byte[] ba = new byte[numBytes];
            byteBuffer2.get(ba, 0, numBytes);
            return ba;
        }
        try {
            if (!this.samplerLock.tryLock(20L, TimeUnit.MILLISECONDS)) return null;
            try {
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect((int)this.getSampleBufferSize());
                LoadRunner lr = new LoadRunner(forTime, forTime, byteBuffer);
                Thread loadThr = new Thread(lr);
                try {
                    loadThr.start();
                    loadThr.join(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                int numRead = lr.numRead;
                if (numRead == 0) {
                    if (loadThr.isAlive()) {
                        loadThr.interrupt();
                    }
                    ++this.failedLoadsCount;
                    if (this.failedLoadsCount > 5) {
                        this.id = 0L;
                    }
                    byte[] byArray = null;
                    return byArray;
                }
                this.curMediaPosition = forTime + this.getSampleBufferDurationSec();
                byte[] ba = new byte[numRead];
                byteBuffer.get(ba, 0, numRead);
                byte[] byArray = ba;
                return byArray;
            }
            finally {
                this.samplerLock.unlock();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    public double getPositionSec() {
        return this.curMediaPosition;
    }

    public void setPositionSec(double seekPositionSec) {
        if (this.id == 0L) {
            return;
        }
        this.curMediaPosition = seekPositionSec;
        this.setPositionSec(this.id, seekPositionSec);
    }

    public void release() {
        if (this.id > 0L) {
            this.release(this.id);
        }
    }

    public static native void setDebugMode(boolean var0);

    public static native boolean isDebugMode();

    static native void initLog(String var0, String var1);

    private native long initNative(String var1);

    private native int getSampleFrequency(long var1);

    private native int getBitsPerSample(long var1);

    private native int getNumberOfChannels(long var1);

    private native long getDurationMs(long var1);

    private native double getDurationSec(long var1);

    private native long getSampleBufferSize(long var1);

    private native long getSampleBufferDurationMs(long var1);

    private native double getSampleBufferDurationSec(long var1);

    private native int getSamples(long var1, double var3, double var5, ByteBuffer var7);

    private native int getSample(long var1, double var3, ByteBuffer var5);

    private native boolean setPositionSec(long var1, double var3);

    private native void release(long var1);

    public static void main(String[] args) {
        if (args.length >= 1) {
            try {
                AudioExtractor.setDebugMode(true);
                AudioExtractor ae = new AudioExtractor(args[0]);
                System.out.println(ae.getSampleFrequency());
                System.out.println(ae.getBitsPerSample());
                System.out.println(ae.getDuration());
                System.out.println(ae.getNumberOfChannels());
                System.out.println("Sample: " + ae.getSample(2.33).length);
                System.out.println("Sample 2: " + ae.getSample(52.119).length);
                System.out.println("Time span: " + ae.getSamples(4.52, 6.899).length);
                System.out.println("Time span: " + ae.getSamples(2.12, 4.9).length);
            }
            catch (UnsupportedMediaException ume) {
                System.out.println(ume.getMessage());
            }
        }
    }

    static {
        String threadLoad;
        block13: {
            block12: {
                block11: {
                    LOG = System.getLogger("NativeLogger");
                    threadedSampleLoading = false;
                    nativeLibLoaded = false;
                    nativeLogLoaded = false;
                    try {
                        System.loadLibrary("JNIUtil");
                        nativeLogLoaded = true;
                    }
                    catch (UnsatisfiedLinkError ule) {
                        if (LOG.isLoggable(System.Logger.Level.WARNING)) {
                            LOG.log(System.Logger.Level.WARNING, "Could not load native utility library (libJNIUtil.dylib): " + ule.getMessage());
                        }
                    }
                    catch (Throwable t) {
                        if (!LOG.isLoggable(System.Logger.Level.WARNING)) break block11;
                        LOG.log(System.Logger.Level.WARNING, "Could not load native utility library (libJNIUtil.dylib): " + t.getMessage());
                    }
                }
                try {
                    System.loadLibrary("AudioExtractor");
                    nativeLibLoaded = true;
                }
                catch (Throwable t) {
                    if (!LOG.isLoggable(System.Logger.Level.WARNING)) break block12;
                    LOG.log(System.Logger.Level.WARNING, "Error loading native library: " + t.getMessage());
                }
            }
            if (nativeLibLoaded && nativeLogLoaded) {
                try {
                    AudioExtractor.initLog("nl/mpi/jni/NativeLogger", "nlog");
                    if (LOG.isLoggable(System.Logger.Level.DEBUG)) {
                        AudioExtractor.setDebugMode(true);
                    }
                }
                catch (Throwable t) {
                    if (!LOG.isLoggable(System.Logger.Level.WARNING)) break block13;
                    LOG.log(System.Logger.Level.WARNING, "Error while configuring the AudioExtractor: " + t.getMessage());
                }
            }
        }
        if ((threadLoad = System.getProperty("AudioExtractor.LoadSamplesThreaded")) != null && threadLoad.equalsIgnoreCase("true")) {
            threadedSampleLoading = true;
        }
    }

    private class LoadRunner
    implements Runnable {
        int numRead = 0;
        double from;
        double to;
        ByteBuffer bb;

        LoadRunner(double fromTime, double toTime, ByteBuffer byteBuffer) {
            this.from = fromTime;
            this.to = toTime;
            this.bb = byteBuffer;
        }

        @Override
        public void run() {
            if (AudioExtractor.this.id != 0L) {
                if (this.to > this.from) {
                    this.numRead = AudioExtractor.this.getSamples(AudioExtractor.this.id, this.from, this.to, this.bb);
                } else if (this.to == this.from) {
                    this.numRead = AudioExtractor.this.getSample(AudioExtractor.this.id, this.from, this.bb);
                }
            }
        }
    }
}

