/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.media.spectrogram;

import java.util.Arrays;

public class FFT {
    public static final double meps = 1.0E-14;

    public boolean forwardFTIP(double[] realArray, double[] imArray) {
        if (realArray == null || realArray.length == 0 || (realArray.length & realArray.length - 1) != 0) {
            return false;
        }
        if (imArray == null) {
            imArray = new double[realArray.length];
            Arrays.fill(imArray, 0.0);
        }
        this.rearrangeIP(realArray);
        this.performIP(realArray, imArray);
        return true;
    }

    public boolean forwardFTNormIP(double[] realArray, double[] imArray) {
        if (realArray == null || realArray.length == 0 || (realArray.length & realArray.length - 1) != 0) {
            return false;
        }
        if (imArray == null) {
            imArray = new double[realArray.length];
            Arrays.fill(imArray, 0.0);
        }
        this.rearrangeIP(realArray);
        this.performIP(realArray, imArray);
        for (int i = 0; i < realArray.length; ++i) {
            realArray[i] = Math.sqrt(realArray[i] * realArray[i] + imArray[i] * imArray[i]);
        }
        return true;
    }

    public double[] jFFTLR(double[] realArray) {
        if (realArray == null || realArray.length == 0 || (realArray.length & realArray.length - 1) != 0) {
            return null;
        }
        double[] imArray = new double[realArray.length];
        Arrays.fill(imArray, 0.0);
        this.rearrangeIP(realArray);
        this.performIP(realArray, imArray);
        double[] outArray = new double[realArray.length * 2];
        int i = 0;
        int j = 0;
        while (i < realArray.length) {
            outArray[j] = realArray[i];
            outArray[j + 1] = imArray[i];
            ++i;
            j += 2;
        }
        return outArray;
    }

    public double[] jFFTLRAbs(double[] realArray) {
        if (realArray == null || realArray.length == 0 || (realArray.length & realArray.length - 1) != 0) {
            return null;
        }
        double[] imArray = new double[realArray.length];
        Arrays.fill(imArray, 0.0);
        this.rearrangeIP(realArray);
        this.performIP(realArray, imArray);
        double[] outArray = new double[realArray.length / 2 + 1];
        for (int i = 0; i <= realArray.length / 2; ++i) {
            outArray[i] = Math.sqrt(realArray[i] * realArray[i] + imArray[i] * imArray[i]);
        }
        return outArray;
    }

    public double[] jFFTLRNorm(double[] realArray) {
        if (realArray == null || realArray.length == 0 || (realArray.length & realArray.length - 1) != 0) {
            return null;
        }
        double[] imArray = new double[realArray.length];
        Arrays.fill(imArray, 0.0);
        this.rearrangeIP(realArray);
        this.performIP(realArray, imArray);
        double[] outArray = new double[realArray.length / 2 + 1];
        for (int i = 0; i <= realArray.length / 2; ++i) {
            outArray[i] = realArray[i] * realArray[i] + imArray[i] * imArray[i];
        }
        return outArray;
    }

    public double[] jFFTLROpt(double[] realArray, boolean normalize, boolean absolute, boolean trim, boolean divideBySize, boolean power, boolean rootPower, boolean zeroPowerLimit) {
        if (realArray == null || realArray.length == 0 || (realArray.length & realArray.length - 1) != 0) {
            System.out.println("Returning null array");
            return null;
        }
        double[] imArray = new double[realArray.length];
        Arrays.fill(imArray, 0.0);
        this.rearrangeIP(realArray);
        this.performIP(realArray, imArray);
        double[] outArray = null;
        outArray = trim ? new double[realArray.length / 2 + 1] : realArray;
        int size = outArray.length;
        for (int i = 0; i < size; ++i) {
            if (normalize && !absolute) {
                outArray[i] = realArray[i] * realArray[i] + imArray[i] * imArray[i];
            } else if (absolute) {
                outArray[i] = Math.sqrt(realArray[i] * realArray[i] + imArray[i] * imArray[i]);
            }
            if (divideBySize) {
                outArray[i] = outArray[i] / (double)(size - 1);
            }
            if (rootPower) {
                if (!zeroPowerLimit) {
                    outArray[i] = 20.0 * Math.log10(outArray[i] + 1.0E-14);
                    continue;
                }
                outArray[i] = 20.0 * Math.log10(Math.max(outArray[i], 1.0));
                continue;
            }
            if (!power) continue;
            outArray[i] = !zeroPowerLimit ? 10.0 * Math.log10(outArray[i] + 1.0E-14) : 10.0 * Math.log10(Math.max(outArray[i], 1.0));
        }
        return outArray;
    }

    private void rearrangeIP(double[] realArray) {
        int t = 0;
        int len = realArray.length;
        for (int i = 0; i < len; ++i) {
            if (t > i) {
                double d = realArray[t];
                realArray[t] = realArray[i];
                realArray[i] = d;
            }
            int m = len;
            while ((t & (m >>= 1)) != 0) {
                t &= ~m;
            }
            t |= m;
        }
    }

    private void performIP(double[] realArray, double[] imArray) {
        double pi = -Math.PI;
        int len = realArray.length;
        for (int i = 1; i < len; i <<= 1) {
            int j = i << 1;
            double delta = -Math.PI / (double)i;
            double s = Math.sin(delta * 0.5);
            double multipre = -2.0 * s * s;
            double multipim = Math.sin(delta);
            double factre = 1.0;
            double factim = 0.0;
            for (int g = 0; g < i; ++g) {
                for (int p = g; p < len; p += j) {
                    int mp = p + i;
                    double prodre = factre * realArray[mp] - factim * imArray[mp];
                    double prodim = factre * imArray[mp] + factim * realArray[mp];
                    realArray[mp] = realArray[p] - prodre;
                    imArray[mp] = imArray[p] - prodim;
                    realArray[p] = realArray[p] + prodre;
                    imArray[p] = imArray[p] + prodim;
                }
                double factretemp = multipre * factre - multipim * factim;
                double factimtemp = multipre * factim + multipim * factre;
                factre = factretemp + factre;
                factim = factimtemp + factim;
            }
        }
    }

    public void scaleRealIP(double[] ra) {
        int n = ra.length;
        double rad = 1.0 / Math.sqrt(n);
        for (int i = 0; i < n; ++i) {
            ra[i] = ra[i] * rad;
        }
    }

    public native double[] nFFTLR(double[] var1);

    public native double[] nFFTLRAbs(double[] var1);

    public native double[] nFFTLRNorm(double[] var1);

    public native double[] nFFTLROpt(double[] var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8);

    public double[] jFFTRos(double[] realArray, boolean normalize, boolean absolute, boolean trim, boolean divideBySize, boolean power) {
        int i;
        if (realArray == null || realArray.length == 0 || (realArray.length & realArray.length - 1) != 0) {
            return null;
        }
        Complex[] cmp = new Complex[realArray.length];
        for (i = 0; i < realArray.length; ++i) {
            cmp[i] = new Complex(realArray[i], 0.0);
        }
        this.fft(cmp);
        for (i = 0; i < realArray.length; ++i) {
            realArray[i] = cmp[i].re;
        }
        return realArray;
    }

    private static int bitReverse(int n, int bits) {
        int reversedN = n;
        int count = bits - 1;
        n >>= 1;
        while (n > 0) {
            reversedN = reversedN << 1 | n & 1;
            --count;
            n >>= 1;
        }
        return reversedN << count & (1 << bits) - 1;
    }

    private void fft(Complex[] buffer) {
        int bits = (int)(Math.log(buffer.length) / Math.log(2.0));
        for (int j = 1; j < buffer.length / 2; ++j) {
            int swapPos = FFT.bitReverse(j, bits);
            Complex temp = buffer[j];
            buffer[j] = buffer[swapPos];
            buffer[swapPos] = temp;
        }
        for (int N = 2; N <= buffer.length; N <<= 1) {
            for (int i = 0; i < buffer.length; i += N) {
                for (int k = 0; k < N / 2; ++k) {
                    int evenIndex = i + k;
                    int oddIndex = i + k + N / 2;
                    Complex even = buffer[evenIndex];
                    Complex odd = buffer[oddIndex];
                    double term = Math.PI * -2 * (double)k / (double)N;
                    Complex exp = new Complex(Math.cos(term), Math.sin(term)).mult(odd);
                    buffer[evenIndex] = even.add(exp);
                    buffer[oddIndex] = even.sub(exp);
                }
            }
        }
    }

    public native double[] nFFTRos(double[] var1);

    public native double[] nFFTRosPlus(double[] var1);

    public static double[] fft(double[] inputReal, double[] inputImagx, boolean DIRECT) {
        double tImag;
        double tReal;
        int n = inputReal.length;
        double ld = Math.log(n) / Math.log(2.0);
        if ((double)((int)ld) - ld != 0.0) {
            System.out.println("The number of elements is not a power of 2.");
            return null;
        }
        double[] inputImag = new double[n];
        Arrays.fill(inputImag, 0.0);
        int nu = (int)ld;
        int n2 = n / 2;
        int nu1 = nu - 1;
        double[] xReal = inputReal;
        double[] xImag = inputImag;
        double constant = DIRECT ? Math.PI * -2 : Math.PI * 2;
        int k = 0;
        for (int l = 1; l <= nu; ++l) {
            while (k < n) {
                for (int i = 1; i <= n2; ++i) {
                    double p = FFT.bitreverseReference(k >> nu1, nu);
                    double arg = constant * p / (double)n;
                    double c = Math.cos(arg);
                    double s = Math.sin(arg);
                    tReal = xReal[k + n2] * c + xImag[k + n2] * s;
                    tImag = xImag[k + n2] * c - xReal[k + n2] * s;
                    xReal[k + n2] = xReal[k] - tReal;
                    xImag[k + n2] = xImag[k] - tImag;
                    int n3 = k;
                    xReal[n3] = xReal[n3] + tReal;
                    int n4 = k++;
                    xImag[n4] = xImag[n4] + tImag;
                }
                k += n2;
            }
            k = 0;
            --nu1;
            n2 /= 2;
        }
        for (k = 0; k < n; ++k) {
            int r = FFT.bitreverseReference(k, nu);
            if (r <= k) continue;
            tReal = xReal[k];
            tImag = xImag[k];
            xReal[k] = xReal[r];
            xImag[k] = xImag[r];
            xReal[r] = tReal;
            xImag[r] = tImag;
        }
        return xReal;
    }

    private static int bitreverseReference(int j, int nu) {
        int j1 = j;
        int k = 0;
        for (int i = 1; i <= nu; ++i) {
            int j2 = j1 / 2;
            k = 2 * k + j1 - 2 * j2;
            j1 = j2;
        }
        return k;
    }

    class Complex {
        public final double re;
        public final double im;

        public Complex() {
            this(0.0, 0.0);
        }

        public Complex(double r, double i) {
            this.re = r;
            this.im = i;
        }

        public Complex add(Complex b) {
            return new Complex(this.re + b.re, this.im + b.im);
        }

        public Complex sub(Complex b) {
            return new Complex(this.re - b.re, this.im - b.im);
        }

        public Complex mult(Complex b) {
            return new Complex(this.re * b.re - this.im * b.im, this.re * b.im + this.im * b.re);
        }

        public String toString() {
            return String.format("(%f,%f)", this.re, this.im);
        }
    }
}

