/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.media.spectrogram;

import java.awt.Color;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BandedSampleModel;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import nl.mpi.media.spectrogram.SpectrogramSettings;

public class ImageCreator {
    private SpectrogramSettings settings;
    private ColorModel directColorModel;
    private ColorModel comColorModel;
    double cr1 = 0.0;
    double cg1 = 0.0;
    double cb1 = 0.0;
    double cr2 = 1.0;
    double cg2 = 1.0;
    double cb2 = 1.0;
    double cre = Math.abs(this.cr1 - this.cr2);
    double cge = Math.abs(this.cg1 - this.cg2);
    double cbe = Math.abs(this.cb1 - this.cb2);
    final int AM = -16777216;
    final int RM = 0xFF0000;
    final int GM = 65280;
    final int BM = 255;
    int[] masks = new int[]{0xFF0000, 65280, 255};
    private int[] lut = null;
    private Color col1 = Color.WHITE;
    private Color col2 = Color.BLACK;
    private double minOv = 0.4;

    public ImageCreator() {
        this.settings = new SpectrogramSettings();
        this.initialize();
    }

    public ImageCreator(SpectrogramSettings settings) {
        if (settings != null) {
            this.settings = settings;
        } else {
            settings = new SpectrogramSettings();
        }
        this.initialize();
    }

    private void initialize() {
        this.directColorModel = new DirectColorModel(ColorSpace.getInstance(1000), 24, this.masks[0], this.masks[1], this.masks[2], 0, true, 3);
        this.comColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 5);
    }

    public SpectrogramSettings getSettings() {
        return this.settings;
    }

    private void updateColorMap() {
        float hueStep;
        boolean updateMap = false;
        if (!(this.col1 != null && this.col1.equals(this.settings.getColor1()) || this.settings.getColor1() == null)) {
            this.col1 = this.settings.getColor1();
            updateMap = true;
        }
        if (!(this.col2 != null && this.col2.equals(this.settings.getColor2()) || this.settings.getColor2() == null)) {
            this.col2 = this.settings.getColor2();
            updateMap = true;
        }
        if (!updateMap && this.lut == null) {
            return;
        }
        int size = 65536;
        this.lut = new int[size];
        float[] hsv1 = Color.RGBtoHSB(this.col1.getRed(), this.col1.getGreen(), this.col1.getBlue(), null);
        float[] hsv2 = Color.RGBtoHSB(this.col2.getRed(), this.col2.getGreen(), this.col2.getBlue(), null);
        float satRange = Math.abs(hsv1[1] - hsv2[1]);
        float satStep = hsv2[1] < hsv1[1] ? satRange / (float)size : -(satRange / (float)size);
        float valRange = Math.abs(hsv1[2] - hsv2[2]);
        float valStep = hsv2[2] < hsv1[2] ? valRange / (float)size : -(valRange / (float)size);
        float hueRange = Math.abs(hsv1[0] - hsv2[0]);
        float f = hueStep = hsv2[0] < hsv1[0] ? hueRange / (float)size : -(hueRange / (float)size);
        if (hueRange > 0.5f) {
            float revHueRange = 1.0f - hueRange;
            if (hsv1[0] > hsv2[0]) {
                hsv2[0] = hsv2[0] + 1.0f;
                hueStep = -(revHueRange / (float)size);
            } else {
                hsv1[0] = hsv1[0] + 1.0f;
                hueStep = revHueRange / (float)size;
            }
        }
        for (int i = 0; i < size; ++i) {
            this.lut[i] = Color.HSBtoRGB(hsv2[0] + (float)i * hueStep, hsv2[1] + (float)i * satStep, hsv2[2] + (float)i * valStep);
        }
    }

    public BufferedImage createSpecImage(double[][] freqWindows, int imageWidth, int imageHeight, SpectrogramSettings.PERFORMANCE renderPerf) {
        switch (renderPerf) {
            case SPEED: {
                return this.createSpectrogramImageSmooth(freqWindows, imageWidth, imageHeight);
            }
            case QUALITY: {
                return this.createSpectrogramImageSmooth(freqWindows, imageWidth, imageHeight);
            }
        }
        return null;
    }

    private BufferedImage createSpectrogram2(double[][] freqWindows, int posMaxFreq, int maxDisplayFreq) {
        int numBins = freqWindows[0].length;
        int freqsPerBin = posMaxFreq / numBins;
        System.out.println(String.format("Image: freqPerBin: %d, num bins: %d, pos max freq: %d, req max: %d", freqsPerBin, numBins, posMaxFreq, maxDisplayFreq));
        int h = maxDisplayFreq / freqsPerBin;
        int w = freqWindows.length;
        System.out.println(String.format("Image: w: %d, h: %d, num pixels: %d", w, h, w * h));
        double min = Double.MAX_VALUE;
        double max = 0.0;
        for (int i = 0; i < freqWindows.length; ++i) {
            for (int j = 0; j < h; ++j) {
                double d = freqWindows[i][j];
                if (d < min) {
                    min = d;
                }
                if (!(d > max)) continue;
                max = d;
            }
        }
        double valRange = max - min;
        double absMin = min < 0.0 ? -min : min;
        System.out.println(String.format("Image range: min: %.6f, max: %.6f, range: %.6f", min, max, valRange));
        DataBufferDouble dbd = new DataBufferDouble(w * h, 3);
        double[] rdata = dbd.getData(0);
        double[] gdata = dbd.getData(1);
        double[] bdata = dbd.getData(2);
        for (int i = 0; i < w; ++i) {
            double[] col = freqWindows[i];
            for (int j = 0; j < h; ++j) {
                double d = 1.0 - (absMin + col[j]) / valRange;
                if (d > 1.0) {
                    d = 1.0;
                } else if (d < 0.0) {
                    d = 0.0;
                }
                rdata[i + (h - 1 - j) * w] = this.cr1 >= this.cr2 ? this.cr1 - this.cre * d : this.cr1 + this.cre * d;
                gdata[i + (h - 1 - j) * w] = this.cg1 >= this.cg2 ? this.cg1 - this.cge * d : this.cg1 + this.cge * d;
                bdata[i + (h - 1 - j) * w] = this.cb1 >= this.cb2 ? this.cb1 - this.cbe * d : this.cb1 + this.cbe * d;
            }
        }
        ComponentColorModel colorModel = new ComponentColorModel(ColorSpace.getInstance(1000), false, false, 1, 5);
        BandedSampleModel sampleModel = new BandedSampleModel(5, w, h, 3);
        WritableRaster raster = Raster.createWritableRaster(sampleModel, dbd, null);
        return new BufferedImage(colorModel, raster, true, null);
    }

    public BufferedImage createSpectrogramImageSmooth(double[][] freqWindows, int imageWidth, int imageHeight) {
        boolean horScaleUp;
        double maxDisplayFreq = this.settings.getMaxDisplayFrequency();
        double minDisplayFreq = this.settings.getMinDisplayFrequency();
        double posMaxFreq = this.settings.getPossibleMaxFrequency();
        int numBins = freqWindows[0].length;
        double freqsPerBin = posMaxFreq / (double)numBins;
        int minBin = (int)(minDisplayFreq / freqsPerBin);
        int maxBin = (int)Math.ceil(maxDisplayFreq / freqsPerBin);
        maxBin = maxBin >= numBins ? numBins - 1 : maxBin;
        int numDisplayBins = maxBin - minBin + 1;
        if (imageWidth == freqWindows.length && imageHeight == numDisplayBins) {
            return this.createSpectrogramImageNoScaling(freqWindows, imageWidth, imageHeight);
        }
        boolean vertScaleUp = imageHeight > numDisplayBins;
        boolean bl = horScaleUp = this.settings.getStrideDurationSec() > this.settings.getPixelDurationSec();
        if (horScaleUp) {
            if (vertScaleUp) {
                return this.createSpectrogramImageLinearHV(freqWindows, imageWidth, imageHeight);
            }
            return this.createSpectrogramImageLinearH(freqWindows, imageWidth, imageHeight);
        }
        if (vertScaleUp) {
            return this.createSpectrogramImageLinearV(freqWindows, imageWidth, imageHeight);
        }
        return this.createSpectrogramImage(freqWindows, imageWidth, imageHeight);
    }

    private BufferedImage createSpectrogramImage(double[][] freqWindows, int imageWidth, int imageHeight) {
        double maxDisplayFreq = this.settings.getMaxDisplayFrequency();
        double minDisplayFreq = this.settings.getMinDisplayFrequency();
        double posMaxFreq = this.settings.getPossibleMaxFrequency();
        int numBins = freqWindows[0].length;
        double freqsPerBin = posMaxFreq / (double)numBins;
        int minBin = (int)(minDisplayFreq / freqsPerBin);
        int maxBin = (int)Math.ceil(maxDisplayFreq / freqsPerBin);
        maxBin = maxBin >= numBins ? numBins - 1 : maxBin;
        int numDisplayBins = maxBin - minBin + 1;
        double[] minmax = this.getMinMax(freqWindows, minBin, maxBin);
        double valueRange = minmax[1] - minmax[0];
        int w = imageWidth;
        int h = imageHeight;
        double[] dar = new double[w * h];
        int[][] xMap = this.getCorrespondingIndices(w, freqWindows.length, this.settings.getPixelDurationSec(), this.settings.getActualStrideDurationSec());
        int[][] yMap = this.getBinMap(h, numDisplayBins);
        for (int i = 0; i < w; ++i) {
            for (int j = 0; j < h; ++j) {
                double value = 0.0;
                double binCount = 0.0;
                int[] xc = xMap[i];
                for (int wi = 0; wi < xc.length; ++wi) {
                    if (xc[wi] == 0 && wi != 0) continue;
                    int[] yc = yMap[j];
                    for (int k = 0; k < yc.length; ++k) {
                        if (yc[k] == 0 && k != 0) continue;
                        int bindex = yc[k] + minBin;
                        if (xc[wi] >= freqWindows.length || freqWindows[xc[wi]] == null || yc[k] >= freqWindows[xc[wi]].length) continue;
                        value += freqWindows[xc[wi]][bindex];
                        binCount += 1.0;
                    }
                }
                value /= binCount;
                dar[i + (h - 1 - j) * w] = (value = (value - minmax[0]) / valueRange) > 1.0 ? 1.0 : (value < 0.0 ? 0.0 : value);
            }
        }
        return this.toImage(dar, w, h);
    }

    private BufferedImage createSpectrogramImageLinearV(double[][] freqWindows, int imageWidth, int imageHeight) {
        double maxDisplayFreq = this.settings.getMaxDisplayFrequency();
        double minDisplayFreq = this.settings.getMinDisplayFrequency();
        double posMaxFreq = this.settings.getPossibleMaxFrequency();
        int numBins = freqWindows[0].length;
        double freqsPerBin = posMaxFreq / (double)numBins;
        int minBin = (int)(minDisplayFreq / freqsPerBin);
        int maxBin = (int)Math.ceil(maxDisplayFreq / freqsPerBin);
        maxBin = maxBin >= numBins ? numBins - 1 : maxBin;
        int numDisplayBins = maxBin - minBin + 1;
        double[] minmax = this.getMinMax(freqWindows, minBin, maxBin);
        double valueRange = minmax[1] - minmax[0];
        int w = imageWidth;
        int h = imageHeight;
        double[] dar = new double[w * h];
        int[][] xMap = this.getCorrespondingIndices(w, freqWindows.length, this.settings.getPixelDurationSec(), this.settings.getActualStrideDurationSec());
        int[] yMap = this.getBinMapSizingUp(h, numDisplayBins);
        for (int i = 0; i < w; ++i) {
            int[] xc = xMap[i];
            int curBinIndex = -1;
            int curPixYIndex = 0;
            double beginValue = 0.0;
            double endValue = 0.0;
            double yValueStep = 0.0;
            for (int j = 0; j < h; ++j) {
                double value = 0.0;
                double binCount = 0.0;
                for (int wi = 0; wi < xc.length; ++wi) {
                    if (xc[wi] == 0 && wi != 0) continue;
                    int yc = yMap[j] + minBin;
                    beginValue = freqWindows[xc[wi]][yc];
                    if (yc != curBinIndex) {
                        curBinIndex = yc;
                        curPixYIndex = j;
                        yValueStep = 0.0;
                        for (int pInd = j + 1; pInd < h; ++pInd) {
                            if (yMap[pInd] + minBin == curBinIndex) continue;
                            endValue = freqWindows[xc[wi]][yMap[pInd] + minBin];
                            yValueStep = (endValue - beginValue) / (double)(pInd - j);
                            break;
                        }
                    } else {
                        value += (double)(j - curPixYIndex) * yValueStep;
                    }
                    value += beginValue;
                    binCount += 1.0;
                }
                value /= binCount;
                dar[i + (h - 1 - j) * w] = (value = (value - minmax[0]) / valueRange) > 1.0 ? 1.0 : (value < 0.0 ? 0.0 : value);
            }
        }
        return this.toImage(dar, w, h);
    }

    private BufferedImage createSpectrogramImageLinearHV(double[][] freqWindows, int imageWidth, int imageHeight) {
        double maxDisplayFreq = this.settings.getMaxDisplayFrequency();
        double minDisplayFreq = this.settings.getMinDisplayFrequency();
        double posMaxFreq = this.settings.getPossibleMaxFrequency();
        int numBins = freqWindows[0].length;
        double freqsPerBin = posMaxFreq / (double)numBins;
        int minBin = (int)(minDisplayFreq / freqsPerBin);
        int maxBin = (int)Math.ceil(maxDisplayFreq / freqsPerBin);
        maxBin = maxBin >= numBins ? numBins - 1 : maxBin;
        int numDisplayBins = maxBin - minBin + 1;
        double[] minmax = this.getMinMax(freqWindows, minBin, maxBin);
        double valueRange = minmax[1] - minmax[0];
        int w = imageWidth;
        int h = imageHeight;
        double[] dar = new double[w * h];
        int[] xMap = this.getWindowMapSizingUp(w, freqWindows.length, this.settings.getPixelDurationSec(), this.settings.getActualStrideDurationSec());
        int[] yMap = this.getBinMapSizingUp(h, numDisplayBins);
        int curWinIndex = -1;
        int nextWinIndex = 0;
        int curPixXIndex = 0;
        int nextPixXIndex = 0;
        for (int i = 0; i < w; ++i) {
            int xc = xMap[i];
            if (xc != curWinIndex) {
                curWinIndex = xc;
                curPixXIndex = i;
                for (int wInd = i + 1; wInd < w; ++wInd) {
                    if (xMap[wInd] == curWinIndex) continue;
                    nextWinIndex = xMap[wInd];
                    nextPixXIndex = wInd;
                    break;
                }
            }
            int curBinIndex = -1;
            int curPixYIndex = 0;
            double beginValue = 0.0;
            double endValue = 0.0;
            double yValueStep = 0.0;
            for (int j = 0; j < h; ++j) {
                double value = 0.0;
                double binCount = 0.0;
                int yc = yMap[j] + minBin;
                beginValue = freqWindows[xc][yc];
                if (curWinIndex != nextWinIndex) {
                    double xValueStep = (freqWindows[nextWinIndex][yc] - freqWindows[curWinIndex][yc]) / (double)(nextPixXIndex - curPixXIndex);
                    value += (double)(i - curPixXIndex) * xValueStep;
                }
                if (yc != curBinIndex) {
                    curBinIndex = yc;
                    curPixYIndex = j;
                    yValueStep = 0.0;
                    for (int pInd = j + 1; pInd < h; ++pInd) {
                        if (yMap[pInd] + minBin == curBinIndex) continue;
                        endValue = freqWindows[xc][yMap[pInd] + minBin];
                        yValueStep = (endValue - beginValue) / (double)(pInd - j);
                        break;
                    }
                } else {
                    value += (double)(j - curPixYIndex) * yValueStep;
                }
                value += beginValue;
                value /= (binCount += 1.0);
                dar[i + (h - 1 - j) * w] = (value = (value - minmax[0]) / valueRange) > 1.0 ? 1.0 : (value < 0.0 ? 0.0 : value);
            }
        }
        return this.toImage(dar, w, h);
    }

    private BufferedImage createSpectrogramImageLinearH(double[][] freqWindows, int imageWidth, int imageHeight) {
        double maxDisplayFreq = this.settings.getMaxDisplayFrequency();
        double minDisplayFreq = this.settings.getMinDisplayFrequency();
        double posMaxFreq = this.settings.getPossibleMaxFrequency();
        int numBins = freqWindows[0].length;
        double freqsPerBin = posMaxFreq / (double)numBins;
        int minBin = (int)(minDisplayFreq / freqsPerBin);
        int maxBin = (int)Math.ceil(maxDisplayFreq / freqsPerBin);
        maxBin = maxBin >= numBins ? numBins - 1 : maxBin;
        int numDisplayBins = maxBin - minBin + 1;
        double[] minmax = this.getMinMax(freqWindows, minBin, maxBin);
        double valueRange = minmax[1] - minmax[0];
        int w = imageWidth;
        int h = imageHeight;
        double[] dar = new double[w * h];
        int[] xMap = this.getWindowMapSizingUp(w, freqWindows.length, this.settings.getPixelDurationSec(), this.settings.getActualStrideDurationSec());
        int[][] yMap = this.getBinMap(h, numDisplayBins);
        int curWinIndex = -1;
        int nextWinIndex = 0;
        int curPixXIndex = 0;
        int nextPixXIndex = 0;
        for (int i = 0; i < w; ++i) {
            int xc = xMap[i];
            if (xc != curWinIndex) {
                curWinIndex = xc;
                curPixXIndex = i;
                for (int wInd = i + 1; wInd < w; ++wInd) {
                    if (xMap[wInd] == curWinIndex) continue;
                    nextWinIndex = xMap[wInd];
                    nextPixXIndex = wInd;
                    break;
                }
            }
            for (int j = 0; j < h; ++j) {
                double value = 0.0;
                double binCount = 0.0;
                int[] yc = yMap[j];
                for (int k = 0; k < yc.length; ++k) {
                    if (yc[k] == 0 && k != 0) continue;
                    int bindex = yc[k] + minBin;
                    value += freqWindows[xc][bindex];
                    binCount += 1.0;
                    if (curWinIndex == nextWinIndex) continue;
                    double xValueStep = (freqWindows[nextWinIndex][bindex] - freqWindows[curWinIndex][bindex]) / (double)(nextPixXIndex - curPixXIndex);
                    value += (double)(i - curPixXIndex) * xValueStep;
                }
                value /= binCount;
                dar[i + (h - 1 - j) * w] = (value = (value - minmax[0]) / valueRange) > 1.0 ? 1.0 : (value < 0.0 ? 0.0 : value);
            }
        }
        return this.toImage(dar, w, h);
    }

    private BufferedImage createSpectrogramImageNoScaling(double[][] freqWindows, int imageWidth, int imageHeight) {
        double maxDisplayFreq = this.settings.getMaxDisplayFrequency();
        double minDisplayFreq = this.settings.getMinDisplayFrequency();
        double posMaxFreq = this.settings.getPossibleMaxFrequency();
        int numBins = freqWindows[0].length;
        double freqsPerBin = posMaxFreq / (double)numBins;
        int minBin = (int)(minDisplayFreq / freqsPerBin);
        int maxBin = (int)Math.ceil(maxDisplayFreq / freqsPerBin);
        maxBin = maxBin >= freqWindows[0].length ? freqWindows[0].length - 1 : maxBin;
        int numDisplayBins = maxBin - minBin + 1;
        int w = freqWindows.length;
        int h = numDisplayBins;
        if (w == imageWidth || h != imageHeight) {
            // empty if block
        }
        double[] minmax = this.getMinMax(freqWindows, minBin, maxBin);
        double valueRange = minmax[1] - minmax[0];
        double[] dar = new double[w * h];
        for (int i = 0; i < w; ++i) {
            for (int j = minBin; j <= maxBin; ++j) {
                double value = (freqWindows[i][j] - minmax[0]) / valueRange;
                dar[i + (h - 1 - j) * w] = value > 1.0 ? 1.0 : (value < 0.0 ? 0.0 : value);
            }
        }
        return this.toImage(dar, w, h);
    }

    Image createSpectrogramImageAWT(double[][] freqWindows, int imageWidth, int imageHeight) {
        double maxDisplayFreq = this.settings.getMaxDisplayFrequency();
        double minDisplayFreq = this.settings.getMinDisplayFrequency();
        double posMaxFreq = this.settings.getPossibleMaxFrequency();
        int numBins = freqWindows[0].length;
        double freqsPerBin = posMaxFreq / (double)numBins;
        int minBin = (int)(minDisplayFreq / freqsPerBin);
        int maxBin = (int)Math.ceil(maxDisplayFreq / freqsPerBin);
        maxBin = maxBin >= freqWindows[0].length ? freqWindows[0].length - 1 : maxBin;
        int numDisplayBins = maxBin - minBin + 1;
        int w = freqWindows.length;
        int h = numDisplayBins;
        double[] minmax = this.getMinMax(freqWindows, minBin, maxBin);
        double valueRange = minmax[1] - minmax[0];
        double[] dar = new double[w * h];
        for (int i = 0; i < w; ++i) {
            for (int j = minBin; j <= maxBin; ++j) {
                double value = (freqWindows[i][j] - minmax[0]) / valueRange;
                dar[i + (h - 1 - j) * w] = value > 1.0 ? 1.0 : (value < 0.0 ? 0.0 : value);
            }
        }
        BufferedImage bi = this.toImage(dar, w, h);
        if (w == imageWidth && h == imageHeight) {
            return bi;
        }
        return bi.getScaledInstance(imageWidth, imageHeight, 4);
    }

    private BufferedImage toImage(double[] valueArray, int w, int h) {
        SpectrogramSettings.COLOR_SCHEME colScheme = this.settings.getColorScheme();
        if (this.settings.getDataBufferType() == 3) {
            DataBufferInt dbi = new DataBufferInt(valueArray.length, 1);
            int[] data = dbi.getData();
            switch (colScheme) {
                case REVERSED_GRAY: {
                    for (int i = 0; i < valueArray.length; ++i) {
                        int b = (int)(valueArray[i] * 255.0);
                        data[i] = 0 | b << 16 | b << 8 | b;
                    }
                    break;
                }
                case BI_COLOR: {
                    int i;
                    this.updateColorMap();
                    int size = this.lut.length - 1;
                    for (i = 0; i < valueArray.length; ++i) {
                        data[i] = this.lut[(int)(valueArray[i] * (double)size)];
                    }
                    break;
                }
                default: {
                    int i;
                    for (i = 0; i < valueArray.length; ++i) {
                        int b = (int)(255.0 - valueArray[i] * 255.0);
                        data[i] = 0 | b << 16 | b << 8 | b;
                    }
                }
            }
            SinglePixelPackedSampleModel sampleModel = new SinglePixelPackedSampleModel(3, w, h, this.masks);
            WritableRaster raster = Raster.createWritableRaster(sampleModel, dbi, null);
            return new BufferedImage(this.directColorModel, raster, true, null);
        }
        DataBufferDouble dbd = new DataBufferDouble(w * h, 3);
        double[] rdata = dbd.getData(0);
        double[] gdata = dbd.getData(1);
        double[] bdata = dbd.getData(2);
        switch (colScheme) {
            case REVERSED_GRAY: {
                double d;
                int i;
                for (i = 0; i < valueArray.length; ++i) {
                    rdata[i] = d = valueArray[i];
                    gdata[i] = d;
                    bdata[i] = d;
                }
                break;
            }
            case BI_COLOR: {
                double d;
                int i;
                for (i = 0; i < valueArray.length; ++i) {
                    d = valueArray[i];
                    rdata[i] = this.cr1 >= this.cr2 ? this.cr1 - this.cre * d : this.cr1 + this.cre * d;
                    gdata[i] = this.cg1 >= this.cg2 ? this.cg1 - this.cge * d : this.cg1 + this.cge * d;
                    bdata[i] = this.cb1 >= this.cb2 ? this.cb1 - this.cbe * d : this.cb1 + this.cbe * d;
                }
                break;
            }
            default: {
                double d;
                int i;
                for (i = 0; i < valueArray.length; ++i) {
                    rdata[i] = d = 1.0 - valueArray[i];
                    gdata[i] = d;
                    bdata[i] = d;
                }
            }
        }
        BandedSampleModel sampleModel = new BandedSampleModel(5, w, h, 3);
        WritableRaster raster = Raster.createWritableRaster(sampleModel, dbd, null);
        return new BufferedImage(this.comColorModel, raster, true, null);
    }

    private double[] getMinMax(double[][] freqWindows, int fromBin, int toBin) {
        if (!this.settings.isAdaptiveContrast()) {
            double range = Math.abs(this.settings.getUpperValueLimit() - this.settings.getLowerValueLimit());
            return new double[]{this.settings.getLowerValueLimit() + range * this.settings.getLowerValueAdjustment() / 100.0, this.settings.getUpperValueLimit() + range * this.settings.getUpperValueAdjustment() / 100.0};
        }
        double min = Double.MAX_VALUE;
        double max = -1000.0;
        double meps = this.settings.getAdaptiveMinimum();
        for (int i = 0; i < freqWindows.length; ++i) {
            for (int j = fromBin; j <= toBin; ++j) {
                double d = freqWindows[i][j];
                if (d <= meps) continue;
                if (d < min) {
                    min = d;
                }
                if (!(d > max)) continue;
                max = d;
            }
        }
        return new double[]{min, max};
    }

    private boolean match(boolean firstSmaller, double rb, double re, double ob, double oe) {
        double ov2;
        if (oe < rb || re < ob) {
            return false;
        }
        double ov1 = rb <= ob ? ob : rb;
        double d = ov2 = re <= oe ? re : oe;
        if (firstSmaller) {
            return ov2 - ov1 >= this.minOv * (re - rb);
        }
        return ov2 - ov1 >= this.minOv * (oe - ob);
    }

    private int[][] getCorrespondingIndices(int numPixels, int numWindows, double pixelDur, double windowDur) {
        int max = (int)Math.max(2.0, Math.ceil(pixelDur / windowDur));
        int[][] map = new int[numPixels][max];
        boolean refSmaller = pixelDur <= windowDur;
        double rb = 0.0;
        double re = 0.0;
        double ob = 0.0;
        double oe = windowDur;
        int fw = 0;
        for (int i = 0; i < numPixels; ++i) {
            rb = re;
            re += pixelDur;
            boolean oneMatch = false;
            while (fw < numWindows) {
                if (this.match(refSmaller, rb, re, ob, oe)) {
                    oneMatch = true;
                    for (int j = 0; j < max; ++j) {
                        if (map[i][j] != 0) continue;
                        map[i][j] = fw;
                        break;
                    }
                    ob = oe;
                    oe += windowDur;
                } else {
                    if (oneMatch) break;
                    ob = oe;
                    oe += windowDur;
                }
                ++fw;
            }
            oe = ob;
            ob -= windowDur;
            --fw;
        }
        return map;
    }

    private int[][] getBinMap(int h, int numDisplayBins) {
        double ratio = (double)h / (double)numDisplayBins;
        int max = (int)Math.max(2.0, Math.ceil(ratio));
        int[][] map = new int[h][max];
        if (ratio > 1.0) {
            int ri = (int)ratio;
            int curBin = 0;
            double curAdv = ratio;
            for (int i = 0; i < map.length; ++i) {
                map[i][0] = curBin;
                if (i <= 0 || i != ri || curBin >= numDisplayBins - 1) continue;
                map[i][1] = ++curBin;
                ri = (int)(curAdv += ratio);
            }
            return map;
        }
        double s = 0.0;
        double e = 0.0;
        double bb = 0.0;
        double be = ratio;
        int ind = 0;
        block1: for (int i = 0; i < h; ++i) {
            s = e;
            e += 1.0;
            int j = 0;
            while (j < max) {
                if (this.match(ratio > 1.0, s, e, bb, be)) {
                    map[i][j] = ind;
                    ++j;
                } else if (j > 0) continue block1;
                bb = be;
                be += ratio;
                ++ind;
            }
        }
        return map;
    }

    private int[] getBinMapSizingUp(int h, int numDisplayBins) {
        double ratio = (double)h / (double)numDisplayBins;
        if (ratio < 1.0) {
            return null;
        }
        int[] map = new int[h];
        int ri = (int)ratio;
        int curBin = 0;
        double curAdv = ratio;
        for (int i = 0; i < map.length; ++i) {
            map[i] = curBin;
            if (i <= 0 || i != ri || curBin >= numDisplayBins - 1) continue;
            map[i] = ++curBin;
            ri = (int)(curAdv += ratio);
        }
        return map;
    }

    private int[] getWindowMapSizingUp(int numPixels, int numWindows, double pixelDur, double windowDur) {
        double ratio = pixelDur / windowDur;
        if (ratio > 1.0) {
            return null;
        }
        int[] map = new int[numPixels];
        double pb = 0.0;
        double pe = 0.0;
        double wb = 0.0;
        double we = windowDur;
        int winInd = 0;
        block0: for (int i = 0; i < numPixels; ++i) {
            pb = pe;
            pe += pixelDur;
            while (winInd < numWindows) {
                if (this.overlap1(pb, pe, wb, we) >= 0.5) {
                    map[i] = winInd;
                    continue block0;
                }
                wb = we;
                we += windowDur;
                ++winInd;
            }
        }
        return map;
    }

    private double overlap1(double rb, double re, double ob, double oe) {
        if (oe < rb || re < ob) {
            return 0.0;
        }
        double ov1 = rb <= ob ? ob : rb;
        double ov2 = re <= oe ? re : oe;
        return (ov2 - ov1) / (re - rb);
    }
}

