/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.media.spectrogram;

import java.awt.Color;

public class SpectrogramSettings {
    private double minDisplayFrequency;
    private double maxDisplayFrequency;
    private double possibleMaxFrequency;
    private double sampleFrequency;
    private int numSamplesPerWindow;
    private int numSamplesPerStride;
    private double windowDurationSec;
    private double actualWindowDurationSec;
    private double strideDurationSec;
    private double actualStrideDurationSec;
    private double pixelDurationSec;
    private Color color1;
    private Color color2;
    private AMPL_UNIT amplUnit;
    private FREQ_CHANNEL channelMode;
    private COLOR_SCHEME colorScheme;
    private int dataBufferType;
    private boolean adaptiveContrast;
    private double adaptiveMinimum;
    private double upperValueLimit;
    private double lowerValueLimit;
    private double upperValueAdjustment;
    private double lowerValueAdjustment;
    private boolean normalizedInputData;
    private String windowFunction;
    private volatile boolean newDataRequired;
    private volatile boolean newWindowDataRequired;
    private volatile boolean newTransformRequired;
    private volatile boolean newImageRequired;

    public SpectrogramSettings() {
        this.setDefaults();
    }

    private void setDefaults() {
        this.sampleFrequency = 48000.0;
        this.possibleMaxFrequency = 24000.0;
        this.minDisplayFrequency = 0.0;
        this.maxDisplayFrequency = 5000.0;
        this.windowDurationSec = 0.02;
        this.strideDurationSec = 0.01;
        this.pixelDurationSec = 0.01;
        this.dataBufferType = 3;
        this.colorScheme = COLOR_SCHEME.GRAY;
        this.adaptiveContrast = false;
        this.upperValueLimit = 120.0;
        this.lowerValueLimit = 0.0;
        this.amplUnit = AMPL_UNIT.ROOT_POWER;
        this.channelMode = FREQ_CHANNEL.CHANNEL_1;
        this.windowFunction = "Hann";
        this.normalizedInputData = true;
        this.recalculateWindowAndStride();
        this.newTransformRequired = true;
    }

    public void restoreDefaultSettings() {
        this.minDisplayFrequency = 0.0;
        this.maxDisplayFrequency = 5000.0;
        this.windowDurationSec = 0.02;
        this.strideDurationSec = 0.01;
        this.colorScheme = COLOR_SCHEME.GRAY;
        this.adaptiveContrast = false;
        this.upperValueLimit = 120.0;
        this.lowerValueLimit = 0.0;
        this.windowFunction = "Hann";
        this.recalculateWindowAndStride();
        this.newTransformRequired = true;
    }

    private void recalculateWindowAndStride() {
        int power2;
        int samplesPerWinTemp = (int)(this.sampleFrequency * this.windowDurationSec);
        for (power2 = 2; power2 < samplesPerWinTemp; power2 <<= 1) {
        }
        this.numSamplesPerWindow = power2 - samplesPerWinTemp < samplesPerWinTemp - (power2 >> 1) ? power2 : power2 >> 1;
        this.numSamplesPerStride = (int)((double)this.numSamplesPerWindow * (this.strideDurationSec / this.windowDurationSec));
        this.actualWindowDurationSec = (double)this.numSamplesPerWindow / this.sampleFrequency;
        this.actualStrideDurationSec = (double)this.numSamplesPerStride / this.sampleFrequency;
        this.newWindowDataRequired = true;
        this.newTransformRequired = true;
    }

    public double getMinDisplayFrequency() {
        return this.minDisplayFrequency;
    }

    public void setMinDisplayFrequency(double minDisplayFrequency) {
        if (this.minDisplayFrequency != minDisplayFrequency) {
            this.minDisplayFrequency = minDisplayFrequency;
            this.newImageRequired = true;
        }
    }

    public double getMaxDisplayFrequency() {
        return this.maxDisplayFrequency;
    }

    public void setMaxDisplayFrequency(double maxDisplayFrequency) {
        if (this.maxDisplayFrequency != maxDisplayFrequency) {
            this.maxDisplayFrequency = maxDisplayFrequency;
            this.newImageRequired = true;
        }
    }

    public void setMinMaxDisplayFrequency(double minDisplayFrequency, double maxDisplayFrequency) {
        if (this.minDisplayFrequency != minDisplayFrequency || this.maxDisplayFrequency != maxDisplayFrequency) {
            if (minDisplayFrequency < 0.0) {
                this.minDisplayFrequency = 0.0;
            }
            if (minDisplayFrequency >= maxDisplayFrequency) {
                if (maxDisplayFrequency > 1000.0 && maxDisplayFrequency < this.getPossibleMaxFrequency()) {
                    this.maxDisplayFrequency = maxDisplayFrequency;
                    this.minDisplayFrequency = 0.0;
                } else if (minDisplayFrequency < this.getPossibleMaxFrequency() / 2.0) {
                    this.minDisplayFrequency = minDisplayFrequency;
                    this.maxDisplayFrequency = this.getPossibleMaxFrequency();
                } else {
                    this.minDisplayFrequency = 0.0;
                    this.maxDisplayFrequency = this.getPossibleMaxFrequency();
                }
            } else {
                this.minDisplayFrequency = minDisplayFrequency;
                this.maxDisplayFrequency = maxDisplayFrequency;
            }
            this.newImageRequired = true;
        }
    }

    public double getPossibleMaxFrequency() {
        return this.possibleMaxFrequency;
    }

    public void setPossibleMaxFrequency(double possibleMaxFrequency) {
        this.possibleMaxFrequency = possibleMaxFrequency;
    }

    public double getSampleFrequency() {
        return this.sampleFrequency;
    }

    public void setSampleFrequency(double sampleFrequency) {
        if (this.sampleFrequency != sampleFrequency) {
            this.sampleFrequency = sampleFrequency;
            this.possibleMaxFrequency = sampleFrequency / 2.0;
            this.recalculateWindowAndStride();
        }
    }

    public int getNumSamplesPerWindow() {
        return this.numSamplesPerWindow;
    }

    public int getNumSamplesPerStride() {
        return this.numSamplesPerStride;
    }

    public double getWindowDurationSec() {
        return this.windowDurationSec;
    }

    public void setWindowDurationSec(double windowDurationSec) {
        if (this.windowDurationSec != windowDurationSec) {
            this.windowDurationSec = windowDurationSec;
            this.recalculateWindowAndStride();
        }
    }

    public double getActualWindowDurationSec() {
        return this.actualWindowDurationSec;
    }

    public double getStrideDurationSec() {
        return this.strideDurationSec;
    }

    public void setStrideDurationSec(double strideDurationSec) {
        if (this.strideDurationSec != strideDurationSec) {
            this.strideDurationSec = strideDurationSec;
            this.recalculateWindowAndStride();
        }
    }

    public double getActualStrideDurationSec() {
        return this.actualStrideDurationSec;
    }

    public void setWindowAndStride(double windowDurationSec, double strideDurationSec) {
        if (this.windowDurationSec != windowDurationSec || this.strideDurationSec != strideDurationSec) {
            this.windowDurationSec = windowDurationSec < 0.001 ? 0.001 : windowDurationSec;
            this.strideDurationSec = strideDurationSec <= 0.0 ? this.windowDurationSec / 2.0 : (strideDurationSec > this.windowDurationSec ? this.windowDurationSec : strideDurationSec);
            this.recalculateWindowAndStride();
        }
    }

    public double getPixelDurationSec() {
        return this.pixelDurationSec;
    }

    public void setPixelDurationSec(double pixelDurationSec) {
        if (this.pixelDurationSec != pixelDurationSec) {
            this.pixelDurationSec = pixelDurationSec;
            this.newDataRequired = true;
        }
    }

    public Color getColor1() {
        return this.color1;
    }

    public void setColor1(Color color1) {
        this.color1 = color1;
        this.newImageRequired = true;
    }

    public Color getColor2() {
        return this.color2;
    }

    public void setColor2(Color color2) {
        this.color2 = color2;
        this.newImageRequired = true;
    }

    public AMPL_UNIT getAmplUnit() {
        return this.amplUnit;
    }

    public void setAmplUnit(AMPL_UNIT amplUnit) {
        if (this.amplUnit != amplUnit) {
            this.amplUnit = amplUnit;
            this.newTransformRequired = true;
        }
    }

    public COLOR_SCHEME getColorScheme() {
        return this.colorScheme;
    }

    public void setColorScheme(COLOR_SCHEME colorScheme) {
        if (this.colorScheme != colorScheme) {
            this.colorScheme = colorScheme;
            this.newImageRequired = true;
        }
    }

    public FREQ_CHANNEL getChannelMode() {
        return this.channelMode;
    }

    public void setChannelMode(FREQ_CHANNEL channelMode) {
        if (this.channelMode != channelMode) {
            this.channelMode = channelMode;
            this.newDataRequired = true;
        }
    }

    public int getDataBufferType() {
        return this.dataBufferType;
    }

    public void setDataBufferType(int dataBufferType) {
        if (dataBufferType == 5 || dataBufferType == 3) {
            this.dataBufferType = dataBufferType;
            this.newImageRequired = true;
        }
    }

    public boolean isAdaptiveContrast() {
        return this.adaptiveContrast;
    }

    public void setAdaptiveContrast(boolean adaptiveContrast) {
        if (this.adaptiveContrast != adaptiveContrast) {
            this.adaptiveContrast = adaptiveContrast;
            this.newImageRequired = true;
        }
    }

    public double getAdaptiveMinimum() {
        return this.adaptiveMinimum;
    }

    public void setAdaptiveMinimum(double adaptiveMinimum) {
        if (this.adaptiveMinimum != adaptiveMinimum) {
            this.adaptiveMinimum = adaptiveMinimum;
            this.newImageRequired = true;
        }
    }

    public double getUpperValueLimit() {
        return this.upperValueLimit;
    }

    public void setUpperValueLimit(double upperValueLimit) {
        if (this.upperValueLimit != upperValueLimit) {
            this.upperValueLimit = upperValueLimit;
            this.newImageRequired = true;
        }
    }

    public double getLowerValueLimit() {
        return this.lowerValueLimit;
    }

    public void setLowerValueLimit(double lowerValueLimit) {
        if (this.lowerValueLimit != lowerValueLimit) {
            this.lowerValueLimit = lowerValueLimit;
            this.newImageRequired = true;
        }
    }

    public double getUpperValueAdjustment() {
        return this.upperValueAdjustment;
    }

    public double getLowerValueAdjustment() {
        return this.lowerValueAdjustment;
    }

    public void setUpperValueAdjustment(double upperValueAdjustment) {
        if (this.upperValueAdjustment != upperValueAdjustment) {
            this.upperValueAdjustment = upperValueAdjustment;
            this.newImageRequired = true;
        }
    }

    public void setLowerValueAdjustment(double lowerValueAdjustment) {
        if (this.lowerValueAdjustment != lowerValueAdjustment) {
            this.lowerValueAdjustment = lowerValueAdjustment;
            this.newImageRequired = true;
        }
    }

    public boolean isNormalizedInputData() {
        return this.normalizedInputData;
    }

    public void setNormalizedInputData(boolean normalizedInputData) {
        this.normalizedInputData = normalizedInputData;
    }

    public String getWindowFunction() {
        return this.windowFunction;
    }

    public void setWindowFunction(String windowFunction) {
        if (this.windowFunction != null && !this.windowFunction.equals(windowFunction)) {
            this.windowFunction = windowFunction;
            this.newWindowDataRequired = true;
            this.newTransformRequired = true;
        }
    }

    public boolean isNewDataRequired() {
        return this.newDataRequired;
    }

    public boolean isNewWindowDataRequired() {
        return this.newWindowDataRequired;
    }

    public boolean isNewTransformRequired() {
        return this.newTransformRequired;
    }

    public boolean isNewImageRequired() {
        return this.newImageRequired;
    }

    public void resetFlags() {
        this.newDataRequired = false;
        this.newWindowDataRequired = false;
        this.newTransformRequired = false;
        this.newImageRequired = false;
    }

    public static enum COLOR_SCHEME {
        GRAY,
        REVERSED_GRAY,
        BI_COLOR;

    }

    public static enum AMPL_UNIT {
        AMPLITUDE,
        POWER,
        ROOT_POWER;

    }

    public static enum FREQ_CHANNEL {
        CHANNEL_1,
        CHANNEL_2,
        CHANNEL_ALL;

    }

    public static enum PERFORMANCE {
        SPEED,
        QUALITY;

    }
}

