/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.media.spectrogram;

public class WindowFunction {
    private WindowFunction() {
    }

    public static double[] windowForName(WF_NAME winName, int size) {
        if (winName == null) {
            return null;
        }
        switch (winName) {
            case HANN: {
                return WindowFunction.hann(size);
            }
            case HAMMING: {
                return WindowFunction.hamming(size);
            }
            case BLACKMAN: {
                return WindowFunction.blackman(size);
            }
            case BLACKMAN_HARRIS: {
                return WindowFunction.blackmanHarris(size);
            }
            case NUTALL: {
                return WindowFunction.nutall(size);
            }
            case KAISER_BESSEL: {
                return WindowFunction.kaiserBessel(size);
            }
            case FLAT_TOP: {
                return WindowFunction.flatTop(size);
            }
            case BARTLETT: {
                return WindowFunction.bartlett(size);
            }
            case TRIANGULAR: {
                return WindowFunction.triangular(size);
            }
            case GAUSSIAN: {
                return WindowFunction.gaussian(size);
            }
            case TUKEY: {
                return WindowFunction.tukey(size);
            }
            case GAUSSIAN_TUKEY: {
                return WindowFunction.gausTukey(size);
            }
            case WELCH: {
                return WindowFunction.welch(size);
            }
            case RECTANGULAR: {
                return null;
            }
        }
        return WindowFunction.hann(size);
    }

    public static double[] windowForName(WF_NAME winName, int size, double p1, double p2) {
        if (winName == null) {
            return null;
        }
        switch (winName) {
            case GAUSSIAN: {
                return WindowFunction.gaussian(size, p1, true);
            }
            case TUKEY: {
                return WindowFunction.tukey(size, p1);
            }
            case GAUSSIAN_TUKEY: {
                return WindowFunction.gausTukey(size, p1, p2);
            }
        }
        return WindowFunction.windowForName(winName, size);
    }

    public static WF_NAME getWFName(String displayName) {
        for (WF_NAME wfn : WF_NAME.values()) {
            if (!wfn.getDisplayName().equals(displayName)) continue;
            return wfn;
        }
        return null;
    }

    public static double[] hann(int size) {
        return WindowFunction.cosineSum(size, 0.5, 0.5);
    }

    public static double[] hamming(int size) {
        return WindowFunction.cosineSum(size, 0.53836, 0.46164);
    }

    public static double[] blackman(int size) {
        return WindowFunction.cosineSum(size, 0.42659, 0.49656, 0.076849, 0.0);
    }

    public static double[] nutall(int size) {
        return WindowFunction.cosineSum(size, 0.355768, 0.487396, 0.144232, 0.012604);
    }

    public static double[] blackmanHarris(int size) {
        return WindowFunction.cosineSum(size, 0.35875, 0.48829, 0.14128, 0.01168);
    }

    public static double[] kaiserBessel(int size) {
        double[] ar = new double[size];
        int s = size - 1;
        for (int n = 0; n < size; ++n) {
            ar[n] = 1.0 - 1.24 * Math.cos(Math.PI * 2 * (double)n / (double)s) + 0.244 * Math.cos(Math.PI * 4 * (double)n / (double)s) - 0.00305 * Math.cos(Math.PI * 6 * (double)n / (double)s);
        }
        return ar;
    }

    public static double[] flatTop(int size) {
        double[] ar = new double[size];
        int s = size - 1;
        for (int n = 0; n < size; ++n) {
            ar[n] = 0.211557895 - 0.41663158 * Math.cos(Math.PI * 2 * (double)n / (double)s) + 0.277263158 * Math.cos(Math.PI * 4 * (double)n / (double)s) - 0.083578947 * Math.cos(Math.PI * 6 * (double)n / (double)s) + 0.006947368 * Math.cos(Math.PI * 8 * (double)n / (double)s);
        }
        return ar;
    }

    public static double[] cosineSum(int size, double a0, double a1) {
        double[] ar = new double[size];
        int s = size - 1;
        for (int n = 0; n < size; ++n) {
            ar[n] = a0 - a1 * Math.cos(Math.PI * 2 * (double)n / (double)s);
        }
        return ar;
    }

    public static double[] cosineSum(int size, double a0, double a1, double a2, double a3) {
        double[] ar = new double[size];
        int s = size - 1;
        for (int n = 0; n < size; ++n) {
            ar[n] = a0 - a1 * Math.cos(Math.PI * 2 * (double)n / (double)s) + a2 * Math.cos(Math.PI * 4 * (double)n / (double)s) - a3 * Math.cos(Math.PI * 6 * (double)n / (double)s);
        }
        return ar;
    }

    public static double[] bartlett(int size) {
        double s;
        double[] ar = new double[size];
        double L = s = (double)(size - 1);
        for (int n = 0; n < size; ++n) {
            ar[n] = 1.0 - Math.abs(((double)n - s / 2.0) / (L / 2.0));
        }
        return ar;
    }

    public static double[] triangular(int size) {
        double[] ar = new double[size];
        double s = size - 1;
        double L = size;
        for (int n = 0; n < size; ++n) {
            ar[n] = 1.0 - Math.abs(((double)n - s / 2.0) / (L / 2.0));
        }
        return ar;
    }

    public static double[] gaussian(int size, double sigma, boolean multiply) {
        double[] ar = new double[size];
        int s = size - 1;
        for (int n = 0; n < size; ++n) {
            ar[n] = Math.exp(-0.5 * Math.pow(((double)n - (double)s / 2.0) / (sigma * (double)s / 2.0), 2.0));
            if (!multiply) continue;
            int n2 = n;
            ar[n2] = ar[n2] * ar[n];
        }
        return ar;
    }

    public static double[] gaussian(int size) {
        return WindowFunction.gaussian(size, 0.25, true);
    }

    public static double[] gaussianTapered(int size, double sigma) {
        double[] ar = new double[size];
        double[] tw = WindowFunction.planckTaper(size);
        int s = size - 1;
        for (int n = 0; n < size; ++n) {
            ar[n] = Math.exp(-0.5 * Math.pow(((double)n - (double)s / 2.0) / (sigma * (double)s / 2.0), 2.0));
            ar[n] = ar[n] * tw[n];
        }
        return ar;
    }

    public static double[] gaussianTapered(int size) {
        return WindowFunction.gaussianTapered(size, 0.25);
    }

    public static double[] tukey(int size, double alpha) {
        int n;
        double[] ar = new double[size];
        int s = size - 1;
        double an = alpha * (double)s;
        int han = (int)(an / 2.0);
        for (n = 0; n < han; ++n) {
            ar[n] = 0.5 * (1.0 - Math.cos(Math.PI * 2 * (double)n / an));
        }
        for (n = han; n <= s / 2; ++n) {
            ar[n] = 1.0;
        }
        for (n = 0; n <= s / 2; ++n) {
            ar[s - n] = ar[n];
        }
        return ar;
    }

    public static double[] tukey(int size) {
        return WindowFunction.tukey(size, 0.5);
    }

    public static double[] gausTukey(int size, double sigma, double alpha) {
        double[] tw = WindowFunction.tukey(size, alpha);
        double[] gw = WindowFunction.gaussian(size, sigma, false);
        for (int n = 0; n < size; ++n) {
            gw[n] = gw[n] * tw[n];
        }
        return gw;
    }

    public static double[] gausTukey(int size) {
        double[] tw = WindowFunction.tukey(size);
        double[] gw = WindowFunction.gaussian(size);
        for (int n = 0; n < size; ++n) {
            gw[n] = gw[n] * tw[n];
        }
        return gw;
    }

    public static double[] planckTaper(int size) {
        int i;
        int eps = size / 10;
        double[] pt = new double[size];
        int s = size - 1;
        for (i = 1; i < eps; ++i) {
            pt[i] = Math.pow(1.0 + Math.exp(eps / i - eps / (eps - i)), -1.0);
        }
        for (i = eps; i < size / 2; ++i) {
            pt[i] = 1.0;
        }
        pt[0] = 0.0;
        for (i = 0; i < size / 2; ++i) {
            pt[s - i] = pt[i];
        }
        return pt;
    }

    public static double[] welch(int size) {
        double[] ar = new double[size];
        double s = size - 1;
        double hs = s / 2.0;
        for (int n = 0; n < size; ++n) {
            ar[n] = 1.0 - Math.pow(((double)n - hs) / hs, 2.0);
        }
        return ar;
    }

    public static int[] windowLevelFilter(int from, int to) {
        int i;
        int size = 256;
        int[] map = new int[size];
        for (i = 0; i < from; ++i) {
            map[i] = 0;
        }
        for (i = to + 1; i < size; ++i) {
            map[i] = 255;
        }
        double stepSize = 255.0 / (double)(to - from);
        int i2 = 0;
        int j = from;
        while (j <= to) {
            map[j] = (int)Math.round((double)i2 * stepSize);
            ++j;
            ++i2;
        }
        return map;
    }

    private static void print(double[] window) {
        String format = "%.12f   ";
        System.out.println(String.format("Window size: %d", window.length));
        int j = 0;
        for (int i = 0; i < window.length; ++i) {
            System.out.print(String.format(format, window[i]));
            if (++j % 10 != 0) continue;
            System.out.println();
        }
        System.out.println();
    }

    public static enum WF_NAME {
        HANN("hann", "Hann"),
        HAMMING("hamming", "Hamming"),
        BLACKMAN("blackman", "Blackman"),
        NUTALL("nutall", "Nutall"),
        BLACKMAN_HARRIS("black-har", "Blackman-Harris"),
        KAISER_BESSEL("kais-bes", "Kaiser-Bessel"),
        FLAT_TOP("flattop", "Flat Top"),
        BARTLETT("bartlett", "Bartlett"),
        TRIANGULAR("triangular", "Triangular"),
        GAUSSIAN("gaussian", "Gaussian"),
        TUKEY("tukey", "Tukey"),
        GAUSSIAN_TUKEY("gaus-tuk", "Gaussian-Tukey"),
        WELCH("welch", "Welch"),
        RECTANGULAR("rectangular", "Rectangular (none)");

        private final String id;
        private final String dispName;

        private WF_NAME(String id, String dispName) {
            this.dispName = dispName;
            this.id = id;
        }

        public String toString() {
            return this.dispName;
        }

        public final String getId() {
            return this.id;
        }

        public final String getDisplayName() {
            return this.dispName;
        }
    }
}

