/*
 * Decompiled with CFR 0.152.
 */
package staccato.control;

import java.io.File;
import java.util.List;
import java.util.Vector;
import staccato.data.CSVInfo;
import staccato.data.StaccatoData;
import staccato.data.StaccatoNomination;
import staccato.model.StaccatoAnalyzer;
import staccato.model.StaccatoListener;
import staccato.model.io.StaccatoFileParser;
import staccato.model.io.StaccatoFileWriter;

public class StaccatoController {
    private StaccatoData data = new StaccatoData();
    private StaccatoAnalyzer analyzer;

    public void addCSVFile(String string, String string2, List<String> list, List<String> list2, CSVInfo cSVInfo) {
        this.data.addFile(string, list, list2, cSVInfo);
    }

    public void removeAllFiles() {
        this.data.removeAllFiles();
    }

    public int getMaterialLength() {
        return this.data.getMatL();
    }

    public StaccatoData getResult() {
        return this.analyzer.getResult();
    }

    public void process(StaccatoListener staccatoListener) {
        this.analyzer = new StaccatoAnalyzer();
        StaccatoFileParser staccatoFileParser = new StaccatoFileParser();
        Vector<StaccatoNomination> vector = staccatoFileParser.parseFiles(this.data.getFileList());
        this.analyzer.initNominations(vector);
        this.analyzer.process(staccatoListener, this.data);
    }

    public void stopProcessing() {
        this.analyzer.stopProcessing();
    }

    public void saveResult(File file) {
        new StaccatoFileWriter().writeToCSV(file, this.analyzer.getResult(), false);
    }

    public void setAlpha(double d) {
        this.data.setAlpha(d);
    }

    public void setMCSIterations(int n) {
        this.data.setMci(n);
    }

    public void setMaterialLength(int n) {
        this.data.setMatL(n);
    }

    public void setNominationLength(int n) {
        this.data.setNomL(n);
    }

    public void setParameters(int n, int n2, int n3, double d) {
        this.setMaterialLength(n);
        this.setMCSIterations(n2);
        this.setNominationLength(n3);
        this.setAlpha(d);
    }
}

