/*
 * Decompiled with CFR 0.152.
 */
package staccato.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import staccato.data.CSVInfo;
import staccato.data.GeneralFileInfo;
import staccato.data.StaccatoNomination;

public class StaccatoData {
    private List<GeneralFileInfo> fileinfo;
    private Vector<StaccatoNomination> nominations;
    private double f;
    private double k;
    private double z;
    private int[] fRange = new int[]{0, 0};
    private int[] zRange = new int[]{0, 0};
    private int[] kRange = new int[]{0, 0};
    private int matL;
    private int mci;
    private int nomL;
    private double alpha;
    private Vector<StaccatoNomination> kernelNoms;
    private Vector<Vector<StaccatoNomination>> fields;
    private Vector<Vector<StaccatoNomination>> kernels;
    private double og;
    private String resultString;

    public StaccatoData() {
        this.fileinfo = new ArrayList<GeneralFileInfo>();
        this.resultString = "";
    }

    public void addFile(String string, List<String> list, List<String> list2, CSVInfo cSVInfo) {
        GeneralFileInfo generalFileInfo = new GeneralFileInfo(string, list, list2, cSVInfo);
        for (int i = 0; i < this.fileinfo.size(); ++i) {
            String string2 = this.fileinfo.get(i).getFilename();
            if (!string2.equals(string)) continue;
            this.fileinfo.remove(i);
            break;
        }
        this.fileinfo.add(generalFileInfo);
    }

    public void removeAllFiles() {
        while (!this.fileinfo.isEmpty()) {
            this.fileinfo.remove(0);
        }
    }

    public List<String> getAnnotations(String string) {
        List<String> list = new ArrayList<String>();
        for (int i = 0; i < this.fileinfo.size(); ++i) {
            String string2 = this.fileinfo.get(i).getFilename();
            if (!string2.equals(string)) continue;
            list = this.fileinfo.get(i).getAnnotations();
        }
        return list;
    }

    public void setAnnotations(String string, List<String> list) {
        for (int i = 0; i < this.fileinfo.size(); ++i) {
            String string2 = this.fileinfo.get(i).getFilename();
            if (!string2.equals(string)) continue;
            this.fileinfo.get(i).setAnnotations(list);
            break;
        }
    }

    public List<GeneralFileInfo> getFileList() {
        return this.fileinfo;
    }

    public StaccatoData(double d, double d2, double d3) {
        this.f = d;
        this.z = d2;
        this.k = d3;
    }

    public double getF() {
        return this.f;
    }

    public void setF(double d) {
        this.f = d;
    }

    public double getZ() {
        return this.z;
    }

    public void setZ(double d) {
        this.z = d;
    }

    public double getK() {
        return this.k;
    }

    public void setK(double d) {
        this.k = d;
    }

    public int[] getfRange() {
        return this.fRange;
    }

    public int[] getzRange() {
        return this.zRange;
    }

    public int[] getkRange() {
        return this.kRange;
    }

    public Vector<StaccatoNomination> getNominations() {
        return this.nominations;
    }

    public void setNominations(Vector<StaccatoNomination> vector) {
        this.nominations = vector;
    }

    public int getMatL() {
        return this.matL;
    }

    public void setMatL(int n) {
        this.matL = n;
    }

    public int getMci() {
        return this.mci;
    }

    public void setMci(int n) {
        this.mci = n;
    }

    public int getNomL() {
        return this.nomL;
    }

    public void setNomL(int n) {
        this.nomL = n;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double d) {
        this.alpha = d;
    }

    public double getOg() {
        return this.og;
    }

    public void setOg(double d) {
        this.og = d;
    }

    public void setResults(double d, double d2, double d3, int[] nArray, int[] nArray2, int[] nArray3) {
        this.f = d;
        this.z = d2;
        this.k = d3;
        this.fRange = nArray;
        this.zRange = nArray2;
        this.kRange = nArray3;
    }

    public Vector<StaccatoNomination> getKernelNoms() {
        return this.kernelNoms;
    }

    public void setKernelNoms(Vector<StaccatoNomination> vector) {
        this.kernelNoms = vector;
    }

    public Vector<Vector<StaccatoNomination>> getFields() {
        return this.fields;
    }

    public void setFields(Vector<Vector<StaccatoNomination>> vector) {
        this.fields = vector;
    }

    public Vector<Vector<StaccatoNomination>> getKernels() {
        return this.kernels;
    }

    public void setKernels(Vector<Vector<StaccatoNomination>> vector) {
        this.kernels = vector;
    }

    public void setResultString(String string) {
        this.resultString = string;
    }

    public String getResultString() {
        return this.resultString;
    }

    public class StaccatoParameters {
        public static final int MATL = 0;
        public static final int MCS_ITERATIONS = 1000;
        public static final int NOML = 10;
        public static final double ALPHA = 0.05;
    }
}

