/*
 * Decompiled with CFR 0.152.
 */
package staccato.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import staccato.data.StaccatoData;
import staccato.data.StaccatoNomination;
import staccato.model.StaccatoListener;
import staccato.model.StaccatoMCS;

public class StaccatoAnalyzer
extends Thread {
    private int n = 0;
    private double f = 0.0;
    private double k = 0.0;
    private double z = 0.0;
    private Vector<StaccatoNomination> noms = new Vector();
    private Vector<Vector<StaccatoNomination>> fields;
    private Vector<Vector<StaccatoNomination>> kernels;
    private Vector<StaccatoNomination> kernelNoms;
    private StaccatoMCS mcs;
    private StaccatoListener listener;
    private StaccatoData result;

    public void initNominations(Vector<StaccatoNomination> vector) {
        this.fields = new Vector();
        this.kernels = new Vector();
        this.kernelNoms = new Vector();
        this.noms.clear();
        this.noms = vector;
        this.n = 0;
        this.k = 0.0;
        this.z = 0.0;
        this.f = 0.0;
    }

    public void process(StaccatoListener staccatoListener, StaccatoData staccatoData) {
        this.mcs = new StaccatoMCS();
        this.mcs.initControlParameters(staccatoData);
        this.result = staccatoData;
        this.listener = staccatoListener;
        this.start();
    }

    @Override
    public void run() {
        this.n = this.noms.size();
        this.sortNoms();
        this.settleRows();
        this.calcOverlaps();
        this.calcFields();
        this.calcKernels();
        this.mcs.initEmpiricalParameters(this.noms);
        boolean bl = this.mcs.process(this.listener, this.result);
        if (bl) {
            this.listener.reactOnStaccatoEvent(new StaccatoListener.StaccatoEvent(-1));
            System.err.println("Error: Process was interrupted");
            return;
        }
        double d = this.result.getK();
        double d2 = 0.0;
        if (this.k > d) {
            d2 = (this.k - d) / ((double)this.n - d);
        } else if (this.k < d) {
            d2 = (this.k - d) / d;
        }
        this.result.setOg(d2);
        this.result.setKernelNoms(this.kernelNoms);
        this.result.setFields(this.fields);
        this.result.setKernels(this.kernels);
        this.result.setNominations(this.noms);
        String string = "";
        String string2 = "\n";
        double d3 = (double)((int)(d2 * 100000.0)) / 100000.0;
        string = string + "Degree of Organization = " + d3 + string2;
        string = string + string2;
        string = string + "Fields" + string2;
        string = string + this.result.getF() + "\tin MCS" + string2;
        string = string + (int)this.f + "\tin data" + string2;
        string = string + "Nullhypothesis: [" + this.result.getfRange()[0] + ", " + this.result.getfRange()[1] + "]" + string2;
        string = string + string2;
        string = string + "NucleusNominations" + string2;
        string = string + this.result.getK() + "\tin MCS" + string2;
        string = string + (int)this.k + "\tin data" + string2;
        string = string + "Nullhypothesis: [" + this.result.getkRange()[0] + ", " + this.result.getkRange()[1] + "]" + string2;
        string = string + string2;
        string = string + "Nuclei" + string2;
        string = string + this.result.getZ() + "\tin MCS" + string2;
        string = string + (int)this.z + "\tin data" + string2;
        string = string + "Nullhypothesis: [" + this.result.getzRange()[0] + ", " + this.result.getzRange()[1] + "]" + string2;
        this.result.setResultString(string);
        this.listener.reactOnStaccatoEvent(new StaccatoListener.StaccatoEvent(101));
    }

    public StaccatoData processMCS() {
        this.n = this.noms.size();
        this.sortNoms();
        this.settleRows();
        this.calcOverlaps();
        this.calcFields();
        this.calcKernels();
        StaccatoData staccatoData = new StaccatoData(this.f, this.z, this.k);
        return staccatoData;
    }

    private void sortNoms() {
        Collections.sort(this.noms, new Comparator<StaccatoNomination>(){

            @Override
            public int compare(StaccatoNomination staccatoNomination, StaccatoNomination staccatoNomination2) {
                return Integer.valueOf(staccatoNomination.getStart()).compareTo(staccatoNomination2.getStart());
            }
        });
        for (int i = 0; i < this.noms.size(); ++i) {
            this.noms.get(i).setId(i + 1);
        }
    }

    private void settleRows() {
        int n = 1;
        for (int i = 0; i < this.noms.size(); ++i) {
            StaccatoNomination staccatoNomination = this.noms.get(i);
            if (staccatoNomination.getRow() != 0) continue;
            this.noms.get(i).setRow(n);
            int n2 = staccatoNomination.getEnd();
            for (int j = i + 1; j < this.noms.size(); ++j) {
                int n3;
                StaccatoNomination staccatoNomination2 = this.noms.get(j);
                if (staccatoNomination2.getRow() != 0 || (n3 = staccatoNomination2.getStart()) < n2) continue;
                n2 = staccatoNomination2.getEnd();
                this.noms.get(j).setRow(n);
            }
            ++n;
        }
    }

    private void calcOverlaps() {
        for (int i = 0; i < this.noms.size(); ++i) {
            StaccatoNomination staccatoNomination = this.noms.get(i);
            staccatoNomination.addOverlap(staccatoNomination);
            for (int j = i + 1; j < this.noms.size(); ++j) {
                StaccatoNomination staccatoNomination2 = this.noms.get(j);
                if (staccatoNomination.getEnd() <= staccatoNomination2.getStart()) continue;
                staccatoNomination.addOverlap(staccatoNomination2);
                staccatoNomination2.addOverlap(staccatoNomination);
            }
            staccatoNomination.sortOverlaps();
        }
    }

    private void calcFields() {
        block0: for (int i = 0; i < this.noms.size(); ++i) {
            StaccatoNomination staccatoNomination = this.noms.get(i);
            Vector<StaccatoNomination> vector = new Vector<StaccatoNomination>();
            vector.add(staccatoNomination);
            for (int j = i + 1; j < this.noms.size(); ++j) {
                StaccatoNomination staccatoNomination2 = this.noms.get(j);
                if (staccatoNomination.getEnd() > staccatoNomination2.getStart()) {
                    vector.add(staccatoNomination2);
                    if (j == this.noms.size() - 1) {
                        this.fields.add(vector);
                        i = j - 1;
                    }
                } else {
                    this.fields.add(vector);
                    i = j - 1;
                    continue block0;
                }
                staccatoNomination = staccatoNomination2;
            }
        }
        this.f = this.fields.size();
    }

    private void calcKernels() {
        block0: for (int i = 0; i < this.noms.size(); ++i) {
            StaccatoNomination staccatoNomination = this.noms.get(i);
            Vector<StaccatoNomination> vector = staccatoNomination.getOverlaps();
            Vector<StaccatoNomination> vector2 = new Vector<StaccatoNomination>();
            vector2.add(staccatoNomination);
            boolean bl = false;
            for (int j = i + 1; j < this.noms.size(); ++j) {
                StaccatoNomination staccatoNomination2 = this.noms.get(j);
                Vector<StaccatoNomination> vector3 = staccatoNomination2.getOverlaps();
                if (vector.equals(vector3)) {
                    vector2.add(staccatoNomination2);
                    if (j == this.noms.size() - 1 && vector2.size() > 1) {
                        this.kernels.add(vector2);
                        i = j - 1;
                    }
                    if (!bl) {
                        this.kernelNoms.add(staccatoNomination);
                        this.noms.get(i).setKernelNomination(true);
                        bl = true;
                    }
                } else {
                    if (vector2.size() > 1) {
                        this.kernels.add(vector2);
                    }
                    i = j - 1;
                    continue block0;
                }
                this.kernelNoms.add(staccatoNomination2);
                this.noms.get(j).setKernelNomination(true);
            }
        }
        this.z = this.kernels.size();
        this.k = this.kernelNoms.size();
    }

    public void stopProcessing() {
        this.mcs.stopProcessing();
    }

    public StaccatoData getResult() {
        return this.result;
    }
}

