/*
 * Decompiled with CFR 0.152.
 */
package staccato.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import staccato.data.StaccatoData;
import staccato.data.StaccatoNomination;
import staccato.model.StaccatoAnalyzer;
import staccato.model.StaccatoListener;

public class StaccatoMCS
extends Thread {
    private int matL;
    private int minL;
    private int maxL;
    private int n;
    private int mci;
    private int granularity = 2;
    private int[] nomL;
    private double fcount;
    private Vector<Integer> fVec;
    private int[] fAlphaRange = new int[]{0, 0};
    private double zcount;
    private Vector<Integer> zVec;
    private int[] zAlphaRange = new int[]{0, 0};
    private double kcount;
    private Vector<Integer> kVec;
    private int[] kAlphaRange = new int[]{0, 0};
    private double alpha;
    boolean interrupted;

    public void initControlParameters(StaccatoData staccatoData) {
        this.matL = staccatoData.getMatL();
        this.mci = staccatoData.getMci();
        this.alpha = staccatoData.getAlpha();
        this.granularity = staccatoData.getNomL();
        this.nomL = new int[this.granularity];
        for (int i = 0; i < this.granularity; ++i) {
            this.nomL[i] = 0;
        }
    }

    public void initEmpiricalParameters(Vector<StaccatoNomination> vector) {
        int n;
        this.n = vector.size();
        this.minL = Integer.MAX_VALUE;
        this.maxL = 0;
        for (n = 0; n < this.n; ++n) {
            StaccatoNomination staccatoNomination = vector.get(n);
            int n2 = staccatoNomination.getEnd() - staccatoNomination.getStart();
            if (n2 < this.minL) {
                this.minL = n2;
            }
            if (n2 <= this.maxL) continue;
            this.maxL = n2;
        }
        for (n = 0; n < this.granularity; ++n) {
            this.nomL[n] = 0;
        }
        n = this.maxL - this.minL + 1;
        if (n == 0) {
            n = 1;
        }
        for (int i = 0; i < this.n; ++i) {
            StaccatoNomination staccatoNomination = vector.get(i);
            int n3 = staccatoNomination.getEnd() - staccatoNomination.getStart() - this.minL;
            int n4 = (int)((double)n3 / (double)n * (double)(this.granularity * this.granularity));
            int n5 = n4 / this.granularity;
            this.nomL[n5] = this.nomL[n5] + 1;
        }
    }

    public boolean process(StaccatoListener staccatoListener, StaccatoData staccatoData) {
        this.interrupted = false;
        StaccatoAnalyzer staccatoAnalyzer = new StaccatoAnalyzer();
        this.fVec = new Vector();
        this.zVec = new Vector();
        this.kVec = new Vector();
        for (int i = 1; i <= this.mci && !this.interrupted; ++i) {
            StaccatoListener.StaccatoEvent staccatoEvent = new StaccatoListener.StaccatoEvent(i * 100 / this.mci);
            staccatoListener.reactOnStaccatoEvent(staccatoEvent);
            Vector<StaccatoNomination> vector = this.generateNominations();
            staccatoAnalyzer.initNominations(vector);
            StaccatoData staccatoData2 = staccatoAnalyzer.processMCS();
            this.fcount += staccatoData2.getF();
            this.zcount += staccatoData2.getZ();
            this.kcount += staccatoData2.getK();
            this.fVec.add((int)staccatoData2.getF());
            this.zVec.add((int)staccatoData2.getZ());
            this.kVec.add((int)staccatoData2.getK());
        }
        this.sortVecs();
        staccatoData.setResults(this.fcount / (double)this.mci, this.zcount / (double)this.mci, this.kcount / (double)this.mci, this.fAlphaRange, this.zAlphaRange, this.kAlphaRange);
        return this.interrupted;
    }

    private Vector<StaccatoNomination> generateNominations() {
        Vector<StaccatoNomination> vector = new Vector<StaccatoNomination>();
        boolean bl = false;
        if (bl) {
            int n;
            int[] nArray = new int[this.granularity];
            for (n = 0; n < this.granularity; ++n) {
                nArray[n] = this.nomL[n];
            }
            n = this.maxL - this.minL;
            for (int i = 0; i < this.granularity; ++i) {
                int n2 = i * n / this.granularity;
                int n3 = (i + 1) * n / this.granularity;
                while (nArray[i] > 0) {
                    int n4 = this.minL + n2 + (int)(Math.random() * (double)(n3 - n2));
                    int n5 = (int)(Math.random() * (double)(this.matL - n4));
                    StaccatoNomination staccatoNomination = new StaccatoNomination(n5, n5 + n4, i + 1, "test" + (i + 1), "");
                    vector.add(staccatoNomination);
                    if (this.maxL > 24 || this.minL < 6) {
                        System.err.println("Wrong length, looks like a bug :(");
                    }
                    int n6 = i;
                    nArray[n6] = nArray[n6] - 1;
                }
            }
        } else {
            for (int i = 0; i < this.n; ++i) {
                int n = this.minL + (int)(Math.random() * (double)(this.maxL + 1));
                int n7 = (int)(Math.random() * (double)(this.matL - n));
                StaccatoNomination staccatoNomination = new StaccatoNomination(n7, n7 + n, i + 1, "test" + (i + 1), "");
                vector.add(staccatoNomination);
            }
        }
        return vector;
    }

    private void sortVecs() {
        Collections.sort(this.fVec, new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                return n.compareTo(n2);
            }
        });
        Collections.sort(this.zVec, new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                return n.compareTo(n2);
            }
        });
        Collections.sort(this.kVec, new Comparator<Integer>(){

            @Override
            public int compare(Integer n, Integer n2) {
                return n.compareTo(n2);
            }
        });
        int n = (int)((double)this.fVec.size() * this.alpha);
        int n2 = (int)((double)this.fVec.size() * (1.0 - this.alpha));
        int n3 = this.fVec.get(n);
        int n4 = this.fVec.get(n2);
        if (this.fVec.get(n + 1) == n3) {
            --n3;
        }
        if (this.fVec.get(n2 - 1) == n4 && ++n4 > this.fVec.get(this.fVec.size() - 1)) {
            n4 = -1;
        }
        this.fAlphaRange[0] = n3;
        this.fAlphaRange[1] = n4;
        n = (int)((double)this.zVec.size() * this.alpha);
        n2 = (int)((double)this.zVec.size() * (1.0 - this.alpha));
        n3 = this.zVec.get(n);
        n4 = this.zVec.get(n2);
        if (this.zVec.get(n + 1) == n3) {
            --n3;
        }
        if (this.zVec.get(n2 - 1) == n4 && ++n4 > this.zVec.get(this.zVec.size() - 1)) {
            n4 = -1;
        }
        this.zAlphaRange[0] = n3;
        this.zAlphaRange[1] = n4;
        n = (int)((double)this.kVec.size() * this.alpha);
        n2 = (int)((double)this.kVec.size() * (1.0 - this.alpha));
        n3 = this.kVec.get(n);
        n4 = this.kVec.get(n2);
        if (this.kVec.get(n + 1) == n3) {
            --n3;
        }
        if (this.kVec.get(n2 - 1) == n4 && ++n4 > this.kVec.get(this.kVec.size() - 1)) {
            n4 = -1;
        }
        this.kAlphaRange[0] = n3;
        this.kAlphaRange[1] = n4;
    }

    public void stopProcessing() {
        this.interrupted = true;
    }
}

