/*
 * Decompiled with CFR 0.152.
 */
package staccato.model.io;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Vector;
import staccato.data.CSVInfo;
import staccato.data.GeneralFileInfo;
import staccato.data.StaccatoNomination;

public class StaccatoFileParser {
    public Vector<StaccatoNomination> parseFiles(List<GeneralFileInfo> list) {
        Vector<StaccatoNomination> vector = new Vector<StaccatoNomination>();
        for (int i = 0; i < list.size(); ++i) {
            GeneralFileInfo generalFileInfo = list.get(i);
            this.parseCSV(generalFileInfo, vector);
        }
        return vector;
    }

    public int[] checkCSV(File file) {
        Object object;
        int n = 0;
        int n2 = 0;
        try {
            String string;
            object = new FileInputStream(file.getAbsoluteFile());
            DataInputStream dataInputStream = new DataInputStream((InputStream)object);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
            int n3 = 0;
            while ((string = bufferedReader.readLine()) != null) {
                if (n3 == 0) {
                    n2 = string.split("\t").length;
                }
                ++n3;
            }
            dataInputStream.close();
            n = n3;
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception.getMessage());
        }
        object = new int[2];
        object[0] = n;
        object[1] = n2;
        return object;
    }

    public Vector<String> grabCSVNominationCandidates(File file, CSVInfo cSVInfo) {
        Vector<String> vector = new Vector<String>();
        int n = cSVInfo.getNominationCol();
        if (n < 0) {
            return vector;
        }
        try {
            String string;
            FileInputStream fileInputStream = new FileInputStream(file.getAbsoluteFile());
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
            int n2 = 0;
            while ((string = bufferedReader.readLine()) != null) {
                if (cSVInfo.getParseFromLine() > n2) {
                    ++n2;
                    continue;
                }
                String[] stringArray = string.split(cSVInfo.getSeparator());
                if (stringArray.length - 1 < n) {
                    System.err.println("FAILURE IN LINE " + n2);
                    continue;
                }
                String string2 = stringArray[n];
                if (!vector.contains(string2)) {
                    vector.add(string2);
                }
                ++n2;
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("ERROR WHILE grabCSVNominationCandidates");
            System.err.println("Error: " + exception.getMessage());
        }
        return vector;
    }

    public Vector<String> grabCSVAnnotatorCandidates(File file, CSVInfo cSVInfo) {
        Vector<String> vector = new Vector<String>();
        int n = cSVInfo.getAnnotatorCol() - 1;
        if (n < 0) {
            return vector;
        }
        try {
            String string;
            FileInputStream fileInputStream = new FileInputStream(file.getAbsoluteFile());
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
            int n2 = 0;
            while ((string = bufferedReader.readLine()) != null) {
                if (cSVInfo.getParseFromLine() > n2) {
                    ++n2;
                    continue;
                }
                String[] stringArray = string.split(cSVInfo.getSeparator());
                if (stringArray.length - 1 < n) {
                    System.err.println("FAILURE IN LINE " + n2);
                    continue;
                }
                String string2 = stringArray[n];
                if (!vector.contains(string2)) {
                    vector.add(string2);
                }
                ++n2;
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("ERROR WHILE grabCSVAnnotatorCandidates");
            System.err.println("Error: " + exception.getMessage());
        }
        return vector;
    }

    public int[] getMinMaxMatL(Vector<GeneralFileInfo> vector) {
        int[] nArray = new int[]{Integer.MAX_VALUE, Integer.MIN_VALUE};
        for (int i = 0; i < vector.size(); ++i) {
            GeneralFileInfo generalFileInfo = vector.get(i);
            File file = new File(generalFileInfo.getFilename());
            CSVInfo cSVInfo = generalFileInfo.getCsvInfo();
            int n = Integer.MIN_VALUE;
            int n2 = cSVInfo.getEndCol() - 1;
            try {
                String string;
                FileInputStream fileInputStream = new FileInputStream(file.getAbsoluteFile());
                DataInputStream dataInputStream = new DataInputStream(fileInputStream);
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
                int n3 = 0;
                while ((string = bufferedReader.readLine()) != null) {
                    if (cSVInfo.getParseFromLine() > n3) {
                        ++n3;
                        continue;
                    }
                    String string2 = string.split(cSVInfo.getSeparator())[n2];
                    int n4 = Integer.parseInt(string2);
                    if (n4 > n) {
                        n = n4;
                    }
                    ++n3;
                }
                dataInputStream.close();
            }
            catch (Exception exception) {
                System.err.println("Error: " + exception.getMessage());
            }
            if (n < nArray[0]) {
                nArray[0] = n;
            }
            if (n <= nArray[1]) continue;
            nArray[1] = n;
        }
        return nArray;
    }

    private void parseCSV(GeneralFileInfo generalFileInfo, Vector<StaccatoNomination> vector) {
        int n;
        String string = generalFileInfo.getFilename();
        CSVInfo cSVInfo = generalFileInfo.getCsvInfo();
        List<String> list = generalFileInfo.getAnnotations();
        List<String> list2 = generalFileInfo.getAnnotators();
        int n2 = cSVInfo.getParseFromLine();
        int n3 = n = vector.size();
        try {
            String string2;
            FileInputStream fileInputStream = new FileInputStream(string);
            DataInputStream dataInputStream = new DataInputStream(fileInputStream);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(dataInputStream));
            int n4 = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                int n5;
                if (n4 < n2) {
                    ++n4;
                    continue;
                }
                String[] stringArray = string2.split(cSVInfo.getSeparator());
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i] != null && !stringArray[i].equals("")) continue;
                }
                if (stringArray.length < 3) continue;
                String string3 = stringArray[cSVInfo.getNominationCol()];
                String string4 = "";
                if (cSVInfo.getAnnotatorCol() >= 0) {
                    string4 = stringArray[cSVInfo.getAnnotatorCol()];
                }
                boolean bl = false;
                if (list.size() > 0) {
                    for (n5 = 0; n5 < list.size(); ++n5) {
                        if (!string3.equals(list.get(n5))) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                }
                if (list2.size() > 0) {
                    bl = false;
                    for (n5 = 0; n5 < list2.size(); ++n5) {
                        if (!string4.equals(list2.get(n5))) continue;
                        bl = true;
                        break;
                    }
                    if (!bl) continue;
                }
                StaccatoNomination staccatoNomination = new StaccatoNomination(Integer.parseInt(stringArray[cSVInfo.getStartCol()]), Integer.parseInt(stringArray[cSVInfo.getEndCol()]), n++, string3, string4);
                vector.add(staccatoNomination);
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Error: " + exception.getMessage());
        }
        n3 = n - n3;
        generalFileInfo.setNumAnnotations(n3);
    }
}

