/*
 * Decompiled with CFR 0.152.
 */
package staccato.view;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import staccato.data.CSVInfo;
import staccato.data.GeneralFileInfo;
import staccato.model.io.StaccatoFileParser;
import staccato.view.FilePanel;

public class FileInfoPanel
extends JPanel
implements ActionListener {
    private JLabel fileLb;
    private JComboBox startBox;
    private JComboBox endBox;
    private JComboBox nominationBox;
    private JComboBox annotatorBox;
    private JCheckBox skipChk;
    private JButton applyBt;
    private JButton cancelBt;
    private JScrollPane scroll1;
    private JScrollPane scroll2;
    private Vector<JCheckBox> annotationBoxes;
    private JLabel annotationLb;
    private String annotationFiller;
    private Vector<JCheckBox> annotatorBoxes;
    private JLabel annotatorLb;
    private String annotatorFiller;
    private File file;
    private int numCols;
    private FilePanel filePanel;

    public FileInfoPanel(FilePanel filePanel) {
        this.filePanel = filePanel;
        this.numCols = 0;
    }

    public String getFilename() {
        return this.file.getAbsolutePath();
    }

    public void initForFile(File file) {
        this.file = file;
        int[] nArray = new StaccatoFileParser().checkCSV(file);
        this.numCols = nArray[1];
        this.initFileInfoPanelGui();
        this.setVisible(true);
    }

    private void initFileInfoPanelGui() {
        this.setLayout(null);
        this.setBackground(this.filePanel.getBackground());
        this.setBounds(this.filePanel.getX(), this.filePanel.getY(), this.filePanel.getWidth(), this.filePanel.getHeight());
        this.fileLb = new JLabel("FILE: " + this.file.getAbsolutePath());
        this.fileLb.setForeground(Color.BLUE);
        this.fileLb.setBounds(5, 5, this.getWidth() - 10, 20);
        this.add(this.fileLb);
        String[] stringArray = new String[this.numCols];
        for (int i = 0; i < this.numCols; ++i) {
            stringArray[i] = String.valueOf(i + 1);
        }
        String[] stringArray2 = new String[this.numCols + 1];
        stringArray2[0] = "";
        for (int i = 1; i < this.numCols + 1; ++i) {
            stringArray2[i] = String.valueOf(i);
        }
        String[] stringArray3 = new String[this.numCols + 1];
        stringArray3[0] = "[ignore]";
        for (int i = 1; i < this.numCols + 1; ++i) {
            stringArray3[i] = String.valueOf(i);
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        jPanel.setBounds(5, 40, 300, 400);
        this.add(jPanel);
        JLabel jLabel = new JLabel("Specify column information:");
        jLabel.setBounds(5, 5, 200, 25);
        jPanel.add(jLabel);
        JLabel jLabel2 = new JLabel("Start Column");
        jLabel2.setBounds(5, 50, 100, 25);
        jPanel.add(jLabel2);
        this.startBox = new JComboBox<String>(stringArray);
        this.startBox.setBounds(150, 50, 100, 25);
        jPanel.add(this.startBox);
        JLabel jLabel3 = new JLabel("End Column");
        jLabel3.setBounds(5, 80, 100, 25);
        jPanel.add(jLabel3);
        this.endBox = new JComboBox<String>(stringArray);
        this.endBox.setBounds(150, 80, 100, 25);
        this.endBox.setSelectedIndex(1);
        jPanel.add(this.endBox);
        JLabel jLabel4 = new JLabel("Nomination Column");
        jLabel4.setBounds(5, 110, 150, 25);
        jPanel.add(jLabel4);
        this.nominationBox = new JComboBox<String>(stringArray2);
        this.nominationBox.setBounds(150, 110, 100, 25);
        this.nominationBox.addActionListener(this);
        jPanel.add(this.nominationBox);
        JLabel jLabel5 = new JLabel("Annotator Column");
        jLabel5.setBounds(5, 140, 150, 25);
        jPanel.add(jLabel5);
        this.annotatorBox = new JComboBox<String>(stringArray3);
        this.annotatorBox.setBounds(150, 140, 100, 25);
        this.annotatorBox.addActionListener(this);
        jPanel.add(this.annotatorBox);
        JLabel jLabel6 = new JLabel("Skip first row?");
        jLabel6.setBounds(5, 170, 120, 25);
        jPanel.add(jLabel6);
        this.skipChk = new JCheckBox();
        this.skipChk.setSelected(true);
        this.skipChk.setBackground(jPanel.getBackground());
        this.skipChk.setBounds(150, 170, 50, 25);
        jPanel.add(this.skipChk);
        this.applyBt = new JButton("Add");
        this.applyBt.setEnabled(false);
        this.applyBt.setBounds(130, 520, 120, 25);
        this.applyBt.addActionListener(this);
        this.add(this.applyBt);
        this.cancelBt = new JButton("Delete");
        this.cancelBt.setBounds(5, 520, 120, 25);
        this.cancelBt.addActionListener(this);
        this.add(this.cancelBt);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(null);
        jPanel2.setBounds(310, 40, 240, 500);
        this.add(jPanel2);
        this.annotationFiller = new String("<HTML><BODY>");
        JLabel jLabel7 = new JLabel("Select Annotations:");
        jLabel7.setBounds(5, 5, 200, 25);
        jPanel2.add(jLabel7);
        this.annotationBoxes = new Vector();
        this.annotationLb = new JLabel();
        this.annotationLb.setFont(new Font(null, 0, 20));
        this.annotationLb.setText(this.annotationFiller);
        this.scroll1 = new JScrollPane(this.annotationLb, 22, 30);
        this.scroll1.setBounds(5, 30, 220, 210);
        jPanel2.add(this.scroll1);
        this.annotatorFiller = new String("<HTML><BODY>");
        JLabel jLabel8 = new JLabel("Select Annotators:");
        jLabel8.setBounds(5, 245, 200, 25);
        jPanel2.add(jLabel8);
        this.annotatorBoxes = new Vector();
        this.annotatorLb = new JLabel();
        this.annotatorLb.setFont(new Font(null, 0, 20));
        this.annotatorLb.setText(this.annotatorFiller);
        this.scroll2 = new JScrollPane(this.annotatorLb, 22, 30);
        this.scroll2.setBounds(5, 270, 220, 210);
        jPanel2.add(this.scroll2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JCheckBox jCheckBox;
        int n;
        Vector<String> vector;
        String string = "\t";
        int n2 = 0;
        if (this.skipChk.isSelected()) {
            n2 = 1;
        }
        int n3 = Integer.parseInt(this.startBox.getSelectedItem().toString());
        int n4 = Integer.parseInt(this.endBox.getSelectedItem().toString());
        String string2 = this.nominationBox.getSelectedItem().toString();
        int n5 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!string2.equals("")) {
            n5 = Integer.parseInt(string2);
            for (int i = 0; i < this.annotationBoxes.size(); ++i) {
                if (!this.annotationBoxes.get(i).isSelected()) continue;
                arrayList.add(this.annotationBoxes.get(i).getText());
            }
        }
        String string3 = this.annotatorBox.getSelectedItem().toString();
        int n6 = 0;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        if (!string3.equals("[ignore]")) {
            n6 = Integer.parseInt(this.annotatorBox.getSelectedItem().toString());
            for (int i = 0; i < this.annotatorBoxes.size(); ++i) {
                if (!this.annotatorBoxes.get(i).isSelected()) continue;
                arrayList2.add(this.annotatorBoxes.get(i).getText());
            }
        }
        CSVInfo cSVInfo = new CSVInfo(string, n2, --n5, --n3, --n4, --n6);
        if (actionEvent.getSource() == this.applyBt) {
            vector = new GeneralFileInfo(this.file.getAbsolutePath(), arrayList, arrayList2, cSVInfo);
            this.filePanel.addFileToList(this.file.getAbsolutePath(), true, (GeneralFileInfo)((Object)vector));
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.cancelBt) {
            this.filePanel.addFileToList(this.file.getAbsolutePath(), false, null);
            this.setVisible(false);
        } else if (actionEvent.getSource() == this.nominationBox) {
            vector = new StaccatoFileParser().grabCSVNominationCandidates(this.file, cSVInfo);
            this.annotationBoxes.clear();
            this.annotationLb.removeAll();
            this.annotationFiller = "<HTML><BODY>";
            for (n = 0; n < vector.size(); ++n) {
                jCheckBox = new JCheckBox(vector.get(n), true);
                jCheckBox.setBounds(0, n * 30, 400, 20);
                jCheckBox.addActionListener(this);
                this.annotationBoxes.add(jCheckBox);
                this.annotationLb.add(jCheckBox);
                this.annotationFiller = this.annotationFiller + "<BR>";
            }
            this.annotationLb.setText(this.annotationFiller);
            this.scroll1.repaint();
        } else if (actionEvent.getSource() == this.annotatorBox) {
            vector = new StaccatoFileParser().grabCSVAnnotatorCandidates(this.file, cSVInfo);
            this.annotatorBoxes.clear();
            this.annotatorLb.removeAll();
            this.annotatorFiller = "<HTML><BODY>";
            for (n = 0; n < vector.size(); ++n) {
                jCheckBox = new JCheckBox(vector.get(n), true);
                jCheckBox.setBounds(0, n * 30, 400, 20);
                this.annotatorBoxes.add(jCheckBox);
                this.annotatorLb.add(jCheckBox);
                this.annotatorFiller = this.annotatorFiller + "<BR>";
            }
            this.annotatorLb.setText(this.annotationFiller);
            this.scroll2.repaint();
        }
        boolean bl = false;
        for (n = 0; n < this.annotationBoxes.size(); ++n) {
            if (!this.annotationBoxes.get(n).isSelected()) continue;
            bl = true;
            this.applyBt.setEnabled(true);
            break;
        }
        this.applyBt.setEnabled(bl);
    }
}

