/*
 * Decompiled with CFR 0.152.
 */
package staccato.view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import staccato.data.GeneralFileInfo;
import staccato.view.FileInfoPanel;
import staccato.view.GuiEvent;
import staccato.view.MainWindow;

public class FilePanel
extends JPanel
implements ActionListener {
    private MainWindow mainWindow;
    private JButton addBt;
    private JButton delBt;
    private JButton editBt;
    private JButton nextBt;
    private JFileChooser fc;
    private DefaultListModel model;
    private JList list;
    private int numProcessedFiles;
    private Vector<FileInfoPanel> fileInfoPanels;

    public FilePanel(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.fc = new JFileChooser();
        this.fc.setMultiSelectionEnabled(true);
        this.add(this.fc);
        this.numProcessedFiles = 0;
        this.fileInfoPanels = new Vector();
        this.initFilePanelGui();
    }

    private void initFilePanelGui() {
        this.setLayout(null);
        this.setBounds(5, 5, 750, 550);
        this.addBt = new JButton("Add");
        this.addBt.setBounds(410, 5, 120, 25);
        this.addBt.addActionListener(this);
        this.add(this.addBt);
        this.delBt = new JButton("Delete");
        this.delBt.setBounds(410, 35, 120, 25);
        this.delBt.addActionListener(this);
        this.add(this.delBt);
        this.editBt = new JButton("Edit");
        this.editBt.setBounds(410, 65, 120, 25);
        this.editBt.addActionListener(this);
        this.add(this.editBt);
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        JScrollPane jScrollPane = new JScrollPane(this.list);
        jScrollPane.setBounds(5, 5, 380, 450);
        this.add(jScrollPane);
        this.nextBt = new JButton("Next");
        this.nextBt.setBounds(410, 520, 120, 25);
        this.nextBt.addActionListener(this);
        this.nextBt.setEnabled(false);
        this.add(this.nextBt);
        this.add(new FileInfoPanel(this));
        this.addBt.doClick();
    }

    public void removeFileFromList(String string) {
        int n;
        this.mainWindow.removeGeneralFileInfo(string);
        for (n = 0; n < this.fileInfoPanels.size(); ++n) {
            if (!string.equals(this.fileInfoPanels.get(n).getFilename())) continue;
            this.fileInfoPanels.remove(n);
            break;
        }
        for (n = 0; n < this.model.size(); ++n) {
            if (!string.equals(this.model.get(n).toString())) continue;
            this.model.remove(n);
            break;
        }
        if (this.model.getSize() == 0) {
            this.nextBt.setEnabled(false);
        }
    }

    public void addFileToList(String string, boolean bl, GeneralFileInfo generalFileInfo) {
        if (bl) {
            if (this.mainWindow.addGeneralFileInfo(generalFileInfo)) {
                this.model.add(this.model.getSize(), string);
            }
        } else {
            this.removeFileFromList(string);
        }
        --this.numProcessedFiles;
        if (this.numProcessedFiles <= 0) {
            this.setVisible(true);
        }
        if (this.model.getSize() > 0) {
            this.nextBt.setEnabled(true);
        }
    }

    public void clear() {
        this.fileInfoPanels.clear();
        this.model.removeAllElements();
        this.list.removeAll();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        block9: {
            block10: {
                block8: {
                    if (actionEvent.getSource() != this.nextBt) break block8;
                    this.mainWindow.guiEvent(new GuiEvent(this, 1));
                    break block9;
                }
                if (actionEvent.getSource() != this.addBt) break block10;
                int n = this.fc.showOpenDialog(this);
                if (n != 0) break block9;
                File[] fileArray = this.fc.getSelectedFiles();
                this.setVisible(false);
                this.numProcessedFiles = fileArray.length;
                for (int i = 0; i < fileArray.length; ++i) {
                    FileInfoPanel fileInfoPanel = new FileInfoPanel(this);
                    fileInfoPanel.initForFile(fileArray[i]);
                    this.mainWindow.add(fileInfoPanel);
                    this.fileInfoPanels.add(fileInfoPanel);
                }
                break block9;
            }
            if (actionEvent.getSource() == this.delBt) {
                if (this.list.isSelectionEmpty()) {
                    return;
                }
                int n = this.list.getSelectedIndex();
                String string = this.model.get(n).toString();
                this.removeFileFromList(string);
            } else if (actionEvent.getSource() == this.editBt) {
                if (this.list.isSelectionEmpty()) {
                    return;
                }
                int n = this.list.getSelectedIndex();
                if (this.model.getSize() == 0) {
                    this.nextBt.setEnabled(false);
                }
                this.setVisible(false);
                String string = this.model.get(n).toString();
                for (int i = 0; i < this.fileInfoPanels.size(); ++i) {
                    if (!string.equals(this.fileInfoPanels.get(i).getFilename())) continue;
                    this.fileInfoPanels.get(i).setVisible(true);
                    ++this.numProcessedFiles;
                    this.setVisible(false);
                }
            }
        }
    }
}

