/*
 * Decompiled with CFR 0.152.
 */
package staccato.view;

import java.io.File;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import staccato.control.StaccatoController;
import staccato.data.GeneralFileInfo;
import staccato.view.FilePanel;
import staccato.view.GuiEvent;
import staccato.view.MatLPanel;
import staccato.view.ProcessPanel;
import staccato.view.ResultPanel;

public class MainWindow
extends JFrame {
    private Vector<GeneralFileInfo> generalFileInfos = new Vector();
    private FilePanel filePanel;
    private MatLPanel matLPanel;
    private ProcessPanel processPanel;
    private ResultPanel resultPanel;
    private StaccatoController controller = new StaccatoController();

    public MainWindow() {
        this.initMainWindow();
    }

    private void initMainWindow() {
        this.setTitle("Staccato - Select Files");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 550, 600);
        this.setLayout(null);
        this.filePanel = new FilePanel(this);
        this.filePanel.setVisible(true);
        this.add(this.filePanel);
        this.matLPanel = new MatLPanel(this);
        this.matLPanel.setVisible(false);
        this.add(this.matLPanel);
        this.processPanel = new ProcessPanel(this);
        this.processPanel.setVisible(false);
        this.add(this.processPanel);
        this.resultPanel = new ResultPanel(this);
        this.resultPanel.setVisible(false);
        this.add(this.resultPanel);
        this.setVisible(true);
    }

    public void guiEvent(GuiEvent guiEvent) {
        JPanel jPanel = guiEvent.panel;
        int n = guiEvent.event;
        if (jPanel == this.filePanel) {
            if (n == 1) {
                for (int i = 0; i < this.generalFileInfos.size(); ++i) {
                    this.filePanel.setVisible(false);
                    this.matLPanel.setVisible(true);
                    this.matLPanel.update(this.generalFileInfos);
                }
            }
        } else if (jPanel == this.matLPanel) {
            if (n == 1) {
                this.matLPanel.setVisible(false);
                this.processPanel.setVisible(true);
                this.setTitle("Staccato - Ready to proceed");
            } else if (n == 0) {
                this.filePanel.setVisible(true);
                this.matLPanel.setVisible(false);
                this.setTitle("Staccato - Select Files");
            }
        } else if (jPanel == this.processPanel) {
            if (n == 1) {
                this.processPanel.setVisible(false);
                this.resultPanel.setVisible(true);
                this.resultPanel.setResultString("" + this.controller.getResult().getResultString());
                this.setTitle("Staccato - Results");
            } else if (n == 0) {
                this.matLPanel.setVisible(true);
                this.processPanel.setVisible(false);
                this.setTitle("Staccato - Select Material Length");
            } else if (n == 3) {
                this.controller.removeAllFiles();
                for (int i = 0; i < this.generalFileInfos.size(); ++i) {
                    this.controller.addCSVFile(this.generalFileInfos.get(i).getFilename(), this.generalFileInfos.get(i).getCsvInfo().getSeparator(), this.generalFileInfos.get(i).getAnnotations(), this.generalFileInfos.get(i).getAnnotators(), this.generalFileInfos.get(i).getCsvInfo());
                }
                this.controller.process(this.processPanel);
            } else if (n == 4) {
                this.controller.stopProcessing();
            }
        } else if (jPanel == this.resultPanel) {
            if (n == 2) {
                this.generalFileInfos.clear();
                this.filePanel.clear();
                this.filePanel.setVisible(true);
                this.resultPanel.setVisible(false);
                this.setTitle("Staccato - Select Files");
            } else if (n == 0) {
                this.processPanel.setVisible(true);
                this.resultPanel.setVisible(false);
                this.setTitle("Staccato - Ready to proceed");
            }
        }
    }

    public boolean addGeneralFileInfo(GeneralFileInfo generalFileInfo) {
        String string = generalFileInfo.getFilename();
        boolean bl = true;
        for (int i = 0; i < this.generalFileInfos.size(); ++i) {
            if (!this.generalFileInfos.get(i).getFilename().equals(string)) continue;
            this.generalFileInfos.remove(i);
            bl = false;
            break;
        }
        this.generalFileInfos.add(generalFileInfo);
        return bl;
    }

    public void removeGeneralFileInfo(String string) {
        for (int i = 0; i < this.generalFileInfos.size(); ++i) {
            if (!this.generalFileInfos.get(i).getFilename().equals(string)) continue;
            this.generalFileInfos.remove(i);
            break;
        }
    }

    public void setMatL(int n) {
        this.controller.setMaterialLength(n);
    }

    public void setParameters(int n, int n2, double d) {
        this.controller.setParameters(this.controller.getMaterialLength(), n, n2, d);
    }

    public Vector<GeneralFileInfo> getGeneralFileInfos() {
        return this.generalFileInfos;
    }

    public void saveResult(File file) {
        this.controller.saveResult(file);
    }
}

