/*
 * Decompiled with CFR 0.152.
 */
package staccato.view;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import staccato.data.GeneralFileInfo;
import staccato.model.io.StaccatoFileParser;
import staccato.view.GuiEvent;
import staccato.view.MainWindow;

public class MatLPanel
extends JPanel
implements ActionListener {
    private JButton nextBt;
    private JButton backBt;
    private ButtonGroup buttonGroup;
    private JRadioButton minBt;
    private JRadioButton maxBt;
    private JRadioButton manBt;
    private JTextField manFl;
    private MainWindow mainWindow;
    private int[] matLvalues;
    private int matLselected;

    public MatLPanel(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        int[] nArray = new StaccatoFileParser().getMinMaxMatL(mainWindow.getGeneralFileInfos());
        int n = (nArray[0] + nArray[1]) / 2;
        this.matLvalues = new int[]{nArray[0], nArray[1], n};
        this.matLselected = this.matLvalues[0];
        this.initMatLPanelGui();
    }

    private void initMatLPanelGui() {
        this.setLayout(null);
        this.setBounds(5, 5, 750, 550);
        JLabel jLabel = new JLabel();
        String string = "Set material lenght. Units in the files must be equal!";
        jLabel.setText(string);
        jLabel.setBounds(5, 5, 400, 30);
        this.add(jLabel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        jPanel.setBounds(5, 50, 400, 100);
        this.buttonGroup = new ButtonGroup();
        this.minBt = new JRadioButton("Min: " + this.matLvalues[0], true);
        this.minBt.setBounds(5, 5, 300, 25);
        this.minBt.addActionListener(this);
        this.buttonGroup.add(this.minBt);
        jPanel.add(this.minBt);
        this.maxBt = new JRadioButton("Max: " + this.matLvalues[1], false);
        this.maxBt.setBounds(5, 35, 300, 25);
        this.maxBt.addActionListener(this);
        this.buttonGroup.add(this.maxBt);
        jPanel.add(this.maxBt);
        this.manBt = new JRadioButton("Manual: ", false);
        this.manBt.setBounds(5, 65, 115, 25);
        this.manBt.addActionListener(this);
        this.buttonGroup.add(this.manBt);
        jPanel.add(this.manBt);
        this.manFl = new JTextField(this.matLvalues[2]);
        this.manFl.setBounds(120, 65, 100, 25);
        jPanel.add(this.manFl);
        this.add(jPanel);
        this.nextBt = new JButton("Next");
        this.nextBt.setBounds(410, 520, 120, 25);
        this.nextBt.addActionListener(this);
        this.add(this.nextBt);
        this.backBt = new JButton("Back");
        this.backBt.setBounds(285, 520, 120, 25);
        this.backBt.addActionListener(this);
        this.add(this.backBt);
    }

    public void update(Vector<GeneralFileInfo> vector) {
        int[] nArray = new StaccatoFileParser().getMinMaxMatL(this.mainWindow.getGeneralFileInfos());
        int n = (nArray[0] + nArray[1]) / 2;
        this.matLvalues = new int[]{nArray[0], nArray[1], n};
        this.minBt.setText("Min: " + this.matLvalues[0]);
        this.maxBt.setText("Max: " + this.matLvalues[1]);
        this.manBt.setText("Manual: ");
        this.manFl.setText("" + this.matLvalues[2]);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.nextBt) {
            this.mainWindow.setMatL(this.matLselected);
            this.mainWindow.guiEvent(new GuiEvent(this, 1));
        } else if (actionEvent.getSource() == this.backBt) {
            this.mainWindow.guiEvent(new GuiEvent(this, 0));
        } else if (actionEvent.getSource() == this.minBt) {
            this.matLselected = this.matLvalues[0];
        } else if (actionEvent.getSource() == this.maxBt) {
            this.matLselected = this.matLvalues[1];
        } else if (actionEvent.getSource() == this.manBt) {
            this.matLvalues[2] = this.matLselected = Integer.parseInt(this.manFl.getText());
        }
    }
}

