/*
 * Decompiled with CFR 0.152.
 */
package staccato.view;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import staccato.model.StaccatoListener;
import staccato.view.GuiEvent;
import staccato.view.MainWindow;

public class ProcessPanel
extends JPanel
implements ActionListener,
StaccatoListener {
    private JButton processBt;
    private JLabel statusLb;
    private JTextField mciFl;
    private JTextField nomLFl;
    private JTextField alphaFl;
    private JButton nextBt;
    private JButton backBt;
    private MainWindow mainWindow;
    private boolean running;
    private boolean hasResults;
    private int lastEventId;

    public ProcessPanel(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.running = false;
        this.hasResults = false;
        this.lastEventId = 0;
        this.initProcessPanelGui();
    }

    private void initProcessPanelGui() {
        this.setLayout(null);
        this.setBounds(5, 5, 750, 550);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(null);
        jPanel.setBounds(5, 5, 400, 100);
        this.add(jPanel);
        this.mciFl = new JTextField("1000");
        this.nomLFl = new JTextField("10");
        this.alphaFl = new JTextField("0.05");
        JLabel jLabel = new JLabel("MC-Iterations:");
        jLabel.setBounds(5, 5, 150, 25);
        jPanel.add(jLabel);
        this.mciFl.setBounds(160, 5, 100, 25);
        jPanel.add(this.mciFl);
        JLabel jLabel2 = new JLabel("Nom. length:");
        jLabel2.setBounds(5, 35, 150, 25);
        jPanel.add(jLabel2);
        this.nomLFl.setBounds(160, 35, 100, 25);
        jPanel.add(this.nomLFl);
        JLabel jLabel3 = new JLabel("Null hypothesis:");
        jLabel3.setBounds(5, 65, 150, 25);
        jPanel.add(jLabel3);
        this.alphaFl.setBounds(160, 65, 100, 25);
        jPanel.add(this.alphaFl);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(null);
        jPanel2.setBounds(5, 120, 525, 300);
        jPanel2.setBackground(Color.LIGHT_GRAY);
        this.add(jPanel2);
        this.statusLb = new JLabel("Press \"RUN\" to start processing");
        this.statusLb.setBounds(15, 135, 500, 30);
        this.statusLb.setFont(new Font(null, 0, 20));
        jPanel2.add(this.statusLb);
        this.processBt = new JButton("RUN");
        this.processBt.setBounds(15, 255, 485, 30);
        this.processBt.addActionListener(this);
        jPanel2.add(this.processBt);
        this.nextBt = new JButton("Results");
        this.nextBt.setBounds(410, 520, 120, 25);
        this.nextBt.addActionListener(this);
        this.nextBt.setEnabled(false);
        this.add(this.nextBt);
        this.backBt = new JButton("Back");
        this.backBt.setBounds(285, 520, 120, 25);
        this.backBt.addActionListener(this);
        this.add(this.backBt);
    }

    private void setRunning(boolean bl) {
        this.mciFl.setEnabled(this.running);
        this.nomLFl.setEnabled(this.running);
        this.alphaFl.setEnabled(this.running);
        this.nextBt.setEnabled(this.running);
        this.backBt.setEnabled(this.running);
        if (!this.running) {
            this.processBt.setText("STOP");
            int n = Integer.parseInt(this.mciFl.getText());
            int n2 = Integer.parseInt(this.nomLFl.getText());
            double d = Double.parseDouble(this.alphaFl.getText());
            this.mainWindow.setParameters(n, n2, d);
            this.mainWindow.guiEvent(new GuiEvent(this, 3));
            this.hasResults = false;
        } else if (this.running && bl) {
            this.processBt.setText("RUN");
            this.mainWindow.guiEvent(new GuiEvent(this, 4));
            this.hasResults = false;
        } else if (this.running && !bl) {
            this.processBt.setText("RUN");
            this.hasResults = true;
        }
        this.nextBt.setEnabled(this.hasResults);
        this.running = !this.running;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.nextBt) {
            this.mainWindow.guiEvent(new GuiEvent(this, 1));
        } else if (actionEvent.getSource() == this.backBt) {
            this.mainWindow.guiEvent(new GuiEvent(this, 0));
        } else if (actionEvent.getSource() == this.processBt) {
            this.setRunning(this.running);
        }
    }

    @Override
    public void reactOnStaccatoEvent(StaccatoListener.StaccatoEvent staccatoEvent) {
        int n = staccatoEvent.getEvent();
        if (n == 101) {
            this.statusLb.setText("Done 100% of processing -> FINISHED");
            this.mainWindow.setTitle("Staccato - FINISHED");
            this.setRunning(false);
        } else if (n > 0) {
            this.statusLb.setText("Done " + staccatoEvent.getEvent() + "% of processing");
            if (n > this.lastEventId) {
                this.mainWindow.setTitle("Staccato - " + staccatoEvent.getEvent() + "%");
            }
        } else if (n == -1) {
            this.mainWindow.setTitle("Staccato - INTERRUPTED");
            this.statusLb.setText("Press \"RUN\" to start processing");
        }
        this.lastEventId = n;
    }
}

