/*
 * Decompiled with CFR 0.152.
 */
package staccato.view;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import staccato.view.GuiEvent;
import staccato.view.MainWindow;

public class ResultPanel
extends JPanel
implements ActionListener {
    private JButton exportBt;
    private JButton restartBt;
    private JButton backBt;
    private JTextArea results;
    private JFileChooser fc;
    private MainWindow mainWindow;

    public ResultPanel(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.fc = new JFileChooser();
        this.add(this.fc);
        this.initResultPanelGui();
    }

    public void setResultString(String string) {
        this.results.setText(string);
    }

    private void initResultPanelGui() {
        this.setLayout(null);
        this.setBounds(5, 5, 750, 550);
        this.results = new JTextArea();
        this.results.setEditable(false);
        this.results.setFont(new Font(null, 1, 20));
        JScrollPane jScrollPane = new JScrollPane(this.results, 22, 30);
        jScrollPane.setBounds(15, 15, 510, 485);
        this.add(jScrollPane);
        this.exportBt = new JButton("Export Result");
        this.exportBt.setBounds(5, 520, 275, 25);
        this.exportBt.addActionListener(this);
        this.add(this.exportBt);
        this.restartBt = new JButton("Restart");
        this.restartBt.setBounds(410, 520, 120, 25);
        this.restartBt.addActionListener(this);
        this.add(this.restartBt);
        this.backBt = new JButton("Back");
        this.backBt.setBounds(285, 520, 120, 25);
        this.backBt.addActionListener(this);
        this.add(this.backBt);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        if (actionEvent.getSource() == this.restartBt) {
            this.mainWindow.guiEvent(new GuiEvent(this, 2));
        } else if (actionEvent.getSource() == this.backBt) {
            this.mainWindow.guiEvent(new GuiEvent(this, 0));
        } else if (actionEvent.getSource() == this.exportBt && (n = this.fc.showSaveDialog(this)) == 0) {
            File file = this.fc.getSelectedFile();
            this.mainWindow.saveResult(file);
        }
    }
}

