/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.helpers;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.mpi.lexan.analyzers.helpers.settings.AnalyzerSet;
import nl.mpi.lexan.analyzers.helpers.settings.SettingsException;
import nl.mpi.lexan.analyzers.helpers.settings.SettingsIO;

public class ConfigurationHandler {
    public static final Logger LOG = Logger.getLogger("ConfigurationHandler");
    protected AnalyzerSet currentSettings;
    protected File dataDirectory;
    protected String analyzerName;
    protected String curSettingsKey = null;

    public ConfigurationHandler(File dataDirectory, String analyzerName, String settingsKey) {
        this.dataDirectory = dataDirectory;
        this.analyzerName = analyzerName;
        this.curSettingsKey = settingsKey;
    }

    public AnalyzerSet getCurrentSettings() {
        return this.currentSettings;
    }

    public void setCurrentSettings(AnalyzerSet settings) {
        this.currentSettings = settings;
    }

    public static AnalyzerSet loadSettingsFor(File dataDirectory, String analyzerName, String settingsKey) throws SettingsException {
        try {
            AnalyzerSet as = SettingsIO.getInstance().loadSettings(dataDirectory, analyzerName, settingsKey);
            return as;
        }
        catch (SettingsException se) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning(analyzerName + ": " + se.getMessage());
            }
            throw se;
        }
        catch (Throwable thr) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning(analyzerName + ": " + thr.getMessage());
            }
            throw new SettingsException(thr);
        }
    }

    public static void saveSettingsFor(File dataDirectory, String analyzerName, String settingsKey, AnalyzerSet settings) throws SettingsException {
        try {
            settings.setKey(settingsKey);
            SettingsIO.getInstance().saveSettings(dataDirectory, analyzerName, settings);
        }
        catch (SettingsException se) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning(analyzerName + ": " + se.getMessage());
            }
            throw se;
        }
        catch (Throwable thr) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning(analyzerName + ": " + thr.getMessage());
            }
            throw new SettingsException(thr);
        }
    }

    public void loadCurrentSettings() throws SettingsException {
        if (this.dataDirectory == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Cannot load settings: the directory (location) is null");
            }
            throw new SettingsException("Cannot load settings: the location is null");
        }
        if (this.analyzerName == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Cannot load settings: the analyzer name is null");
            }
            throw new SettingsException("Cannot load settings: the analyzer name is null");
        }
        this.currentSettings = SettingsIO.getInstance().loadSettings(this.dataDirectory, this.analyzerName, this.curSettingsKey);
    }

    public void saveCurrentSettings() throws SettingsException {
        if (this.currentSettings != null) {
            if (this.dataDirectory == null || this.analyzerName == null) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Cannot save settings: the location and/or analyzer name are unknown");
                }
                throw new SettingsException("Cannot save settings: the location and/or analyzer name are unknown");
            }
        } else {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning(this.analyzerName + ": no settings to save");
            }
            throw new SettingsException("There are no settings to save (null)");
        }
        ConfigurationHandler.saveSettingsFor(this.dataDirectory, this.analyzerName, this.curSettingsKey, this.currentSettings);
    }

    public void removeSettings(String settingsKey) throws SettingsException {
        if (settingsKey != null && settingsKey != this.analyzerName) {
            SettingsIO.getInstance().removeSettings(this.dataDirectory, this.analyzerName, settingsKey);
        }
    }

    public String getString(String prefKey) {
        return null;
    }

    public int getInt(String prefKey) {
        return 0;
    }

    public boolean getBoolean(String prefKey) {
        return false;
    }

    public void setString(String prefKey, String prefValue) {
    }

    public void setInt(String prefKey, int prefValue) {
    }

    public void setBoolean(String prefKey, boolean prefValue) {
    }
}

