/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.helpers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import nl.mpi.lexan.analyzers.helpers.Position;
import nl.mpi.lexan.analyzers.helpers.PositionLexicon;

public class SourceTargetConfiguration {
    private Position source;
    private List<Position> sourcesList = null;
    private List<Position> targetList;
    private String documentId;
    private Map<String, String> fieldMap;
    private Map<String, Position> positionMap;

    public SourceTargetConfiguration(Position source, Position target) {
        if (source == null) {
            throw new NullPointerException("The source Position is null");
        }
        this.source = source;
        this.initSourceList(source);
        this.initTargetList(target);
        this.initFieldMap();
    }

    public SourceTargetConfiguration(Position source, Position ... targets) {
        if (source == null) {
            throw new NullPointerException("The source Position is null");
        }
        this.source = source;
        this.initSourceList(source);
        this.initTargetList(targets);
        this.initFieldMap();
    }

    public SourceTargetConfiguration(Position source, List<Position> targets) {
        if (source == null) {
            throw new NullPointerException("The source Position is null");
        }
        this.source = source;
        this.initSourceList(source);
        this.initTargetList(targets);
        this.initFieldMap();
    }

    public SourceTargetConfiguration(SourceTargetConfiguration origConfig) {
        if (origConfig == null) {
            throw new NullPointerException("The configuration to copy is null");
        }
        this.source = origConfig.getSource();
        this.initSourceList(this.source);
        this.setSourcesList(origConfig.getSourcesList());
        this.initTargetList(origConfig.getTargetList());
        this.initFieldMap();
        Map<String, String> origFieldMap = origConfig.getFieldMap();
        if (origFieldMap != null) {
            for (String key : origFieldMap.keySet()) {
                this.putFieldForKey(key, origFieldMap.get(key));
            }
        }
        this.positionMap.putAll(origConfig.getPositionMap());
    }

    public Position getSource() {
        return this.source;
    }

    public void setSource(Position source) {
        this.source = source;
        if (this.sourcesList == null) {
            this.sourcesList = new ArrayList<Position>();
        }
        if (!this.sourcesList.isEmpty()) {
            this.sourcesList.set(0, source);
        } else {
            this.sourcesList.add(source);
        }
    }

    public List<Position> getTargetList() {
        return this.targetList;
    }

    public void setTargetList(List<Position> targetList) {
        if (targetList != null) {
            this.targetList.clear();
            this.targetList.addAll(targetList);
        }
    }

    public void addTarget(Position target) {
        if (!this.targetList.contains(target)) {
            this.targetList.add(target);
        }
    }

    public void putFieldForKey(String key, String value) {
        if (this.fieldMap == null) {
            this.fieldMap = new HashMap<String, String>();
        }
        this.fieldMap.put(key, value);
    }

    public String getFieldForKey(String key) {
        if (this.fieldMap != null) {
            return this.fieldMap.get(key);
        }
        return null;
    }

    public void putPositionForKey(String key, Position position) {
        if (this.positionMap == null) {
            this.positionMap = new HashMap<String, Position>();
        }
        this.positionMap.put(key, position);
    }

    public Position getPositionForKey(String key) {
        if (this.positionMap != null) {
            return this.positionMap.get(key);
        }
        return null;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public void setDocumentId(String documentId) {
        this.documentId = documentId;
    }

    public List<Position> getSourcesList() {
        return this.sourcesList;
    }

    public void setSourcesList(List<Position> sourcesList) {
        if (sourcesList != null) {
            if (this.sourcesList == null) {
                this.sourcesList = new ArrayList<Position>(sourcesList.size());
            } else {
                this.sourcesList.clear();
            }
            this.sourcesList.addAll(sourcesList);
            if (this.sourcesList.size() > 0) {
                this.source = this.sourcesList.get(0);
            }
        }
    }

    Map<String, String> getFieldMap() {
        return this.fieldMap;
    }

    Map<String, Position> getPositionMap() {
        return this.positionMap;
    }

    public void addSource(Position sourceToAdd) {
        if (this.sourcesList == null) {
            this.sourcesList = new ArrayList<Position>(4);
        }
        if (!this.sourcesList.contains(sourceToAdd)) {
            this.sourcesList.add(sourceToAdd);
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SourceTargetConfiguration:[source=");
        b.append(String.valueOf(this.source));
        for (int i = 0; i < this.targetList.size(); ++i) {
            Position p = this.targetList.get(i);
            b.append(String.format(", target %d=%s", i, String.valueOf(p)));
            if (!(p instanceof PositionLexicon)) continue;
            b.append("(");
            b.append(((PositionLexicon)p).getEntryField());
            b.append(")");
        }
        b.append("]");
        return b.toString();
    }

    private void initSourceList(Position source) {
        this.sourcesList = new ArrayList<Position>();
        this.sourcesList.add(source);
    }

    private void initTargetList(Position ... targets) {
        if (targets != null) {
            this.targetList = new ArrayList<Position>(targets.length);
            for (Position p : targets) {
                this.targetList.add(p);
            }
        } else {
            this.targetList = new ArrayList<Position>(2);
        }
    }

    private void initTargetList(List<Position> targets) {
        if (targets != null) {
            this.targetList = new ArrayList<Position>(targets.size());
            this.targetList.addAll(targets);
        } else {
            this.targetList = new ArrayList<Position>(2);
        }
    }

    private void initFieldMap() {
        PositionLexicon pl;
        this.positionMap = new HashMap<String, Position>();
        for (Position p : this.sourcesList) {
            if (!(p instanceof PositionLexicon)) continue;
            pl = (PositionLexicon)p;
            this.positionMap.put(pl.getEntryField(), pl);
        }
        for (Position p : this.targetList) {
            if (!(p instanceof PositionLexicon)) continue;
            pl = (PositionLexicon)p;
            this.positionMap.put(pl.getEntryField(), pl);
        }
    }
}

