/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.helpers;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import nl.mpi.lexan.analyzers.helpers.Position;
import nl.mpi.lexan.analyzers.lexicon.LexEntry;

public class Suggestion {
    private String content;
    private Position position;
    private List<Suggestion> children;
    private LexEntry lexEntry;
    private int hashCodeOfSuggestedText;

    public Suggestion(String content, Position position) {
        this.content = content;
        this.position = position;
        this.children = new LinkedList<Suggestion>();
    }

    public Suggestion(List<Suggestion> children) {
        this.children = children;
    }

    public String getContent() {
        return this.content;
    }

    public Position getPosition() {
        return this.position;
    }

    public List<Suggestion> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void addChild(Suggestion child) {
        this.hashCodeOfSuggestedText = 0;
        this.children.add(child);
    }

    public LexEntry getLexEntry() {
        return this.lexEntry;
    }

    public void setLexEntry(LexEntry lexEntry) {
        this.lexEntry = lexEntry;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Suggestion:['");
        if (this.content != null) {
            sb.append(this.content);
        }
        sb.append("', ");
        if (this.position != null) {
            sb.append(this.position.toString());
        }
        if (!this.children.isEmpty()) {
            sb.append("', Children:");
            sb.append(this.children.toString());
        }
        sb.append(']');
        return sb.toString();
    }

    public int hashCodeOfSuggestedText() {
        if (this.hashCodeOfSuggestedText == 0) {
            int result = this.content.hashCode();
            for (Suggestion child : this.children) {
                long m = (long)result * 37L;
                result = (int)(m & 0xFFFFFFFFFFFFFFFFL) + child.hashCodeOfSuggestedText() + (int)(m >>> 32);
            }
            this.hashCodeOfSuggestedText = result;
        }
        return this.hashCodeOfSuggestedText;
    }
}

