/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.helpers;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import nl.mpi.lexan.analyzers.helpers.Position;
import nl.mpi.lexan.analyzers.helpers.Suggestion;

public class SuggestionSet {
    private List<Suggestion> suggestions = new LinkedList<Suggestion>();
    private Position source;
    private String label;
    private int hashCodeOfSuggestedText;

    public SuggestionSet(Position source) {
        this.source = source;
    }

    public List<Suggestion> getSuggestions() {
        return Collections.unmodifiableList(this.suggestions);
    }

    public void add(Suggestion suggestion) {
        this.suggestions.add(suggestion);
        this.hashCodeOfSuggestedText = 0;
    }

    public void addAll(Collection<Suggestion> suggestions) {
        this.suggestions.addAll(suggestions);
        this.hashCodeOfSuggestedText = 0;
    }

    public Position getSource() {
        return this.source;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SuggestionSet:[source=");
        b.append(String.valueOf(this.source));
        b.append(", label=");
        b.append(String.valueOf(this.label));
        b.append(", suggestions=");
        b.append(String.valueOf(this.suggestions));
        b.append("]");
        return b.toString();
    }

    public int hashCodeOfSuggestedText() {
        if (this.hashCodeOfSuggestedText == 0) {
            int result = 1;
            for (Suggestion obj : this.suggestions) {
                result = 31 * result + (obj == null ? 0 : obj.hashCodeOfSuggestedText());
            }
            this.hashCodeOfSuggestedText = result;
        }
        return this.hashCodeOfSuggestedText;
    }
}

