/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.helpers.parameters;

import java.util.LinkedList;
import java.util.List;

public abstract class Parameter {
    private String description;
    private Object value;
    private boolean enabled = true;
    private List<Parameter> observers = new LinkedList<Parameter>();
    private List<Parameter> observed = new LinkedList<Parameter>();
    private boolean hasChanged = false;

    public boolean mandatory() {
        return true;
    }

    public boolean enabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.setChanged(true);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
        this.setChanged(true);
    }

    public void setValue(Object value) {
        this.value = value;
        this.setChanged(true);
    }

    public Object getValue() {
        return this.value;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    protected void setChanged(boolean changed) {
        this.hasChanged = changed;
        if (this.hasChanged) {
            this.notifyObservers();
        }
    }

    public void observedBy(Parameter p) {
        this.observers.add(p);
    }

    public void observe(Parameter p) {
        this.observed.add(p);
        p.observedBy(this);
    }

    public void notifyObservers() {
        if (this.hasChanged) {
            for (Parameter p : this.observers) {
                p.update(this);
            }
        }
        this.hasChanged = false;
    }

    public abstract void update(Parameter var1);
}

