/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.helpers.settings;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import nl.mpi.lexan.analyzers.helpers.settings.AnalyzerSet;
import nl.mpi.lexan.analyzers.helpers.settings.AnalyzerSettings;
import nl.mpi.lexan.analyzers.helpers.settings.SettingsException;

public class SettingsIO {
    public static final Logger LOG = Logger.getLogger("LEXAN");
    private static SettingsIO settingsIO;
    public final String FILE_SUFFIX = "-Settings.xml";

    private SettingsIO() {
    }

    public static SettingsIO getInstance() {
        if (settingsIO == null) {
            settingsIO = new SettingsIO();
        }
        return settingsIO;
    }

    public AnalyzerSet createEmptySettings(String analyzerName) {
        AnalyzerSet as = new AnalyzerSet();
        as.setKey(analyzerName);
        return as;
    }

    public synchronized AnalyzerSet loadSettings(File baseDirectory, String analyzerClassName, String configName) throws SettingsException {
        File settingsFile;
        AnalyzerSettings anSettings;
        if (baseDirectory == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("The base directory is null, cannot load settings");
            }
            throw new SettingsException("The base directory is null");
        }
        if (analyzerClassName == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("The analyzer class name is null, cannot load settings");
            }
            throw new SettingsException("The name of the file could not be resolved: class name is null");
        }
        if (configName == null) {
            configName = analyzerClassName;
        }
        if ((anSettings = this.loadSettings(settingsFile = new File(baseDirectory, analyzerClassName + "-Settings.xml"))) != null) {
            AnalyzerSet requestSet = null;
            for (AnalyzerSet as : anSettings.getAnalyzerSetList()) {
                if (!configName.equals(as.getKey())) continue;
                requestSet = as;
                break;
            }
            if (requestSet == null && configName != analyzerClassName) {
                for (AnalyzerSet as : anSettings.getAnalyzerSetList()) {
                    if (!analyzerClassName.equals(as.getKey())) continue;
                    requestSet = as;
                    break;
                }
            }
            return requestSet;
        }
        if (LOG.isLoggable(Level.INFO)) {
            LOG.log(Level.INFO, "There are no settings (yet) for this analyzer: " + configName);
        }
        return null;
    }

    private AnalyzerSettings loadSettings(File settingsFile) throws SettingsException {
        try {
            FileReader reader = new FileReader(settingsFile, Charset.forName("UTF-8"));
            BufferedReader source = new BufferedReader(reader);
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{AnalyzerSettings.class});
            Unmarshaller unmarshaller = jc.createUnmarshaller();
            AnalyzerSettings anSettings = (AnalyzerSettings)unmarshaller.unmarshal((Reader)source);
            if (anSettings == null && LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "No settings found for this analyzer in this file: " + settingsFile.getPath());
            }
            return anSettings;
        }
        catch (FileNotFoundException fnfe) {
            if (LOG.isLoggable(Level.INFO)) {
                LOG.log(Level.INFO, "There is no settings file (yet) for this analyzer " + settingsFile.getPath());
            }
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Error while loading settings for for file: %s" + settingsFile.getName());
            }
            throw new SettingsException(ioe);
        }
        catch (JAXBException je) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning(String.format("Error while loading settings for %s: %s", settingsFile.getName(), je.getMessage()));
            }
            throw new SettingsException(je);
        }
        return null;
    }

    public synchronized void saveSettings(File baseDirectory, String analyzerClassName, AnalyzerSet analyzerSettings) throws SettingsException {
        if (baseDirectory == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("The base directory is null, cannot save the settings");
            }
            throw new SettingsException("The base directory is null, cannot save");
        }
        if (analyzerClassName == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("The analyzer class name is null, cannot save the settings");
            }
            throw new SettingsException("The name of the file could not be constructed: the class name is null");
        }
        if (analyzerSettings == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("The analyzer settings object is null, cannot save");
            }
            throw new SettingsException("The settings object is null");
        }
        if (analyzerSettings.getKey() == null) {
            analyzerSettings.setKey(analyzerClassName);
        }
        File settingsFile = new File(baseDirectory, analyzerClassName + "-Settings.xml");
        AnalyzerSettings anSettings = null;
        try {
            anSettings = this.loadSettings(settingsFile);
        }
        catch (SettingsException settingsException) {
            // empty catch block
        }
        boolean shouldSave = false;
        if (anSettings == null) {
            anSettings = new AnalyzerSettings();
        }
        for (AnalyzerSet as : anSettings.getAnalyzerSetList()) {
            if (!analyzerSettings.getKey().equals(as.getKey())) continue;
            try {
                int index = anSettings.getAnalyzerSetList().indexOf(as);
                anSettings.getAnalyzerSetList().set(index, analyzerSettings);
                shouldSave = true;
            }
            catch (Throwable t) {
                if (LOG.isLoggable(Level.WARNING)) {
                    LOG.warning("Error while replacing settings for the analyzer, settings not stored");
                }
                return;
            }
        }
        if (!anSettings.getAnalyzerSetList().contains(analyzerSettings)) {
            anSettings.getAnalyzerSetList().add(analyzerSettings);
            shouldSave = true;
        }
        if (shouldSave) {
            this.saveSettings(settingsFile, anSettings, analyzerSettings.getKey());
        }
    }

    public synchronized void removeSettings(File baseDirectory, String analyzerClassName, String configName) throws SettingsException {
        if (baseDirectory == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("The base directory is null, cannot remove settings");
            }
            throw new SettingsException("The base directory is null, cannot remove settings");
        }
        if (analyzerClassName == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("The analyzer class name is null, cannot remove settings");
            }
            throw new SettingsException("The name of the file could not be constructed: the class name is null");
        }
        if (configName == null || configName.equals(analyzerClassName)) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("The analyzer settings name is null, cannot remove global settings");
            }
            throw new SettingsException("The settings name is null, cannot remove global settings");
        }
        File settingsFile = new File(baseDirectory, analyzerClassName + "-Settings.xml");
        AnalyzerSettings anSettings = null;
        try {
            anSettings = this.loadSettings(settingsFile);
        }
        catch (SettingsException settingsException) {
            // empty catch block
        }
        if (anSettings == null) {
            return;
        }
        AnalyzerSet removeSet = null;
        for (AnalyzerSet as : anSettings.getAnalyzerSetList()) {
            if (!configName.equals(as.getKey())) continue;
            removeSet = as;
            break;
        }
        if (removeSet != null) {
            anSettings.getAnalyzerSetList().remove(removeSet);
            this.saveSettings(settingsFile, anSettings, analyzerClassName);
        }
    }

    private void saveSettings(File settingsFile, AnalyzerSettings anSettings, String name) throws SettingsException {
        try {
            FileWriter w = new FileWriter(settingsFile, Charset.forName("UTF-8"));
            BufferedWriter bw = new BufferedWriter(w);
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{AnalyzerSettings.class});
            Marshaller marshaller = jc.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)anSettings, (Writer)bw);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Saved settings for " + name);
            }
        }
        catch (IOException ioe) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Error while saving settings to file: " + settingsFile);
            }
            throw new SettingsException(ioe);
        }
        catch (JAXBException jaxbe) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Error while marshalling settings to xml: " + jaxbe.getMessage());
            }
            throw new SettingsException(jaxbe);
        }
        catch (Throwable t) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Error while saving settings to file: " + t.getMessage());
            }
            throw new SettingsException(t);
        }
    }
}

