/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.helpers.statistics;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import nl.mpi.lexan.analyzers.TextAnalyzerContext;
import nl.mpi.lexan.analyzers.helpers.Position;
import nl.mpi.lexan.analyzers.helpers.Suggestion;
import nl.mpi.lexan.analyzers.helpers.SuggestionSet;
import org.xml.sax.InputSource;

public class SuggestionMemory {
    public static final Logger LOG = Logger.getLogger(SuggestionMemory.class.getName());
    public static final int REMOVED = -1;
    private Map<String, int[]> suggestionMemory;
    private TextAnalyzerContext analyzerContext;

    public SuggestionMemory(TextAnalyzerContext analyzerContext, File file) {
        this.analyzerContext = analyzerContext;
        this.suggestionMemory = SuggestionMemory.getStatistics(file);
    }

    public void updateStatistics(SuggestionSet selection) {
        Position source;
        List<Suggestion> texts;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("updateStatistics: %s", String.valueOf(selection)));
        }
        if (!(texts = this.analyzerContext.readAnnotation(source = selection.getSource())).isEmpty()) {
            String text = texts.get(0).getContent();
            if (this.suggestionMemory == null) {
                this.suggestionMemory = new HashMap<String, int[]>();
            }
            int hash = selection.hashCodeOfSuggestedText();
            if (!this.suggestionMemory.containsKey(text)) {
                int[] values = new int[]{hash, 1};
                this.suggestionMemory.put(text, values);
            } else {
                int i;
                int[] values = this.suggestionMemory.get(text);
                for (i = 0; i < values.length; i += 2) {
                    if (values[i] != hash) continue;
                    int n = i + 1;
                    values[n] = values[n] + 1;
                    break;
                }
                if (i >= values.length) {
                    int[] newvalues = new int[values.length + 2];
                    int j = 0;
                    int k = 0;
                    while (j < values.length) {
                        if (values[j + 1] == -1 && j == k) {
                            newvalues[k] = hash;
                            newvalues[k + 1] = 1;
                            k += 2;
                        }
                        newvalues[k] = values[j];
                        newvalues[k + 1] = values[j + 1];
                        j += 2;
                        k += 2;
                    }
                    this.suggestionMemory.put(text, newvalues);
                } else {
                    i -= 2;
                    while (i >= 0 && values[i + 1] <= values[i + 3]) {
                        int tmp = values[i];
                        values[i] = values[i + 2];
                        values[i + 2] = tmp;
                        tmp = values[i + 1];
                        values[i + 1] = values[i + 3];
                        values[i + 3] = tmp;
                        i -= 2;
                    }
                }
            }
        }
    }

    public void removePermanently(SuggestionSet selection) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("removePermanently: %s", String.valueOf(selection)));
        }
        if (selection == null) {
            return;
        }
        Position source = selection.getSource();
        List<Suggestion> texts = this.analyzerContext.readAnnotation(source);
        if (!texts.isEmpty()) {
            String text = texts.get(0).getContent();
            if (this.suggestionMemory == null) {
                this.suggestionMemory = new HashMap<String, int[]>();
            }
            int hash = selection.hashCodeOfSuggestedText();
            if (!this.suggestionMemory.containsKey(text)) {
                int[] values = new int[]{hash, -1};
                this.suggestionMemory.put(text, values);
            } else {
                int i;
                int[] values = this.suggestionMemory.get(text);
                for (i = 0; i < values.length; i += 2) {
                    if (values[i] != hash) continue;
                    values[i + 1] = -1;
                    break;
                }
                if (i >= values.length) {
                    int[] newvalues = new int[values.length + 2];
                    System.arraycopy(values, 0, newvalues, 0, values.length);
                    newvalues[values.length] = hash;
                    newvalues[values.length + 1] = -1;
                    this.suggestionMemory.put(text, newvalues);
                } else {
                    int[] newvalues = new int[values.length];
                    int k = 0;
                    for (int j = 0; j < values.length; j += 2) {
                        if (j == i) continue;
                        newvalues[k] = values[j];
                        newvalues[k + 1] = values[j + 1];
                        k += 2;
                    }
                    newvalues[k] = values[i];
                    newvalues[k + 1] = values[i + 1];
                    this.suggestionMemory.put(text, newvalues);
                }
            }
        }
    }

    public void rearrangeByFrequency(Suggestion source, List<SuggestionSet> suggestionSets) {
        if (this.suggestionMemory != null && this.suggestionMemory.containsKey(source.getContent())) {
            int[] chosen = this.suggestionMemory.get(source.getContent());
            this.rearrangeByFrequency(suggestionSets, chosen);
        }
    }

    public void rearrangeByFrequency(List<SuggestionSet> suggestionSets, int[] chosen) {
        if (suggestionSets instanceof LinkedList) {
            LinkedList ss = (LinkedList)suggestionSets;
            ListIterator<SuggestionSet> it = ss.listIterator();
            int stepped = 0;
            block0: for (int i = 0; i < chosen.length; i += 2) {
                int hash = chosen[i];
                while (stepped > 0) {
                    it.previous();
                    --stepped;
                }
                while (it.hasNext()) {
                    SuggestionSet current = (SuggestionSet)it.next();
                    ++stepped;
                    if (current.hashCodeOfSuggestedText() != hash) continue;
                    Object label = current.getLabel();
                    label = (String)label + " Chosen " + chosen[i + 1] + " times before";
                    current.setLabel((String)label);
                    if (stepped > 1) {
                        if (LOG.isLoggable(Level.FINE)) {
                            LOG.fine(String.format("Moving sugg from pos %d to %d: %s", i / 2 + stepped - 1, i / 2, current.toString()));
                        }
                        it.remove();
                        --stepped;
                        while (stepped > 0) {
                            it.previous();
                            --stepped;
                        }
                        it.add(current);
                        continue block0;
                    }
                    stepped = 0;
                    continue block0;
                }
            }
        } else {
            int to = 0;
            block4: for (int i = 0; i < chosen.length; i += 2) {
                int hash = chosen[i];
                for (int from = to; from < suggestionSets.size(); ++from) {
                    SuggestionSet current = suggestionSets.get(from);
                    if (current.hashCodeOfSuggestedText() != hash) continue;
                    Object label = current.getLabel();
                    label = (String)label + " Chosen " + chosen[i + 1] + " times before";
                    current.setLabel((String)label);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine(String.format("Moving sugg from pos %d to %d: %s", from, to, current.toString()));
                    }
                    if (to != from) {
                        suggestionSets.remove(from);
                        suggestionSets.add(to, current);
                    }
                    ++to;
                    continue block4;
                }
            }
        }
    }

    public void removeMarkedSuggestions(Suggestion source, List<SuggestionSet> suggestionSets) {
        if (this.suggestionMemory != null && this.suggestionMemory.containsKey(source.getContent())) {
            int[] chosen = this.suggestionMemory.get(source.getContent());
            block0: for (int s = suggestionSets.size() - 1; s >= 0; --s) {
                SuggestionSet current = suggestionSets.get(s);
                int curHash = current.hashCodeOfSuggestedText();
                for (int i = 0; i < chosen.length; i += 2) {
                    if (chosen[i] != curHash) continue;
                    if (chosen[i + 1] != -1) continue block0;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine(String.format("Removing suggestion set from list: %s", current.toString()));
                    }
                    suggestionSets.remove(s);
                    continue block0;
                }
            }
        }
    }

    public boolean isPermanentlyRemoved(Suggestion source, SuggestionSet suggestionSet) {
        if (this.suggestionMemory != null && this.suggestionMemory.containsKey(source.getContent())) {
            int[] chosen = this.suggestionMemory.get(source.getContent());
            int curHash = suggestionSet.hashCodeOfSuggestedText();
            for (int i = 0; i < chosen.length; i += 2) {
                if (chosen[i] != curHash) continue;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(String.format("Suggestion set %s pemanently removed: %s", suggestionSet.toString(), String.valueOf(chosen[i + 1] == -1)));
                }
                return chosen[i + 1] == -1;
            }
        }
        return false;
    }

    public void save(File statisticsFile) {
        if (this.suggestionMemory != null) {
            SuggestionMemory.saveStatistics(statisticsFile, this.suggestionMemory);
        }
    }

    public static Map<String, int[]> getStatistics(File file) {
        if (file != null && file.exists()) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Statistics.class});
                Unmarshaller u = jaxbContext.createUnmarshaller();
                URL url = file.toURI().toURL();
                InputSource is = new InputSource(url.toExternalForm());
                Statistics sm = (Statistics)u.unmarshal(is);
                return sm.getChosenSuggestions();
            }
            catch (JAXBException je) {
                je.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.warning(String.format("The file to read statistics from does not exist: %s", file));
        }
        return new HashMap<String, int[]>();
    }

    public static void saveStatistics(File file, Map<String, int[]> suggestionMemory) {
        if (file != null) {
            try {
                Statistics s = new Statistics();
                s.setChosenSuggestions(suggestionMemory);
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Statistics.class});
                Marshaller m = jaxbContext.createMarshaller();
                m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                URL url = file.toURI().toURL();
                StreamResult res = new StreamResult(url.toExternalForm());
                m.marshal((Object)s, (Result)res);
            }
            catch (JAXBException je) {
                je.printStackTrace();
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        } else if (LOG.isLoggable(Level.WARNING)) {
            LOG.warning(String.format("The file to write statistics to does not exist: %s", file));
        }
    }

    public static void main(String[] args) {
        File baseDir = new File(".");
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Statistics.class});
            class MySchemaOutputResolver
            extends SchemaOutputResolver {
                final /* synthetic */ File val$baseDir;

                MySchemaOutputResolver(File file) {
                    this.val$baseDir = file;
                }

                public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
                    File storeIn = new File(this.val$baseDir, suggestedFileName);
                    System.out.printf("Storing schema in %s\n", storeIn.getAbsolutePath());
                    return new StreamResult(storeIn);
                }
            }
            jaxbContext.generateSchema((SchemaOutputResolver)new MySchemaOutputResolver(baseDir));
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class Statistics {
        private Map<String, int[]> chosensuggestions;

        private Statistics() {
        }

        public Map<String, int[]> getChosenSuggestions() {
            return this.chosensuggestions;
        }

        public void setChosenSuggestions(Map<String, int[]> chosensuggestions) {
            this.chosensuggestions = chosensuggestions;
        }
    }
}

