/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.lexicon;

import java.util.ArrayList;
import java.util.List;
import nl.mpi.lexan.analyzers.lexicon.LexContainer;
import nl.mpi.lexan.analyzers.lexicon.LexItem;

public class LexCont
implements LexItem,
LexContainer {
    private String type;
    private List<LexItem> lexItems;

    public LexCont(String type) {
        this.type = type;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public List<? extends LexItem> getLexItems() {
        return this.lexItems;
    }

    protected List<LexItem> getItemList() {
        if (this.lexItems == null) {
            this.lexItems = new ArrayList<LexItem>();
        }
        return this.lexItems;
    }

    public boolean addLexItem(LexItem item) {
        if (item != null) {
            return this.getItemList().add(item);
        }
        return false;
    }

    public boolean removeLexItem(LexItem item) {
        if (this.lexItems != null) {
            return this.lexItems.remove(item);
        }
        return false;
    }

    @Override
    public LexItem getLexItem(String queryString) {
        if (this.lexItems != null) {
            for (LexItem li : this.lexItems) {
                LexItem chli;
                if (li.getType().equals(queryString)) {
                    return li;
                }
                if (!(li instanceof LexCont) || (chli = this.getChildItem((LexCont)li, queryString)) == null) continue;
                return chli;
            }
        }
        return null;
    }

    private LexItem getChildItem(LexCont parentCont, String queryString) {
        for (LexItem lexItem : parentCont.getLexItems()) {
            if (lexItem.getType().equals(queryString)) {
                return lexItem;
            }
            if (!(lexItem instanceof LexCont)) continue;
            return this.getChildItem((LexCont)lexItem, queryString);
        }
        return null;
    }

    @Override
    public List<? extends LexItem> getLexItems(String queryString) {
        if (this.lexItems != null) {
            ArrayList<LexItem> subList = new ArrayList<LexItem>();
            for (LexItem li : this.lexItems) {
                if (li.getType().equals(queryString)) {
                    subList.add(li);
                    continue;
                }
                if (!(li instanceof LexCont)) continue;
                this.addChildItems(subList, (LexCont)li, queryString);
            }
            return subList;
        }
        return null;
    }

    private void addChildItems(List<LexItem> itemList, LexCont parentCont, String queryString) {
        for (LexItem lexItem : parentCont.getLexItems()) {
            if (lexItem.getType().equals(queryString)) {
                itemList.add(lexItem);
                continue;
            }
            if (!(lexItem instanceof LexCont)) continue;
            this.addChildItems(itemList, (LexCont)lexItem, queryString);
        }
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LexCont[");
        b.append(String.valueOf(this.getType()));
        b.append("=");
        b.append(String.valueOf(this.getLexItems()));
        b.append("]");
        return b.toString();
    }
}

