/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.glossanalyzer;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.mpi.lexan.analyzers.LexiconTextAnalyzer;
import nl.mpi.lexan.analyzers.TextAnalyzerContext;
import nl.mpi.lexan.analyzers.TextAnalyzerLexiconContext;
import nl.mpi.lexan.analyzers.glossanalyzer.GlossAnalyzerInformation;
import nl.mpi.lexan.analyzers.glossanalyzer.GlossConfigurationPanel;
import nl.mpi.lexan.analyzers.glossanalyzer.GlossConfigurator;
import nl.mpi.lexan.analyzers.glossanalyzer.Glosser;
import nl.mpi.lexan.analyzers.helpers.ConfigurationChangeListener;
import nl.mpi.lexan.analyzers.helpers.ConfigurationChanger;
import nl.mpi.lexan.analyzers.helpers.Information;
import nl.mpi.lexan.analyzers.helpers.LexanSuggestionSelectionListener;
import nl.mpi.lexan.analyzers.helpers.Position;
import nl.mpi.lexan.analyzers.helpers.PositionLexicon;
import nl.mpi.lexan.analyzers.helpers.SourceTargetConfiguration;
import nl.mpi.lexan.analyzers.helpers.Suggestion;
import nl.mpi.lexan.analyzers.helpers.SuggestionSet;
import nl.mpi.lexan.analyzers.helpers.settings.SettingsException;
import nl.mpi.lexan.analyzers.helpers.statistics.SuggestionMemory;
import nl.mpi.lexan.analyzers.lexicon.LexanLexicon;
import nl.mpi.lexan.analyzers.lexicon.LexiconChangeEvent;
import nl.mpi.lexan.analyzers.lexicon.LexiconChangeListener;

public class GlossAnalyzer
implements LexiconTextAnalyzer,
ConfigurationChangeListener,
LexanSuggestionSelectionListener,
LexiconChangeListener {
    public static final Logger LOG = Logger.getLogger(GlossAnalyzer.class.getName());
    private final String analyzerShortName = GlossAnalyzer.class.getSimpleName();
    private static final String statisticsFileName = "GlossAnalyzerStats.xml";
    private Information info = new GlossAnalyzerInformation();
    private List<SourceTargetConfiguration> configs = null;
    private boolean paused = true;
    private List<Position> pauseList = null;
    private Glosser glosser = null;
    private TextAnalyzerContext analyzerContext;
    private TextAnalyzerLexiconContext lexiconContext;
    private File cacheFolder;
    private LexanLexicon lexanLexicon;
    private SuggestionMemory suggestionMemory;
    private File statisticsFile;
    private GlossConfigurator configHandler;
    private String loadedSettings = null;

    public void setAnalyzerContext(TextAnalyzerContext lc) {
        if (this.analyzerContext != null) {
            this.analyzerContext.removeSuggestionSelectionListener((LexanSuggestionSelectionListener)this);
        }
        this.analyzerContext = lc;
    }

    public void setLexiconContext(TextAnalyzerLexiconContext lexiconContext) {
        this.lexiconContext = lexiconContext;
    }

    public Information getInformation() {
        return this.info;
    }

    public Component getConfigurationComponent(String configKey) {
        if (this.cacheFolder != null) {
            GlossConfigurationPanel gcp = new GlossConfigurationPanel(this.cacheFolder, this.lexiconContext, this.analyzerShortName, configKey, this.loadedSettings);
            gcp.addConfigurationChangeListener(this);
            return gcp;
        }
        return null;
    }

    public boolean isConfigurable() {
        return true;
    }

    public boolean load(List<SourceTargetConfiguration> configurations) {
        if (configurations == null || configurations.size() == 0) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Cannot initialize, no source-target configurations specified.");
            }
            return false;
        }
        if (this.configs != null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("The analyzer is already initialized, cannot initialize again.");
            }
            return false;
        }
        this.configs = new ArrayList<SourceTargetConfiguration>(configurations.size());
        if (!this.partLoad(configurations)) {
            this.unload();
            return false;
        }
        this.suggestionMemory = new SuggestionMemory(this.analyzerContext, this.statisticsFile);
        this.glosser = new Glosser();
        this.glosser.setLexicon(this.lexanLexicon);
        if (this.configHandler != null) {
            this.applySettings(this.configHandler);
        }
        this.paused = false;
        this.pauseList = new LinkedList<Position>();
        this.analyzerContext.addSuggestionSelectionListener((LexanSuggestionSelectionListener)this);
        return true;
    }

    public boolean partLoad(List<SourceTargetConfiguration> configurations) {
        if (configurations == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Cannot partially load, no configurations specified.");
            }
            return false;
        }
        if (this.configs == null) {
            return this.load(configurations);
        }
        int curSize = this.configs.size();
        for (SourceTargetConfiguration conf : configurations) {
            if (!this.checkConfigurationRequirements(conf)) continue;
            if (this.indexOfConfiguration(conf) == -1) {
                PositionLexicon pl;
                SourceTargetConfiguration c = new SourceTargetConfiguration(conf);
                if (conf.getTargetList().get(0) instanceof PositionLexicon && (pl = (PositionLexicon)c.getTargetList().get(0)).getEntryField() != null) {
                    c.putFieldForKey("sense/gloss", pl.getEntryField());
                    c.putPositionForKey("sense/gloss", (Position)pl);
                    if (pl.getLanguageAttr() != null) {
                        c.putFieldForKey("lang", pl.getLanguageAttr());
                    }
                }
                this.configs.add(c);
                continue;
            }
            if (!LOG.isLoggable(Level.WARNING)) continue;
            LOG.warning(String.format("This configuration already exists (Source: %s - Target: %s)", conf.getSource().getTierId(), ((Position)conf.getTargetList().get(0)).getTierId()));
        }
        LexanLexicon curLexicon = this.lexanLexicon;
        for (SourceTargetConfiguration stc : this.configs) {
            LexanLexicon nextLexicon;
            PositionLexicon lexPos = null;
            if (stc.getPositionForKey("sense/gloss") instanceof PositionLexicon) {
                lexPos = (PositionLexicon)stc.getPositionForKey("sense/gloss");
            } else if (stc.getSource() instanceof PositionLexicon) {
                lexPos = (PositionLexicon)stc.getSource();
            }
            if (lexPos == null || (nextLexicon = this.lexiconContext.getLexicon(lexPos.getLexiconId())) == null || nextLexicon == curLexicon) continue;
            if (curLexicon != null) {
                curLexicon.removeLexiconChangeListener((LexiconChangeListener)this);
            }
            this.lexanLexicon = nextLexicon;
            this.lexanLexicon.addLexiconChangeListener((LexiconChangeListener)this);
            break;
        }
        return curSize < this.configs.size();
    }

    public boolean unload() {
        if (this.statisticsFile != null && this.suggestionMemory != null) {
            this.suggestionMemory.save(this.statisticsFile);
        }
        if (this.analyzerContext != null) {
            this.analyzerContext.removeSuggestionSelectionListener((LexanSuggestionSelectionListener)this);
        }
        if (this.lexanLexicon != null) {
            this.lexanLexicon.removeLexiconChangeListener((LexiconChangeListener)this);
        }
        this.configs = null;
        this.configHandler = null;
        this.glosser = null;
        this.paused = true;
        this.pauseList = null;
        this.analyzerContext = null;
        this.lexiconContext = null;
        this.statisticsFile = null;
        this.suggestionMemory = null;
        this.lexanLexicon = null;
        return true;
    }

    public int partUnload(List<SourceTargetConfiguration> configurations) {
        if (configurations == null || configurations.isEmpty()) {
            return this.configs.size();
        }
        for (SourceTargetConfiguration conf : configurations) {
            int index = this.indexOfConfiguration(conf);
            if (index <= -1) continue;
            for (Position l : this.pauseList) {
                if (!l.getTierId().equals(conf.getSource().getTierId())) continue;
                this.pauseList.remove(l);
            }
            SourceTargetConfiguration sourceTargetConfiguration = this.configs.remove(index);
        }
        return this.configs.size();
    }

    private boolean checkConfigurationRequirements(SourceTargetConfiguration stc) {
        if (stc == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("The tested configuration is null, ignoring.");
            }
            return false;
        }
        if (stc.getSource() == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("No source tier specified in a configuration, removing.");
            }
            return false;
        }
        if (stc.getTargetList().isEmpty()) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("No target tier specified in a configuration, removing.");
            }
            return false;
        }
        if (stc.getSource().equals(stc.getTargetList().get(0))) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("The source tier and target tier are the same, removing.");
            }
            return false;
        }
        return true;
    }

    private int indexOfConfiguration(SourceTargetConfiguration config) {
        if (config != null) {
            for (int i = 0; i < this.configs.size(); ++i) {
                SourceTargetConfiguration conf = this.configs.get(i);
                if (!conf.getSource().equals((Object)config.getSource()) || config.getTargetList().isEmpty() || conf.getTargetList().isEmpty() || !((Position)config.getTargetList().get(0)).equals(conf.getTargetList().get(0))) continue;
                return i;
            }
        }
        return -1;
    }

    public void analyze(Position pos) {
        if (this.paused) {
            this.pauseList.add(pos);
            return;
        }
        for (SourceTargetConfiguration stc : this.configs) {
            if (!stc.getSource().getTierId().equals(pos.getTierId())) continue;
            this.analyze(pos, stc);
        }
    }

    private void analyze(Position source, SourceTargetConfiguration stc) {
        List input = this.analyzerContext.readAnnotation(source);
        String targetGlossTierId = "";
        if (stc.getPositionForKey("sense/gloss") != null) {
            targetGlossTierId = stc.getPositionForKey("sense/gloss").getTierId();
        } else if (!stc.getTargetList().isEmpty()) {
            targetGlossTierId = ((Position)stc.getTargetList().get(0)).getTierId();
        }
        this.glosser.setConfig(stc);
        for (Suggestion s : input) {
            List<Glosser.GlossEntry> glosses = this.glosser.parse(s.getContent());
            LinkedList<SuggestionSet> suggestionSets = new LinkedList<SuggestionSet>();
            Position glossPosition = new Position(targetGlossTierId, s.getPosition());
            int parsenr = 0;
            for (Glosser.GlossEntry gs : glosses) {
                SuggestionSet ss = new SuggestionSet(source);
                Suggestion toaddGloss = new Suggestion(gs.getGloss(), glossPosition);
                toaddGloss.setLexEntry(gs.getLexEntry());
                ss.add(toaddGloss);
                if (this.suggestionMemory != null && this.suggestionMemory.isPermanentlyRemoved(s, ss)) continue;
                ss.setLabel("Gloss #" + parsenr++);
                suggestionSets.add(ss);
            }
            if (this.suggestionMemory != null) {
                this.suggestionMemory.rearrangeByFrequency(s, suggestionSets);
            }
            this.analyzerContext.newAnnotations(suggestionSets);
        }
    }

    public void pause() {
        this.paused = true;
    }

    public void unPause() {
        this.paused = false;
        for (Position p : this.pauseList) {
            this.analyze(p);
        }
    }

    public void saveState() {
        if (LOG.isLoggable(Level.INFO)) {
            LOG.info("GlossAnalyzer: Save state called");
        }
    }

    public void loadState() {
    }

    private void applySettings(GlossConfigurator configHandler) {
        if (configHandler != null) {
            if (this.glosser != null) {
                this.glosser.setMissingMarker(configHandler.getMissingMarker());
                this.glosser.setIncludeVariants(configHandler.getConsiderVariants());
                this.glosser.setMatchLanguage(configHandler.getMatchLanguage());
                this.glosser.setIncludeCitation(configHandler.getIncludeCitation());
            }
            this.configHandler = configHandler;
        }
    }

    public void configurationChanged(ConfigurationChanger source) {
        if (source instanceof GlossConfigurationPanel) {
            GlossConfigurationPanel configComponent = (GlossConfigurationPanel)source;
            this.applySettings(configComponent.getConfigHandler());
            this.loadedSettings = configComponent.getCurrentSettingsKey();
        }
    }

    public void setCacheFolder(File f) {
        if (!(f != null && f.isDirectory() && f.canRead() && f.canWrite())) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning(String.format("The provided cache folder cannot be used: %s", f));
            }
            return;
        }
        this.cacheFolder = f;
        this.statisticsFile = new File(this.cacheFolder, statisticsFileName);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("The cache file for the Gloss analyzer is set to: %s", this.statisticsFile));
        }
    }

    public void setLexiconLinkForPosition(Position pos, LexanLexicon lexicon, String entryField) {
    }

    public void removeLexiconLinkForPosition(Position pos, String entryField) {
    }

    public void suggestionSelected(int nr, SuggestionSet selection) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("GlossAnalyzer.suggestionSelected: %d %s", nr, String.valueOf(selection)));
        }
        if (this.suggestionMemory == null) {
            this.suggestionMemory = new SuggestionMemory(this.analyzerContext, this.statisticsFile);
        }
        this.suggestionMemory.updateStatistics(selection);
    }

    public void suggestionIgnored(SuggestionSet ignored) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("GlossAnalyzer.suggestionIgnored: %s", String.valueOf(ignored)));
        }
    }

    public void suggestionClosed(SuggestionSet ignored) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("GlossAnalyzer.suggestionClosed: %s", String.valueOf(ignored)));
        }
        if (this.suggestionMemory != null) {
            this.suggestionMemory.save(this.statisticsFile);
        }
    }

    public void suggestionRemoved(SuggestionSet removed) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("GlossAnalyzer.suggestionRemoved: %s", String.valueOf(removed)));
        }
        if (this.suggestionMemory == null) {
            this.suggestionMemory = new SuggestionMemory(this.analyzerContext, this.statisticsFile);
        }
        this.suggestionMemory.removePermanently(removed);
    }

    public void lexiconChanged(LexiconChangeEvent event) {
        if (event.getSource() == this.lexanLexicon) {
            LOG.fine("GlossAnalyzer.lexiconChanged");
        }
    }

    public void loadSettingsFor(String configId) {
        block3: {
            GlossConfigurator configHandler = new GlossConfigurator(this.cacheFolder, this.analyzerShortName, configId);
            this.loadedSettings = configId;
            try {
                configHandler.loadCurrentSettings();
                if (configHandler.getCurrentSettings() != null) {
                    this.loadedSettings = configHandler.getCurrentSettings().getKey();
                }
                this.applySettings(configHandler);
            }
            catch (SettingsException se) {
                if (!LOG.isLoggable(Level.WARNING)) break block3;
                LOG.warning("Unable to load settings: " + se.getMessage());
            }
        }
    }
}

