/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.glossanalyzer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import nl.mpi.lexan.analyzers.TextAnalyzerLexiconContext;
import nl.mpi.lexan.analyzers.glossanalyzer.GlossConfigurator;
import nl.mpi.lexan.analyzers.helpers.ConfigurationChangeListener;
import nl.mpi.lexan.analyzers.helpers.ConfigurationChanger;
import nl.mpi.lexan.analyzers.helpers.settings.SettingsException;

class GlossConfigurationPanel
extends JPanel
implements ActionListener,
ConfigurationChanger {
    public static final Logger LOG = Logger.getLogger("GlossAnalyzer");
    protected String analyzerName = "GlossAnalyzer";
    protected String curSettingsKey = null;
    private String settingsToRemove = null;
    private List<ConfigurationChangeListener> listeners;
    private File dataDirectory;
    private GlossConfigurator configHandler;
    private JButton saveButton;
    private JTextField missingMarkerTF;
    private TextAnalyzerLexiconContext lexiconContext;
    private JCheckBox variantCB;
    private JCheckBox matchLanguageAttrCB;
    private JCheckBox includeCitationCB;

    public GlossConfigurationPanel(File dataDirectory, TextAnalyzerLexiconContext lexiconContext, String analyzerSimpleName, String configKey, String settingsToRemove) {
        this.lexiconContext = lexiconContext;
        this.dataDirectory = dataDirectory;
        this.analyzerName = analyzerSimpleName;
        this.curSettingsKey = configKey;
        this.settingsToRemove = settingsToRemove;
        this.initSettings();
        this.initComponents();
        this.loadSettings();
    }

    public GlossConfigurator getConfigHandler() {
        return this.configHandler;
    }

    public String getCurrentSettingsKey() {
        return this.curSettingsKey;
    }

    private void initSettings() {
        this.configHandler = new GlossConfigurator(this.dataDirectory, this.analyzerName, this.curSettingsKey);
    }

    private void loadSettings() {
        block2: {
            try {
                this.configHandler.loadCurrentSettings();
                this.variantCB.setSelected(this.configHandler.getConsiderVariants());
                this.missingMarkerTF.setText(this.configHandler.getMissingMarker());
                this.matchLanguageAttrCB.setSelected(this.configHandler.getMatchLanguage());
                this.includeCitationCB.setSelected(this.configHandler.getIncludeCitation());
            }
            catch (SettingsException se) {
                if (!LOG.isLoggable(Level.WARNING)) break block2;
                LOG.warning(this.analyzerName + ": " + se.getMessage());
            }
        }
    }

    public void loadSettingsForKey(String settingsKey) {
        if (this.curSettingsKey == null && settingsKey == null) {
            return;
        }
        if (this.curSettingsKey != null && this.curSettingsKey.equals(settingsKey)) {
            return;
        }
        this.curSettingsKey = settingsKey;
        this.configHandler = new GlossConfigurator(this.dataDirectory, this.analyzerName, this.curSettingsKey);
        this.loadSettings();
    }

    public void saveSettings() {
        block3: {
            try {
                this.configHandler.saveCurrentSettings();
                if (this.settingsToRemove != null && !this.settingsToRemove.equals(this.curSettingsKey)) {
                    this.configHandler.removeSettings(this.settingsToRemove);
                }
            }
            catch (SettingsException se) {
                if (!LOG.isLoggable(Level.WARNING)) break block3;
                LOG.warning(this.analyzerName + ": " + se.getMessage());
            }
        }
    }

    private void initComponents() {
        this.saveButton = new JButton("Apply");
        this.saveButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.variantCB = new JCheckBox("Also match against variant fields in the look up process");
        this.variantCB.setToolTipText("For glossing, consider variants as source as well (beside the default lexical-unit)");
        this.matchLanguageAttrCB = new JCheckBox("Match gloss language against tier content language");
        this.matchLanguageAttrCB.setToolTipText("Only include a gloss if its language attribute matches the content language of the target tier");
        this.includeCitationCB = new JCheckBox("Also match against the citation field in the look up process");
        this.includeCitationCB.setToolTipText("For glossing, consider the citation field as source as well");
        JLabel missingL = new JLabel("String for missing values");
        this.missingMarkerTF = new JTextField("", 5);
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        this.add((Component)this.variantCB, gbc);
        gbc.gridy = 1;
        this.add((Component)this.matchLanguageAttrCB, gbc);
        gbc.gridy = 2;
        this.add((Component)this.includeCitationCB, gbc);
        gbc.gridy = 3;
        gbc.gridwidth = 1;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        this.add((Component)missingL, gbc);
        gbc.gridx = 1;
        this.add((Component)this.missingMarkerTF, gbc);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setBorder(new TitledBorder(""));
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.anchor = 10;
        gbc2.insets = new Insets(2, 2, 2, 2);
        buttonPanel.add((Component)this.saveButton, gbc2);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 0.1;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(8, 6, 4, 6);
        this.add((Component)buttonPanel, gbc);
        JPanel filler = new JPanel(null);
        filler.setPreferredSize(new Dimension(4, 4));
        ++gbc.gridy;
        gbc.fill = 3;
        gbc.weighty = 1.0;
        this.add((Component)filler, gbc);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.saveButton) {
            this.configHandler.setConsiderVariants(this.variantCB.isSelected());
            this.configHandler.setMissingMarker(this.missingMarkerTF.getText().trim());
            this.configHandler.setMatchLanguage(this.matchLanguageAttrCB.isSelected());
            this.configHandler.setIncludeCitation(this.includeCitationCB.isSelected());
            this.notifyListeners();
            this.saveSettings();
        }
    }

    public void addConfigurationChangeListener(ConfigurationChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ConfigurationChangeListener>(2);
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeConfigurationChangeListener(ConfigurationChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void removeAllListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
    }

    public void notifyListeners() {
        if (this.listeners != null) {
            for (ConfigurationChangeListener l : this.listeners) {
                l.configurationChanged((ConfigurationChanger)this);
            }
        }
    }
}

