/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.glossanalyzer;

import java.io.File;
import nl.mpi.lexan.analyzers.helpers.ConfigurationHandler;
import nl.mpi.lexan.analyzers.helpers.settings.AnalyzerSet;
import nl.mpi.lexan.analyzers.helpers.settings.Setting;
import nl.mpi.lexan.analyzers.helpers.settings.SettingsException;
import nl.mpi.lexan.analyzers.helpers.settings.SettingsIO;

public class GlossConfigurator
extends ConfigurationHandler {
    private final String MISSING_MARKER_PREF = "MissingMarker";
    private final String INCL_VARIANTS_PREF = "ConsiderVariants";
    private final String MATCH_LANGUAGE_PREF = "MatchLanguageAttributes";
    private final String INCL_CITATION_PREF = "ConsiderCitation";
    private boolean considerVariants;
    private String missingMarker;
    private boolean matchLanguageAttr;
    private boolean includeCitation;

    public GlossConfigurator(File dataDirectory, String analyzerName, String settingsKey) {
        super(dataDirectory, analyzerName, settingsKey);
        this.initSettings();
    }

    private void initSettings() {
        this.missingMarker = "***";
        this.considerVariants = true;
        this.matchLanguageAttr = true;
        this.includeCitation = false;
    }

    protected void applySettingsToFields() {
        if (this.currentSettings != null) {
            String inclCitValue;
            String matchLangValue;
            String inclVarValue;
            String missingMarkerValue = this.currentSettings.getSettingValue("MissingMarker");
            if (missingMarkerValue != null) {
                this.missingMarker = missingMarkerValue;
            }
            if ((inclVarValue = this.currentSettings.getSettingValue("ConsiderVariants")) != null) {
                this.considerVariants = Boolean.parseBoolean(inclVarValue);
            }
            if ((matchLangValue = this.currentSettings.getSettingValue("MatchLanguageAttributes")) != null) {
                this.matchLanguageAttr = Boolean.parseBoolean(matchLangValue);
            }
            if ((inclCitValue = this.currentSettings.getSettingValue("ConsiderCitation")) != null) {
                this.includeCitation = Boolean.parseBoolean(inclCitValue);
            }
        }
    }

    protected void applyFieldsToSettings() {
        AnalyzerSet anSet = SettingsIO.getInstance().createEmptySettings(this.analyzerName);
        anSet.getSettingList().add(new Setting("ConsiderVariants", String.valueOf(this.considerVariants)));
        anSet.getSettingList().add(new Setting("MissingMarker", this.missingMarker));
        anSet.getSettingList().add(new Setting("MatchLanguageAttributes", String.valueOf(this.matchLanguageAttr)));
        anSet.getSettingList().add(new Setting("ConsiderCitation", String.valueOf(this.includeCitation)));
        anSet.setKey(this.curSettingsKey);
        this.currentSettings = anSet;
    }

    public void loadCurrentSettings() throws SettingsException {
        super.loadCurrentSettings();
        this.applySettingsToFields();
    }

    public AnalyzerSet getCurrentSettings() {
        this.applyFieldsToSettings();
        return super.getCurrentSettings();
    }

    public void setCurrentSettings(AnalyzerSet settings) {
        if (settings != null) {
            super.setCurrentSettings(settings);
            this.applySettingsToFields();
        }
    }

    public void saveCurrentSettings() throws SettingsException {
        this.applyFieldsToSettings();
        super.saveCurrentSettings();
    }

    public boolean getConsiderVariants() {
        return this.considerVariants;
    }

    public String getMissingMarker() {
        return this.missingMarker;
    }

    public void setConsiderVariants(boolean considerVariants) {
        this.considerVariants = considerVariants;
    }

    public void setMissingMarker(String missingMarker) {
        this.missingMarker = missingMarker;
    }

    public void setMatchLanguage(boolean matchLanguageAttr) {
        this.matchLanguageAttr = matchLanguageAttr;
    }

    public boolean getMatchLanguage() {
        return this.matchLanguageAttr;
    }

    public boolean getIncludeCitation() {
        return this.includeCitation;
    }

    public void setIncludeCitation(boolean includeCitation) {
        this.includeCitation = includeCitation;
    }
}

