/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.glossanalyzer;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import nl.mpi.lexan.analyzers.helpers.SourceTargetConfiguration;
import nl.mpi.lexan.analyzers.lexicon.LexAtom;
import nl.mpi.lexan.analyzers.lexicon.LexEntry;
import nl.mpi.lexan.analyzers.lexicon.LexItem;
import nl.mpi.lexan.analyzers.lexicon.LexanLexicon;

class Glosser {
    public static final String LEXICAL_UNIT = "lexical-unit";
    public static final String GLOSS_KEY = "sense/gloss";
    public static final String VARIANT = "variant";
    public static final String MISSING = "***";
    public static final String LANG_KEY = "lang";
    public static final String CITATION = "citation";
    protected String missingMarker = "***";
    private LexanLexicon lexanLexicon;
    private List<String> interestingFields;
    private boolean includeVariants = true;
    private boolean includeCitation = false;
    private boolean matchLanguageAttr = true;

    public String getMissingMarker() {
        return this.missingMarker;
    }

    public void setMissingMarker(String missingMarker) {
        if (missingMarker != null) {
            this.missingMarker = missingMarker;
        }
    }

    public void setIncludeVariants(boolean includeVariants) {
        this.includeVariants = includeVariants;
    }

    public boolean getIncludeVariants() {
        return this.includeVariants;
    }

    public void setMatchLanguage(boolean matchLanguageAttr) {
        this.matchLanguageAttr = matchLanguageAttr;
    }

    public boolean getMatchLanguage() {
        return this.matchLanguageAttr;
    }

    public boolean getIncludeCitation() {
        return this.includeCitation;
    }

    public void setIncludeCitation(boolean includeCitation) {
        this.includeCitation = includeCitation;
    }

    public void clearRules() {
        this.lexanLexicon = null;
    }

    public boolean setLexicon(LexanLexicon lexanLexicon) {
        this.clearRules();
        if (lexanLexicon == null) {
            return false;
        }
        this.lexanLexicon = lexanLexicon;
        return true;
    }

    public void setConfig(SourceTargetConfiguration stc) {
        this.interestingFields = new ArrayList<String>(1);
        if (this.matchLanguageAttr) {
            String lng = stc.getFieldForKey(LANG_KEY);
            String glossField = stc.getFieldForKey(GLOSS_KEY);
            if (lng != null && !lng.isEmpty()) {
                glossField = glossField.concat("/").concat(lng);
            }
            this.interestingFields.add(glossField);
        } else {
            this.interestingFields.add(stc.getFieldForKey(GLOSS_KEY));
        }
    }

    public List<GlossEntry> parse(String word) {
        LexAtom citQueryAtom;
        List citEntries;
        ArrayList<LexEntry> mergedEntries;
        LexAtom queryAtom2;
        List entriesVar;
        LinkedList<GlossEntry> parses = new LinkedList<GlossEntry>();
        LexAtom queryAtom = new LexAtom(LEXICAL_UNIT, word);
        ArrayList<LexEntry> entries = this.lexanLexicon.getEntries(queryAtom, this.interestingFields);
        if (this.includeVariants && (entriesVar = this.lexanLexicon.getEntries(queryAtom2 = new LexAtom(VARIANT, word), this.interestingFields)).size() > 0) {
            if (entries.size() > 0) {
                mergedEntries = new ArrayList<LexEntry>();
                for (LexEntry entry : entries) {
                    mergedEntries.add(entry);
                    for (LexEntry varEntry : entriesVar) {
                        if (varEntry.getId() == null || !varEntry.getId().equals(entry.getId())) continue;
                        mergedEntries.add(varEntry);
                        entriesVar.remove(varEntry);
                    }
                }
                mergedEntries.addAll(entriesVar);
                entries = mergedEntries;
            } else {
                entries = entriesVar;
            }
        }
        if (this.includeCitation && (citEntries = this.lexanLexicon.getEntries(citQueryAtom = new LexAtom(CITATION, word), this.interestingFields)).size() > 0) {
            if (entries.size() > 0) {
                mergedEntries = new ArrayList();
                for (LexEntry entry : entries) {
                    mergedEntries.add(entry);
                    for (LexEntry citEntry : citEntries) {
                        if (citEntry.getId() == null || !citEntry.getId().equals(entry.getId())) continue;
                        mergedEntries.add(citEntry);
                        citEntries.remove(citEntry);
                    }
                }
                mergedEntries.addAll(citEntries);
                entries = mergedEntries;
            } else {
                entries = citEntries;
            }
        }
        for (LexEntry entry : entries) {
            List glossItems = entry.getLexItems(this.interestingFields.get(0));
            for (LexItem glossItem : glossItems) {
                if (!(glossItem instanceof LexAtom)) continue;
                LexAtom glossAtom = (LexAtom)glossItem;
                String gloss = glossAtom.getLexValue();
                GlossEntry gs = new GlossEntry(entry, gloss);
                parses.add(gs);
            }
        }
        if (parses.isEmpty()) {
            GlossEntry gs = new GlossEntry(null, this.missingMarker);
            parses.add(gs);
        }
        return parses;
    }

    public static class GlossEntry {
        private String gloss;
        private LexEntry lexEntry;

        public GlossEntry(LexEntry entry, String gloss) {
            this.gloss = gloss;
            this.lexEntry = entry;
        }

        public String getGloss() {
            return this.gloss;
        }

        public LexEntry getLexEntry() {
            return this.lexEntry;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("GlossEntry[");
            sb.append("gloss=");
            sb.append(String.valueOf(this.gloss));
            sb.append("]");
            return sb.toString();
        }
    }
}

