/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.lexiconanalyzer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import nl.mpi.lexan.analyzers.helpers.SourceTargetConfiguration;
import nl.mpi.lexan.analyzers.lexicon.LexAtom;
import nl.mpi.lexan.analyzers.lexicon.LexCont;
import nl.mpi.lexan.analyzers.lexicon.LexEntry;
import nl.mpi.lexan.analyzers.lexicon.LexItem;
import nl.mpi.lexan.analyzers.lexiconanalyzer.ParseFragGl;
import nl.mpi.lexan.analyzers.parsebase.AbstractParser;
import nl.mpi.lexan.analyzers.parsebase.InputState;

class LAInputState
extends InputState {
    public String missingGloss = "*";
    public boolean matchLanguage = false;
    public boolean includeGramCat = false;

    public LAInputState(String word) {
        super(word);
    }

    private LAInputState(LAInputState is) {
        super(is);
        this.missingGloss = is.missingGloss;
        this.matchLanguage = is.matchLanguage;
        this.includeGramCat = is.includeGramCat;
    }

    private String createGlossQuery(SourceTargetConfiguration stcIn) {
        if (!this.matchLanguage) {
            return stcIn.getFieldForKey("gloss");
        }
        String lang = stcIn.getFieldForKey("lang");
        if (lang != null && !lang.isEmpty()) {
            return stcIn.getFieldForKey("gloss") + "/" + lang;
        }
        return stcIn.getFieldForKey("gloss");
    }

    @Override
    public void applyPrefix(List<InputState> out, String trigger, LexEntry entry, SourceTargetConfiguration sourceTargetConfig) {
        List glosses;
        List variants;
        Object lexicalUnit = ((LexAtom)entry.getLexItem("lexical-unit")).getLexValue();
        String replace = "";
        LexItem item = entry.getLexItem(sourceTargetConfig.getFieldForKey("replace"));
        if (item instanceof LexAtom) {
            replace = ((LexAtom)item).getLexValue();
        }
        if (!((String)lexicalUnit).regionMatches(true, 0, trigger, 0, trigger.length()) && (variants = entry.getLexItems("variant")) != null) {
            for (LexItem variant : variants) {
                Object var;
                if (!(variant instanceof LexAtom) || ((String)(var = ((LexAtom)variant).getLexValue())).isEmpty() || !((String)var).regionMatches(true, 0, trigger, 0, trigger.length())) continue;
                lexicalUnit = var;
                break;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("applyPrefix: lexicalUnit/variant='%s' replaceField='%s' replace='%s' surface='%s' trigger='%s'", lexicalUnit, replace, replace, this.surface, trigger));
        }
        boolean glossAdded = false;
        String glossQuery = this.createGlossQuery(sourceTargetConfig);
        List senses = entry.getLexItems("sense");
        if ((this.includeGramCat || senses != null) && senses != null && !senses.isEmpty()) {
            for (Object senseItem : senses) {
                List glosses2;
                if (!(senseItem instanceof LexCont)) continue;
                String gramCat = null;
                LexItem gramCatItem = ((LexCont)senseItem).getLexItem("sense/grammatical-category");
                if (gramCatItem instanceof LexAtom) {
                    gramCat = ((LexAtom)gramCatItem).getLexValue();
                }
                if ((glosses2 = ((LexCont)senseItem).getLexItems(glossQuery)) == null || glosses2.isEmpty()) continue;
                for (LexItem glossItem : glosses2) {
                    String gloss = ((LexAtom)glossItem).getLexValue();
                    LAInputState newState = new LAInputState(this);
                    newState.surface = replace + this.surface.substring(trigger.length());
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine(String.format("applyPrefix: new surface='%s' insert @ %d, gloss='%s'", newState.surface, this.insertionPoint, gloss));
                    }
                    newState.addFrag(new ParseFragGl(entry, (String)lexicalUnit, gloss, gramCat), true);
                    out.add(newState);
                    glossAdded = true;
                }
            }
        }
        if (!glossAdded && (glosses = entry.getLexItems(glossQuery)) != null && !glosses.isEmpty()) {
            for (LexItem glossItem : glosses) {
                String gloss = ((LexAtom)glossItem).getLexValue();
                LAInputState newState = new LAInputState(this);
                newState.surface = replace + this.surface.substring(trigger.length());
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(String.format("applyPrefix: new surface='%s' insert @ %d, gloss='%s'", newState.surface, this.insertionPoint, gloss));
                }
                newState.addFrag(new ParseFragGl(entry, (String)lexicalUnit, gloss), true);
                out.add(newState);
                glossAdded = true;
            }
        }
        if (!glossAdded) {
            String gloss = this.missingGloss;
            LAInputState newState = new LAInputState(this);
            newState.surface = replace + this.surface.substring(trigger.length());
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("applyPrefix-noGloss: new surface='%s' insert @ %d gloss='%s'", newState.surface, this.insertionPoint, gloss));
            }
            newState.addFrag(new ParseFragGl(entry, (String)lexicalUnit, gloss), true);
            out.add(newState);
        }
    }

    @Override
    public void applySuffix(List<InputState> out, String trigger, LexEntry entry, SourceTargetConfiguration sourceTargetConfig) {
        List glosses;
        List variants;
        Object lexicalUnit = ((LexAtom)entry.getLexItem("lexical-unit")).getLexValue();
        String replace = "";
        LexItem item = entry.getLexItem(sourceTargetConfig.getFieldForKey("replace"));
        if (item instanceof LexAtom) {
            replace = ((LexAtom)item).getLexValue();
        }
        int triggerLen = trigger.length();
        if (!((String)lexicalUnit).regionMatches(true, ((String)lexicalUnit).length() - triggerLen, trigger, 0, triggerLen) && (variants = entry.getLexItems("variant")) != null) {
            for (LexItem variant : variants) {
                Object var;
                if (!(variant instanceof LexAtom) || ((String)(var = ((LexAtom)variant).getLexValue())).isEmpty() || !((String)var).regionMatches(true, ((String)var).length() - triggerLen, trigger, 0, triggerLen)) continue;
                lexicalUnit = var;
                break;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("applySuffix: lexicalUnit/variant='%s' replace='%s' surface='%s' trigger='%s'", lexicalUnit, replace, this.surface, trigger));
        }
        boolean glossAdded = false;
        String glossQuery = this.createGlossQuery(sourceTargetConfig);
        List senses = entry.getLexItems("sense");
        if ((this.includeGramCat || senses != null) && senses != null && !senses.isEmpty()) {
            for (Object senseItem : senses) {
                List glosses2;
                if (!(senseItem instanceof LexCont)) continue;
                String gramCat = null;
                LexItem gramCatItem = ((LexCont)senseItem).getLexItem("sense/grammatical-category");
                if (gramCatItem instanceof LexAtom) {
                    gramCat = ((LexAtom)gramCatItem).getLexValue();
                }
                if ((glosses2 = ((LexCont)senseItem).getLexItems(glossQuery)) == null || glosses2.isEmpty()) continue;
                for (LexItem glossItem : glosses2) {
                    String gloss = ((LexAtom)glossItem).getLexValue();
                    LAInputState newState = new LAInputState(this);
                    newState.surface = this.surface.substring(0, this.surface.length() - trigger.length()) + replace;
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine(String.format("applySuffix: new surface='%s' insert @ %d gloss='%s'", newState.surface, this.insertionPoint, gloss));
                    }
                    newState.addFrag(new ParseFragGl(entry, (String)lexicalUnit, gloss, gramCat), false);
                    out.add(newState);
                    glossAdded = true;
                }
            }
        }
        if (!glossAdded && (glosses = entry.getLexItems(glossQuery)) != null && !glosses.isEmpty()) {
            for (LexItem glossItem : glosses) {
                String gloss = ((LexAtom)glossItem).getLexValue();
                LAInputState newState = new LAInputState(this);
                newState.surface = this.surface.substring(0, this.surface.length() - trigger.length()) + replace;
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(String.format("applySuffix: new surface='%s' insert @ %d gloss='%s'", newState.surface, this.insertionPoint, gloss));
                }
                newState.addFrag(new ParseFragGl(entry, (String)lexicalUnit, gloss), false);
                out.add(newState);
                glossAdded = true;
            }
        }
        if (!glossAdded) {
            String gloss = this.missingGloss;
            LAInputState newState = new LAInputState(this);
            newState.surface = this.surface.substring(0, this.surface.length() - trigger.length()) + replace;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("applySuffix-noGloss: new surface='%s' insert @ %d gloss='%s'", newState.surface, this.insertionPoint, gloss));
            }
            newState.addFrag(new ParseFragGl(entry, (String)lexicalUnit, gloss), false);
            out.add(newState);
        }
    }

    @Override
    public void applyStem(List<InputState> out, String trigger, LexEntry entry, SourceTargetConfiguration sourceTargetConfig) {
        List glosses;
        List variants;
        Object lexicalUnit = ((LexAtom)entry.getLexItem("lexical-unit")).getLexValue();
        String replace = "";
        LexItem item = entry.getLexItem(sourceTargetConfig.getFieldForKey("replace"));
        if (item instanceof LexAtom) {
            replace = ((LexAtom)item).getLexValue();
        }
        if (!((String)lexicalUnit).equalsIgnoreCase(trigger) && (variants = entry.getLexItems("variant")) != null) {
            for (LexItem variant : variants) {
                Object var;
                if (!(variant instanceof LexAtom) || ((String)(var = ((LexAtom)variant).getLexValue())).isEmpty() || !((String)var).equalsIgnoreCase(trigger)) continue;
                lexicalUnit = var;
                break;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("applyStem: lexicalUnit/Variant='%s' replace='%s' surface='%s' trigger='%s'", lexicalUnit, replace, this.surface, trigger));
        }
        boolean glossAdded = false;
        String glossQuery = this.createGlossQuery(sourceTargetConfig);
        List senses = entry.getLexItems("sense");
        if ((this.includeGramCat || senses != null) && senses != null && !senses.isEmpty()) {
            for (Object senseItem : senses) {
                List glosses2;
                if (!(senseItem instanceof LexCont)) continue;
                String gramCat = null;
                LexItem gramCatItem = ((LexCont)senseItem).getLexItem("sense/grammatical-category");
                if (gramCatItem instanceof LexAtom) {
                    gramCat = ((LexAtom)gramCatItem).getLexValue();
                }
                if ((glosses2 = ((LexCont)senseItem).getLexItems(glossQuery)) == null || glosses2.isEmpty()) continue;
                for (LexItem glossItem : glosses2) {
                    String gloss = ((LexAtom)glossItem).getLexValue();
                    LAInputState newState = new LAInputState(this);
                    newState.surface = replace + newState.surface.substring(trigger.length());
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine(String.format("applyStem: new surface='%s' insert @ %d, gloss='%s'", newState.surface, this.insertionPoint, gloss));
                    }
                    newState.addFrag(new ParseFragGl(entry, (String)lexicalUnit, gloss, gramCat), true);
                    newState.state = AbstractParser.ParseState.STEM;
                    out.add(newState);
                    glossAdded = true;
                }
            }
        }
        if (!glossAdded && (glosses = entry.getLexItems(glossQuery)) != null && !glosses.isEmpty()) {
            for (LexItem glossItem : glosses) {
                String gloss = ((LexAtom)glossItem).getLexValue();
                LAInputState newState = new LAInputState(this);
                newState.surface = replace + newState.surface.substring(trigger.length());
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(String.format("applyStem: new surface='%s' insert @ %d, gloss='%s'", newState.surface, this.insertionPoint, gloss));
                }
                newState.addFrag(new ParseFragGl(entry, (String)lexicalUnit, gloss), true);
                newState.state = AbstractParser.ParseState.STEM;
                out.add(newState);
                glossAdded = true;
            }
        }
        if (!glossAdded) {
            String gloss = this.missingGloss;
            LAInputState newState = new LAInputState(this);
            newState.surface = replace + newState.surface.substring(trigger.length());
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("applyStem-noGloss: new surface='%s' insert @ %d gloss='%s'", newState.surface, this.insertionPoint, gloss));
            }
            newState.addFrag(new ParseFragGl(entry, (String)lexicalUnit, gloss), true);
            newState.state = AbstractParser.ParseState.STEM;
            out.add(newState);
        }
    }

    @Override
    public void applyStemInfix(List<InputState> out, String trigger, LexEntry stemEntry, LexEntry infEntry, int fromPosition, int infixLength, SourceTargetConfiguration sourceTargetConfig) {
        LAInputState newState;
        Iterator glosses;
        List glosses2;
        String lexicalUnit = ((LexAtom)stemEntry.getLexItem("lexical-unit")).getLexValue();
        String infixValue = ((LexAtom)infEntry.getLexItem("lexical-unit")).getLexValue();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("applyStemInfix: lexicalUnit/Variant='%s' surface='%s' trigger='%s' infix='%s'", lexicalUnit, this.surface, trigger, infixValue));
        }
        boolean glossAdded = false;
        String glossQuery = this.createGlossQuery(sourceTargetConfig);
        ArrayList<String[]> stemGlosses = new ArrayList<String[]>();
        ArrayList<String[]> infGlosses = new ArrayList<String[]>();
        List senses = stemEntry.getLexItems("sense");
        if ((this.includeGramCat || senses != null) && senses != null && !senses.isEmpty()) {
            for (Object senseItem : senses) {
                List glosses3;
                if (!(senseItem instanceof LexCont)) continue;
                String gramCat = null;
                LexItem gramCatItem = ((LexCont)senseItem).getLexItem("sense/grammatical-category");
                if (gramCatItem instanceof LexAtom) {
                    gramCat = ((LexAtom)gramCatItem).getLexValue();
                }
                if ((glosses3 = ((LexCont)senseItem).getLexItems(glossQuery)) == null || glosses3.isEmpty()) continue;
                for (Object glossItem : glosses3) {
                    String gloss = ((LexAtom)glossItem).getLexValue();
                    stemGlosses.add(new String[]{gloss, gramCat});
                    glossAdded = true;
                }
            }
        }
        if (!glossAdded && (glosses2 = stemEntry.getLexItems(glossQuery)) != null && !glosses2.isEmpty()) {
            for (LexItem glossItem : glosses2) {
                String gloss = ((LexAtom)glossItem).getLexValue();
                stemGlosses.add(new String[]{gloss, null});
                glossAdded = true;
            }
        }
        glossAdded = false;
        List infSenses = infEntry.getLexItems("sense");
        if ((this.includeGramCat || infSenses != null) && infSenses != null && !infSenses.isEmpty()) {
            for (Object senseItem : infSenses) {
                List glosses4;
                if (!(senseItem instanceof LexCont)) continue;
                String gramCat = null;
                LexItem gramCatItem = ((LexCont)senseItem).getLexItem("sense/grammatical-category");
                if (gramCatItem instanceof LexAtom) {
                    gramCat = ((LexAtom)gramCatItem).getLexValue();
                }
                if ((glosses4 = ((LexCont)senseItem).getLexItems(glossQuery)) == null || glosses4.isEmpty()) continue;
                for (LexItem glossItem : glosses4) {
                    String gloss = ((LexAtom)glossItem).getLexValue();
                    infGlosses.add(new String[]{gloss, gramCat});
                    glossAdded = true;
                }
            }
        }
        if (!glossAdded && (glosses = infEntry.getLexItems(glossQuery)) != null && !glosses.isEmpty()) {
            Object senseItem;
            senseItem = glosses.iterator();
            while (senseItem.hasNext()) {
                LexItem glossItem = (LexItem)senseItem.next();
                String gloss = ((LexAtom)glossItem).getLexValue();
                infGlosses.add(new String[]{gloss, null});
                glossAdded = true;
            }
        }
        if (!stemGlosses.isEmpty() && !infGlosses.isEmpty()) {
            for (String[] stGl : stemGlosses) {
                for (String[] infGl : infGlosses) {
                    String gloss = stGl[0] + "." + infGl[0];
                    Object cat = null;
                    if (stGl[1] != null) {
                        cat = stGl[1];
                    }
                    if (infGl[1] != null) {
                        cat = cat == null ? infGl[1] : (String)cat + "\\" + infGl[1];
                    }
                    LAInputState newState2 = new LAInputState(this);
                    newState2.surface = "";
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine(String.format("applyStemInfix: new surface='%s' insert @ %d, gloss='%s' cat='%s'", newState2.surface, this.insertionPoint, gloss, cat));
                    }
                    newState2.addFrag(new ParseFragGl(stemEntry, trigger, gloss, (String)cat), false);
                    newState2.state = AbstractParser.ParseState.OK;
                    out.add(newState2);
                }
            }
        } else if (!stemGlosses.isEmpty()) {
            for (String[] stGl : stemGlosses) {
                newState = new LAInputState(this);
                newState.surface = "";
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(String.format("applyStemInfix: new surface='%s' insert @ %d, gloss='%s' cat='%s'", newState.surface, this.insertionPoint, stGl[0], stGl[1]));
                }
                newState.addFrag(new ParseFragGl(stemEntry, trigger, stGl[0], stGl[1]), false);
                newState.state = AbstractParser.ParseState.OK;
                out.add(newState);
            }
        } else if (!infGlosses.isEmpty()) {
            for (String[] infGl : infGlosses) {
                newState = new LAInputState(this);
                newState.surface = "";
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(String.format("applyStemInfix: new surface='%s' insert @ %d, gloss='%s' cat='%s'", newState.surface, this.insertionPoint, infGl[0], infGl[1]));
                }
                newState.addFrag(new ParseFragGl(stemEntry, trigger, infGl[0], infGl[1]), false);
                newState.state = AbstractParser.ParseState.OK;
                out.add(newState);
            }
        } else {
            LAInputState newState3 = new LAInputState(this);
            newState3.surface = "";
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(String.format("applyStemInfix: new surface='%s' insert @ %d, gloss='%s'", newState3.surface, this.insertionPoint, this.missingGloss));
            }
            newState3.addFrag(new ParseFragGl(stemEntry, trigger, this.missingGloss), false);
            newState3.state = AbstractParser.ParseState.OK;
            out.add(newState3);
        }
    }
}

