/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.lexiconanalyzer;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import nl.mpi.lexan.analyzers.helpers.ConfigurationChanger;
import nl.mpi.lexan.analyzers.helpers.Position;
import nl.mpi.lexan.analyzers.helpers.PositionLexicon;
import nl.mpi.lexan.analyzers.helpers.SourceTargetConfiguration;
import nl.mpi.lexan.analyzers.helpers.Suggestion;
import nl.mpi.lexan.analyzers.helpers.SuggestionSet;
import nl.mpi.lexan.analyzers.helpers.settings.SettingsException;
import nl.mpi.lexan.analyzers.lexicon.LexanLexicon;
import nl.mpi.lexan.analyzers.lexicon.LexiconChangeListener;
import nl.mpi.lexan.analyzers.lexiconanalyzer.LexiconAnalyzerInformation;
import nl.mpi.lexan.analyzers.lexiconanalyzer.LexiconConfigurationPanel;
import nl.mpi.lexan.analyzers.lexiconanalyzer.ParseFragGl;
import nl.mpi.lexan.analyzers.lexiconanalyzer.Parser;
import nl.mpi.lexan.analyzers.parsebase.AbstractParseAnalyzer;
import nl.mpi.lexan.analyzers.parsebase.AbstractParser;
import nl.mpi.lexan.analyzers.parsebase.ParseConfigurator;
import nl.mpi.lexan.analyzers.parsebase.ParseFrag;

public class LexiconAnalyzer
extends AbstractParseAnalyzer {
    protected boolean matchLanguageAttr;
    protected boolean sameGramCategory;

    public LexiconAnalyzer() {
        this.analyzerShortName = LexiconAnalyzer.class.getSimpleName();
        this.statisticsFileName = "LexiconAnalyzerStats.xml";
        this.info = new LexiconAnalyzerInformation();
    }

    public Component getConfigurationComponent(String configKey) {
        if (this.cacheFolder != null) {
            LexiconConfigurationPanel lcp = new LexiconConfigurationPanel(this.cacheFolder, this.lexiconContext, this.analyzerShortName, configKey, this.loadedSettings);
            lcp.addConfigurationChangeListener(this);
            return lcp;
        }
        return null;
    }

    public boolean isConfigurable() {
        return true;
    }

    @Override
    protected AbstractParser createParser() {
        return new Parser();
    }

    public boolean partLoad(List<SourceTargetConfiguration> configurations) {
        if (configurations == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Cannot partially load, no configurations specified.");
            }
            return false;
        }
        if (this.configs == null) {
            return this.load(configurations);
        }
        int curSize = this.configs.size();
        for (SourceTargetConfiguration conf : configurations) {
            if (!this.checkConfigurationRequirements(conf)) continue;
            if (this.indexOfConfiguration(conf) == -1) {
                PositionLexicon pl;
                SourceTargetConfiguration c = new SourceTargetConfiguration(conf);
                c.putFieldForKey("replace", this.replaceField);
                if (c.getTargetList().get(0) instanceof PositionLexicon && (pl = (PositionLexicon)c.getTargetList().get(0)).getEntryField() != null) {
                    c.putFieldForKey("parse", pl.getEntryField());
                    c.putPositionForKey("parse", (Position)pl);
                }
                if (c.getTargetList().size() >= 2 && c.getTargetList().get(1) instanceof PositionLexicon && (pl = (PositionLexicon)c.getTargetList().get(1)).getEntryField() != null) {
                    c.putFieldForKey("gloss", pl.getEntryField());
                    c.putPositionForKey("gloss", (Position)pl);
                    if (pl.getLanguageAttr() != null) {
                        c.putFieldForKey("lang", pl.getLanguageAttr());
                    }
                }
                this.configs.add(c);
                continue;
            }
            if (!LOG.isLoggable(Level.WARNING)) continue;
            LOG.warning(String.format("This configuration already exists (Source: %s - Target: %s)", conf.getSource().getTierId(), ((Position)conf.getTargetList().get(0)).getTierId()));
        }
        LexanLexicon curLexicon = this.lexanLexicon;
        for (SourceTargetConfiguration stc : this.configs) {
            LexanLexicon nextLexicon;
            PositionLexicon lexPos = null;
            if (stc.getPositionForKey("parse") instanceof PositionLexicon) {
                lexPos = (PositionLexicon)stc.getPositionForKey("parse");
            } else if (stc.getPositionForKey("gloss") instanceof PositionLexicon) {
                lexPos = (PositionLexicon)stc.getPositionForKey("gloss");
            } else if (stc.getSource() instanceof PositionLexicon) {
                lexPos = (PositionLexicon)stc.getSource();
            }
            if (lexPos == null || (nextLexicon = this.lexiconContext.getLexicon(lexPos.getLexiconId())) == null || nextLexicon == curLexicon) continue;
            if (curLexicon != null) {
                curLexicon.removeLexiconChangeListener((LexiconChangeListener)this);
            }
            this.lexanLexicon = nextLexicon;
            this.lexanLexicon.addLexiconChangeListener((LexiconChangeListener)this);
            this.needSetParserRules = true;
            break;
        }
        this.setInterestingFields();
        return curSize < this.configs.size();
    }

    @Override
    protected boolean checkConfigurationRequirements(SourceTargetConfiguration stc) {
        if (!super.checkConfigurationRequirements(stc)) {
            return false;
        }
        if (stc.getTargetList().size() < 2) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Less than two target tiers specified in a configuration, removing.");
            }
            return false;
        }
        if (stc.getSource().equals(stc.getTargetList().get(0)) || stc.getSource().equals(stc.getTargetList().get(1)) || ((Position)stc.getTargetList().get(0)).equals(stc.getTargetList().get(1))) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("The source tier and target tier are the same, removing.");
            }
            return false;
        }
        return true;
    }

    @Override
    protected int indexOfConfiguration(SourceTargetConfiguration config) {
        if (config != null) {
            for (int i = 0; i < this.configs.size(); ++i) {
                SourceTargetConfiguration conf = (SourceTargetConfiguration)this.configs.get(i);
                if (!conf.getSource().equals((Object)config.getSource()) || config.getTargetList().size() < 2 || !((Position)conf.getTargetList().get(0)).equals(config.getTargetList().get(0)) || !((Position)conf.getTargetList().get(1)).equals(config.getTargetList().get(1))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    protected void setInterestingFields() {
        HashSet<Object> fields = new HashSet<Object>();
        for (SourceTargetConfiguration c : this.configs) {
            String f = c.getFieldForKey("gloss");
            if (f != null && !f.isEmpty()) {
                if (this.matchLanguageAttr) {
                    String lang = c.getFieldForKey("lang");
                    if (lang != null && !lang.isEmpty()) {
                        fields.add(f + "/" + lang);
                    } else {
                        fields.add(f);
                    }
                } else {
                    fields.add(f);
                }
            }
            if ((f = c.getFieldForKey("replace")) == null || f.isEmpty()) continue;
            fields.add(f);
        }
        if (this.considerVariants) {
            fields.add("variant");
        }
        if (this.outputCitationForm) {
            fields.add("citation");
        }
        if (this.sameGramCategory) {
            fields.add("sense/grammatical-category");
        }
        fields.add("lexical-unit");
        this.interestingFields = new ArrayList();
        this.interestingFields.addAll(fields);
    }

    @Override
    protected void analyze(Position source, SourceTargetConfiguration stc) {
        List input = this.analyzerContext.readAnnotation(source);
        String targetSplitTierId = "";
        if (stc.getPositionForKey("parse") != null) {
            targetSplitTierId = stc.getPositionForKey("parse").getTierId();
        } else if (!stc.getTargetList().isEmpty()) {
            targetSplitTierId = ((Position)stc.getTargetList().get(0)).getTierId();
        }
        String targetGlossTierId = "";
        if (stc.getPositionForKey("gloss") != null) {
            targetGlossTierId = stc.getPositionForKey("gloss").getTierId();
        } else if (stc.getTargetList().size() >= 2) {
            targetGlossTierId = ((Position)stc.getTargetList().get(1)).getTierId();
        }
        ((Parser)this.parser).setMatchLanguage(this.matchLanguageAttr);
        ((Parser)this.parser).setIncludeGramCategory(this.sameGramCategory);
        this.parser.setConfig(stc);
        for (Suggestion s : input) {
            List<List<ParseFrag>> parses = this.parser.parse(s.getContent());
            LinkedList<SuggestionSet> suggestionSets = new LinkedList<SuggestionSet>();
            Position splitPosition = new Position(targetSplitTierId, s.getPosition());
            Position glossPosition = new Position(targetGlossTierId, s.getPosition());
            int parsenr = 0;
            for (List<ParseFrag> parsefrags : parses) {
                if (this.sameGramCategory && !this.checkCategoryConsistency(parsefrags)) continue;
                SuggestionSet ss = new SuggestionSet(source);
                for (ParseFrag frag : parsefrags) {
                    Suggestion toaddSplit = new Suggestion(this.getSplitFragment(frag), splitPosition);
                    toaddSplit.setLexEntry(frag.getLexEntry());
                    if (frag instanceof ParseFragGl) {
                        Suggestion toaddGloss = new Suggestion(((ParseFragGl)frag).getGloss(), glossPosition);
                        toaddGloss.setLexEntry(frag.getLexEntry());
                        toaddSplit.addChild(toaddGloss);
                    }
                    ss.add(toaddSplit);
                }
                if (this.suggestionMemory != null && this.suggestionMemory.isPermanentlyRemoved(s, ss)) continue;
                ss.setLabel("Parse #" + parsenr++);
                suggestionSets.add(ss);
            }
            if (this.suggestionMemory != null) {
                this.suggestionMemory.rearrangeByFrequency(s, suggestionSets);
            }
            this.analyzerContext.newAnnotations(suggestionSets);
        }
    }

    private boolean checkCategoryConsistency(List<ParseFrag> parsefrags) {
        String gramCat = null;
        for (ParseFrag frag : parsefrags) {
            ParseFragGl glFrag;
            if (!(frag instanceof ParseFragGl) || (glFrag = (ParseFragGl)frag).getGramCat() == null) continue;
            if (gramCat == null) {
                gramCat = glFrag.getGramCat();
                continue;
            }
            if (gramCat.equals(glFrag.getGramCat())) continue;
            return false;
        }
        return true;
    }

    @Override
    public void configurationChanged(ConfigurationChanger source) {
        if (!(source instanceof LexiconConfigurationPanel)) {
            return;
        }
        super.configurationChanged(source);
    }

    public void loadSettingsFor(String configId) {
        block3: {
            ParseConfigurator configHandler = new ParseConfigurator(this.cacheFolder, this.analyzerShortName, configId);
            this.loadedSettings = configId;
            try {
                configHandler.loadCurrentSettings();
                if (configHandler.getCurrentSettings() != null) {
                    this.loadedSettings = configHandler.getCurrentSettings().getKey();
                }
                this.applySettings(configHandler);
            }
            catch (SettingsException se) {
                if (!LOG.isLoggable(Level.WARNING)) break block3;
                LOG.warning("Unable to load settings: " + se.getMessage());
            }
        }
    }

    @Override
    protected void applySettings(ParseConfigurator configHandler) {
        super.applySettings(configHandler);
        if (configHandler != null) {
            boolean curSameGC = this.sameGramCategory;
            boolean curMatchLang = this.matchLanguageAttr;
            this.sameGramCategory = configHandler.getBoolean("SameGramCategory");
            this.matchLanguageAttr = configHandler.getBoolean("MatchLanguageAttributes");
            if (curSameGC != this.sameGramCategory || curMatchLang != this.matchLanguageAttr) {
                this.setInterestingFields();
            }
        }
    }

    public boolean isSameGramCategory() {
        return this.sameGramCategory;
    }

    public void setSameGramCategory(boolean sameGramCategory) {
        this.sameGramCategory = sameGramCategory;
    }

    public void setMatchLanguage(boolean matchLanguageAttr) {
        this.matchLanguageAttr = matchLanguageAttr;
    }

    public boolean getMatchLanguage() {
        return this.matchLanguageAttr;
    }
}

