/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.lexiconanalyzer;

import java.util.ArrayDeque;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import nl.mpi.lexan.analyzers.lexiconanalyzer.LAInputState;
import nl.mpi.lexan.analyzers.lexiconanalyzer.ParseFragGl;
import nl.mpi.lexan.analyzers.parsebase.AbstractParser;
import nl.mpi.lexan.analyzers.parsebase.InputState;
import nl.mpi.lexan.analyzers.parsebase.ParseFrag;

class Parser
extends AbstractParser {
    private boolean matchLanguageAttr = true;
    protected boolean includeGramCategory;

    public void setMatchLanguage(boolean matchLanguageAttr) {
        this.matchLanguageAttr = matchLanguageAttr;
    }

    public void setIncludeGramCategory(boolean includeGramCategory) {
        this.includeGramCategory = includeGramCategory;
    }

    @Override
    public List<List<ParseFrag>> parse(String word) {
        LinkedList<List<ParseFrag>> parses = new LinkedList<List<ParseFrag>>();
        if (!this.caseSensitiveParsing) {
            word = word.toLowerCase();
        }
        ArrayDeque<InputState> stack = new ArrayDeque<InputState>();
        LAInputState init = new LAInputState(word);
        init.missingGloss = this.missingMarker;
        init.matchLanguage = this.matchLanguageAttr;
        init.includeGramCat = this.includeGramCategory;
        int steps = 0;
        stack.addFirst(init);
        block8: while (!stack.isEmpty()) {
            InputState curr = (InputState)stack.removeFirst();
            if (++steps + stack.size() > this.maxParses) {
                curr.state = AbstractParser.ParseState.ABORT;
            }
            switch (curr.state) {
                case START: {
                    List<InputState> matchesPS = this.matchPrefixesStems(curr);
                    if (matchesPS.size() > 0) {
                        for (int i = matchesPS.size() - 1; i >= 0; --i) {
                            stack.addFirst(matchesPS.get(i));
                        }
                        continue block8;
                    }
                    curr.state = AbstractParser.ParseState.NOSTEM;
                    stack.addFirst(curr);
                    break;
                }
                case STEM: {
                    if (curr.surface.equals("")) {
                        curr.state = AbstractParser.ParseState.OK;
                        stack.addFirst(curr);
                        break;
                    }
                    List<InputState> matchesS = this.matchSuffixes(curr);
                    if (matchesS.size() > 0) {
                        for (int i = matchesS.size() - 1; i >= 0; --i) {
                            stack.addFirst(matchesS.get(i));
                        }
                        continue block8;
                    }
                    curr.state = AbstractParser.ParseState.OKNOP;
                    stack.addFirst(curr);
                    break;
                }
                case NOSTEM: {
                    List<InputState> matchesS = this.matchSuffixes(curr);
                    if (matchesS.size() > 0) {
                        for (int i = matchesS.size() - 1; i >= 0; --i) {
                            stack.addFirst(matchesS.get(i));
                        }
                        continue block8;
                    }
                    curr.state = AbstractParser.ParseState.OKNOP;
                    stack.addFirst(curr);
                    break;
                }
                case OK: {
                    if (this.reversedParseOrder) {
                        parses.addFirst(curr.getFrags());
                        break;
                    }
                    parses.add(curr.getFrags());
                    break;
                }
                case OKNOP: {
                    List<InputState> matchesIS = this.matchInfixedStem(curr);
                    if (matchesIS.size() > 0) {
                        for (int i = matchesIS.size() - 1; i >= 0; --i) {
                            stack.addFirst(matchesIS.get(i));
                        }
                        continue block8;
                    }
                    curr.addFrag(new ParseFragGl(null, curr.surface, this.missingMarker), true);
                    if (this.reversedParseOrder) {
                        parses.addFirst(curr.getFrags());
                        break;
                    }
                    parses.add(curr.getFrags());
                    break;
                }
                case ABORT: {
                    if (this.excludeAbortedParses) break;
                    curr.addFrag(new ParseFragGl(null, "++ABORT++" + curr.surface + "++", this.missingMarker), true);
                    if (this.reversedParseOrder) {
                        parses.addFirst(curr.getFrags());
                        break;
                    }
                    parses.add(curr.getFrags());
                }
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, String.format("Number of parse steps for %s: %d", word, steps));
        }
        int numParses = parses.size();
        this.filterParses(parses);
        if (parses.size() != numParses && LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, String.format("Removed %d duplicates from parse list, remaining %d", numParses - parses.size(), parses.size()));
        }
        return parses;
    }

    private void filterParses(List<List<ParseFrag>> parseList) {
        block0: for (int i = parseList.size() - 1; i > 0; --i) {
            List<ParseFrag> lpf1 = parseList.get(i);
            block1: for (int j = i - 1; j >= 0; --j) {
                List<ParseFrag> lpf2 = parseList.get(j);
                if (lpf1.size() != lpf2.size()) continue;
                for (int k = 0; k < lpf1.size(); ++k) {
                    if (!this.sameFrags((ParseFragGl)lpf1.get(k), (ParseFragGl)lpf2.get(k))) continue block1;
                }
                parseList.remove(i);
                continue block0;
            }
        }
    }

    private boolean sameFrags(ParseFragGl fr1, ParseFragGl fr2) {
        if (fr1 == fr2) {
            return true;
        }
        if (fr1.getLexEntry() != fr2.getLexEntry() && (fr1.getLexEntry() != null || fr2.getLexEntry() != null)) {
            return false;
        }
        if (fr1.getFrag() != null && fr2.getFrag() != null && !fr1.getFrag().equals(fr2.getFrag())) {
            return false;
        }
        if (fr1.getGloss() != null && fr2.getGloss() != null && !fr1.getGloss().equals(fr2.getGloss())) {
            return false;
        }
        return fr1.getGramCat() == null || fr2.getGramCat() == null || fr1.getGramCat().equals(fr2.getGramCat());
    }
}

