/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.parseanalyzer;

import java.util.List;
import java.util.logging.Level;
import nl.mpi.lexan.analyzers.helpers.SourceTargetConfiguration;
import nl.mpi.lexan.analyzers.lexicon.LexAtom;
import nl.mpi.lexan.analyzers.lexicon.LexEntry;
import nl.mpi.lexan.analyzers.lexicon.LexItem;
import nl.mpi.lexan.analyzers.parsebase.AbstractParser;
import nl.mpi.lexan.analyzers.parsebase.InputState;
import nl.mpi.lexan.analyzers.parsebase.ParseFrag;

class PAInputState
extends InputState {
    public PAInputState(String word) {
        super(word);
    }

    protected PAInputState(PAInputState is) {
        super(is);
    }

    @Override
    public void applyPrefix(List<InputState> out, String trigger, LexEntry entry, SourceTargetConfiguration sourceTargetConfig) {
        List variants;
        String lexicalUnit = ((LexAtom)entry.getLexItem("lexical-unit")).getLexValue();
        String replace = "";
        LexItem item = entry.getLexItem(sourceTargetConfig.getFieldForKey("replace"));
        if (item instanceof LexAtom) {
            replace = ((LexAtom)item).getLexValue();
        }
        if (!lexicalUnit.regionMatches(true, 0, trigger, 0, trigger.length()) && (variants = entry.getLexItems("variant")) != null) {
            for (LexItem variant : variants) {
                String var;
                if (!(variant instanceof LexAtom) || (var = ((LexAtom)variant).getLexValue()).isEmpty() || !var.regionMatches(true, 0, trigger, 0, trigger.length())) continue;
                lexicalUnit = var;
                break;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("applyPrefix: replaceField='%s' replace='%s' surface='%s' trigger='%s' lexicalUnit/variant='%s'", replace, replace, this.surface, trigger, lexicalUnit));
        }
        PAInputState newState = new PAInputState(this);
        newState.surface = replace + this.surface.substring(trigger.length());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("applyPrefix: new surface='%s' insert @ %d", newState.surface, this.insertionPoint));
        }
        newState.addFrag(new ParseFrag(entry, lexicalUnit), true);
        out.add(newState);
    }

    @Override
    public void applySuffix(List<InputState> out, String trigger, LexEntry entry, SourceTargetConfiguration sourceTargetConfig) {
        List variants;
        String lexicalUnit = ((LexAtom)entry.getLexItem("lexical-unit")).getLexValue();
        String replace = "";
        LexItem item = entry.getLexItem(sourceTargetConfig.getFieldForKey("replace"));
        if (item instanceof LexAtom) {
            replace = ((LexAtom)item).getLexValue();
        }
        int triggerLen = trigger.length();
        if (!lexicalUnit.regionMatches(true, lexicalUnit.length() - triggerLen, trigger, 0, triggerLen) && (variants = entry.getLexItems("variant")) != null) {
            for (LexItem variant : variants) {
                String var;
                if (!(variant instanceof LexAtom) || (var = ((LexAtom)variant).getLexValue()).isEmpty() || !var.regionMatches(true, var.length() - triggerLen, trigger, 0, triggerLen)) continue;
                lexicalUnit = var;
                break;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("applySuffix: replace='%s' surface='%s' trigger='%s' lexicalUnit/variant='%s'", replace, this.surface, trigger, lexicalUnit));
        }
        PAInputState newState = new PAInputState(this);
        newState.surface = this.surface.substring(0, this.surface.length() - trigger.length()) + replace;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("applySuffix: new surface='%s' insert @ %d", newState.surface, this.insertionPoint));
        }
        newState.addFrag(new ParseFrag(entry, lexicalUnit), false);
        out.add(newState);
    }

    @Override
    public void applyStem(List<InputState> out, String trigger, LexEntry entry, SourceTargetConfiguration sourceTargetConfig) {
        List variants;
        String lexicalUnit = ((LexAtom)entry.getLexItem("lexical-unit")).getLexValue();
        String replace = "";
        LexItem item = entry.getLexItem(sourceTargetConfig.getFieldForKey("replace"));
        if (item instanceof LexAtom) {
            replace = ((LexAtom)item).getLexValue();
        }
        if (!lexicalUnit.equalsIgnoreCase(trigger) && (variants = entry.getLexItems("variant")) != null) {
            for (LexItem variant : variants) {
                String var;
                if (!(variant instanceof LexAtom) || (var = ((LexAtom)variant).getLexValue()).isEmpty() || !var.equalsIgnoreCase(trigger)) continue;
                lexicalUnit = var;
                break;
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("applyStem: replace='%s' surface='%s' trigger='%s' lexicalUnit/variant='%s'", replace, this.surface, trigger, lexicalUnit));
        }
        PAInputState newState = new PAInputState(this);
        newState.surface = replace + newState.surface.substring(trigger.length());
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("applyStem: new surface='%s' insert @ %d", newState.surface, this.insertionPoint));
        }
        newState.addFrag(new ParseFrag(entry, lexicalUnit), true);
        newState.state = AbstractParser.ParseState.STEM;
        out.add(newState);
    }
}

