/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.parseanalyzer;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import nl.mpi.lexan.analyzers.helpers.ConfigurationChanger;
import nl.mpi.lexan.analyzers.helpers.Position;
import nl.mpi.lexan.analyzers.helpers.PositionLexicon;
import nl.mpi.lexan.analyzers.helpers.SourceTargetConfiguration;
import nl.mpi.lexan.analyzers.helpers.Suggestion;
import nl.mpi.lexan.analyzers.helpers.SuggestionSet;
import nl.mpi.lexan.analyzers.helpers.settings.SettingsException;
import nl.mpi.lexan.analyzers.lexicon.LexanLexicon;
import nl.mpi.lexan.analyzers.lexicon.LexiconChangeListener;
import nl.mpi.lexan.analyzers.parseanalyzer.ParseAnalyzerInformation;
import nl.mpi.lexan.analyzers.parseanalyzer.ParseConfigurationPanel;
import nl.mpi.lexan.analyzers.parseanalyzer.Parser;
import nl.mpi.lexan.analyzers.parsebase.AbstractParseAnalyzer;
import nl.mpi.lexan.analyzers.parsebase.AbstractParser;
import nl.mpi.lexan.analyzers.parsebase.ParseConfigurator;
import nl.mpi.lexan.analyzers.parsebase.ParseFrag;

public class ParseAnalyzer
extends AbstractParseAnalyzer {
    public ParseAnalyzer() {
        this.analyzerShortName = ParseAnalyzer.class.getSimpleName();
        this.statisticsFileName = "ParseAnalyzerStats.xml";
        this.info = new ParseAnalyzerInformation();
    }

    public Component getConfigurationComponent(String configKey) {
        if (this.cacheFolder != null) {
            ParseConfigurationPanel pcp = new ParseConfigurationPanel(this.cacheFolder, this.lexiconContext, this.analyzerShortName, configKey, this.loadedSettings);
            pcp.addConfigurationChangeListener(this);
            return pcp;
        }
        return null;
    }

    public boolean isConfigurable() {
        return true;
    }

    @Override
    protected AbstractParser createParser() {
        this.parser = new Parser();
        return this.parser;
    }

    public boolean partLoad(List<SourceTargetConfiguration> configurations) {
        if (configurations == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Cannot partially load, no configurations specified.");
            }
            return false;
        }
        if (this.configs == null) {
            return this.load(configurations);
        }
        int curSize = this.configs.size();
        for (SourceTargetConfiguration conf : configurations) {
            if (!this.checkConfigurationRequirements(conf)) continue;
            if (this.indexOfConfiguration(conf) == -1) {
                PositionLexicon pl;
                SourceTargetConfiguration c = new SourceTargetConfiguration(conf);
                c.putFieldForKey("replace", this.replaceField);
                this.configs.add(c);
                if (!(c.getTargetList().get(0) instanceof PositionLexicon) || (pl = (PositionLexicon)c.getTargetList().get(0)).getEntryField() == null) continue;
                c.putFieldForKey("parse", pl.getEntryField());
                c.putPositionForKey("parse", (Position)pl);
                continue;
            }
            if (!LOG.isLoggable(Level.WARNING)) continue;
            LOG.warning(String.format("This configuration already exists (Source: %s - Target: %s)", conf.getSource().getTierId(), ((Position)conf.getTargetList().get(0)).getTierId()));
        }
        LexanLexicon curLexicon = this.lexanLexicon;
        for (SourceTargetConfiguration stc : this.configs) {
            LexanLexicon nextLexicon;
            PositionLexicon lexPos = null;
            if (stc.getPositionForKey("parse") instanceof PositionLexicon) {
                lexPos = (PositionLexicon)stc.getPositionForKey("parse");
            } else if (stc.getSource() instanceof PositionLexicon) {
                lexPos = (PositionLexicon)stc.getSource();
            }
            if (lexPos == null || (nextLexicon = this.lexiconContext.getLexicon(lexPos.getLexiconId())) == null || nextLexicon == curLexicon) continue;
            if (curLexicon != null) {
                curLexicon.removeLexiconChangeListener((LexiconChangeListener)this);
            }
            this.lexanLexicon = nextLexicon;
            this.lexanLexicon.addLexiconChangeListener((LexiconChangeListener)this);
            this.needSetParserRules = true;
            break;
        }
        this.setInterestingFields();
        return curSize < this.configs.size();
    }

    @Override
    protected int indexOfConfiguration(SourceTargetConfiguration config) {
        if (config != null) {
            for (int i = 0; i < this.configs.size(); ++i) {
                SourceTargetConfiguration conf = (SourceTargetConfiguration)this.configs.get(i);
                if (!conf.getSource().equals((Object)config.getSource()) || config.getTargetList().isEmpty() || !((Position)config.getTargetList().get(0)).equals(conf.getTargetList().get(0))) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    protected void setInterestingFields() {
        HashSet<String> fields = new HashSet<String>();
        for (SourceTargetConfiguration c : this.configs) {
            String f = c.getFieldForKey("replace");
            if (f == null || f.isEmpty()) continue;
            fields.add(f);
        }
        if (this.considerVariants) {
            fields.add("variant");
        }
        if (this.outputCitationForm) {
            fields.add("citation");
        }
        fields.add("lexical-unit");
        this.interestingFields = new ArrayList();
        this.interestingFields.addAll(fields);
    }

    @Override
    protected void analyze(Position source, SourceTargetConfiguration stc) {
        List input = this.analyzerContext.readAnnotation(source);
        String targetSplitTierId = "";
        if (stc.getPositionForKey("parse") != null) {
            targetSplitTierId = stc.getPositionForKey("parse").getTierId();
        } else if (!stc.getTargetList().isEmpty()) {
            targetSplitTierId = ((Position)stc.getTargetList().get(0)).getTierId();
        }
        this.parser.setConfig(stc);
        for (Suggestion s : input) {
            List<List<ParseFrag>> parses = this.parser.parse(s.getContent());
            LinkedList<SuggestionSet> suggestionSets = new LinkedList<SuggestionSet>();
            Position splitPosition = new Position(targetSplitTierId, s.getPosition());
            int parsenr = 0;
            for (List<ParseFrag> parsefrags : parses) {
                SuggestionSet ss = new SuggestionSet(source);
                for (ParseFrag frag : parsefrags) {
                    Suggestion toaddSplit = new Suggestion(this.getSplitFragment(frag), splitPosition);
                    toaddSplit.setLexEntry(frag.getLexEntry());
                    ss.add(toaddSplit);
                }
                if (this.suggestionMemory != null && this.suggestionMemory.isPermanentlyRemoved(s, ss)) continue;
                ss.setLabel("Parse #" + parsenr++);
                suggestionSets.add(ss);
            }
            if (this.suggestionMemory != null) {
                this.suggestionMemory.rearrangeByFrequency(s, suggestionSets);
            }
            this.analyzerContext.newAnnotations(suggestionSets);
        }
    }

    @Override
    public void configurationChanged(ConfigurationChanger source) {
        if (!(source instanceof ParseConfigurationPanel)) {
            return;
        }
        super.configurationChanged(source);
    }

    public void loadSettingsFor(String configId) {
        block3: {
            ParseConfigurator configHandler = new ParseConfigurator(this.cacheFolder, this.analyzerShortName, configId);
            this.loadedSettings = configId;
            try {
                configHandler.loadCurrentSettings();
                if (configHandler.getCurrentSettings() != null) {
                    this.loadedSettings = configHandler.getCurrentSettings().getKey();
                }
                this.applySettings(configHandler);
            }
            catch (SettingsException se) {
                if (!LOG.isLoggable(Level.WARNING)) break block3;
                LOG.warning("Unable to load settings: " + se.getMessage());
            }
        }
    }
}

