/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.parseanalyzer;

import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import nl.mpi.lexan.analyzers.parseanalyzer.PAInputState;
import nl.mpi.lexan.analyzers.parsebase.AbstractParser;
import nl.mpi.lexan.analyzers.parsebase.InputState;
import nl.mpi.lexan.analyzers.parsebase.ParseFrag;

public class Parser
extends AbstractParser {
    @Override
    public List<List<ParseFrag>> parse(String word) {
        LinkedList<List<ParseFrag>> parses = new LinkedList<List<ParseFrag>>();
        if (!this.caseSensitiveParsing) {
            word = word.toLowerCase();
        }
        Stack<InputState> stack = new Stack<InputState>();
        PAInputState init = new PAInputState(word);
        int steps = 0;
        stack.push(init);
        while (!stack.empty()) {
            InputState curr = (InputState)stack.pop();
            if (++steps + stack.size() > this.maxParses) {
                curr.state = AbstractParser.ParseState.ABORT;
            }
            switch (curr.state) {
                case START: {
                    List<InputState> matchesPS = this.matchPrefixesStems(curr);
                    if (matchesPS.size() > 0) {
                        stack.addAll(matchesPS);
                        break;
                    }
                    curr.state = AbstractParser.ParseState.NOSTEM;
                    stack.push(curr);
                    break;
                }
                case STEM: {
                    if (curr.surface.equals("")) {
                        curr.state = AbstractParser.ParseState.OK;
                        stack.push(curr);
                        break;
                    }
                    List<InputState> matchesS = this.matchSuffixes(curr);
                    if (matchesS.size() > 0) {
                        stack.addAll(matchesS);
                        break;
                    }
                    curr.state = AbstractParser.ParseState.OKNOP;
                    stack.push(curr);
                    break;
                }
                case NOSTEM: {
                    List<InputState> matchesS = this.matchSuffixes(curr);
                    if (matchesS.size() > 0) {
                        stack.addAll(matchesS);
                        break;
                    }
                    curr.state = AbstractParser.ParseState.OKNOP;
                    stack.push(curr);
                    break;
                }
                case OK: {
                    if (this.reversedParseOrder) {
                        parses.addFirst(curr.getFrags());
                        break;
                    }
                    parses.add(curr.getFrags());
                    break;
                }
                case OKNOP: {
                    curr.addFrag(new ParseFrag(null, curr.surface), true);
                    if (this.reversedParseOrder) {
                        parses.addFirst(curr.getFrags());
                        break;
                    }
                    parses.add(curr.getFrags());
                    break;
                }
                case ABORT: {
                    if (this.excludeAbortedParses) break;
                    curr.addFrag(new ParseFrag(null, "++ABORT++" + curr.surface + "++"), true);
                    if (this.reversedParseOrder) {
                        parses.addFirst(curr.getFrags());
                        break;
                    }
                    parses.add(curr.getFrags());
                }
            }
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("Number of parse steps for %s: %d", word, steps));
        }
        return parses;
    }
}

