/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.parsebase;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import nl.mpi.lexan.analyzers.TextAnalyzerLexiconContext;
import nl.mpi.lexan.analyzers.helpers.ConfigurationChangeListener;
import nl.mpi.lexan.analyzers.helpers.ConfigurationChanger;
import nl.mpi.lexan.analyzers.helpers.ConfigurationHandler;
import nl.mpi.lexan.analyzers.helpers.settings.SettingsException;
import nl.mpi.lexan.analyzers.parsebase.ParseConfigurator;

public abstract class AbstractConfigurationPanel
extends JPanel
implements ActionListener,
ConfigurationChanger {
    public static final Logger LOG = Logger.getLogger(AbstractConfigurationPanel.class.getName());
    protected String analyzerName = "ParseAnalyzer";
    protected String curSettingsKey = null;
    private String settingsToRemove = null;
    private List<ConfigurationChangeListener> listeners;
    private File dataDirectory;
    protected ParseConfigurator configHandler;
    private JTextField affixMarkerTF;
    private JTextField missingMarkerTF;
    private JButton saveButton;
    private TextAnalyzerLexiconContext lexiconContext;
    private JCheckBox variantCB;
    private JTextField nparsesTF;
    private JCheckBox excludeAbortParsesCB;
    private JTextField replaceTF;
    private JCheckBox longFragmentsCB;
    private JCheckBox caseSensitiveCB;
    protected JCheckBox matchLanguageAttrCB;
    private JCheckBox sameGramCategoryCB;
    private JTextField cliticMarkerTF;
    protected JCheckBox outputCitationCB;

    public AbstractConfigurationPanel(File dataDirectory, TextAnalyzerLexiconContext lexiconContext, String analyzerSimpleName, String curSettingsKey, String settingsToRemove) {
        this.lexiconContext = lexiconContext;
        this.dataDirectory = dataDirectory;
        this.analyzerName = analyzerSimpleName;
        this.curSettingsKey = curSettingsKey;
        this.settingsToRemove = settingsToRemove;
        this.initSettings();
        this.initComponents();
        this.loadSettings();
    }

    public ConfigurationHandler getConfigHandler() {
        return this.configHandler;
    }

    public String getCurrentSettingsKey() {
        return this.curSettingsKey;
    }

    protected void initSettings() {
        this.configHandler = new ParseConfigurator(this.dataDirectory, this.analyzerName, this.curSettingsKey);
    }

    private void initComponents() {
        this.saveButton = new JButton("Apply Settings");
        this.saveButton.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.variantCB = new JCheckBox("Include variants in the parsing process");
        this.variantCB.setToolTipText("For parsing, consider variants acceptable in place of the selected entry field (default is lexical-unit");
        this.excludeAbortParsesCB = new JCheckBox("Exclude aborted parses from results");
        this.excludeAbortParsesCB.setToolTipText("Partial, unfinished parses will not be in the set of suggestions");
        this.caseSensitiveCB = new JCheckBox("Case sensitive matching");
        JLabel nparsesL = new JLabel("Maximum number of parse steps:");
        this.nparsesTF = new JTextField("", 5);
        JLabel replaceL = new JLabel("\"Replace\" field in lexicon:");
        this.replaceTF = new JTextField("", 7);
        JLabel affixL = new JLabel("Affix marker character:");
        this.affixMarkerTF = new JTextField("", 5);
        JLabel missingL = new JLabel("String for missing values");
        this.missingMarkerTF = new JTextField("", 5);
        this.longFragmentsCB = new JCheckBox("Match longer prefixes/suffixes first");
        JLabel cliticL = new JLabel("Clitic marker character:");
        this.cliticMarkerTF = new JTextField("", 5);
        this.matchLanguageAttrCB = new JCheckBox("Match entry field language against tier content language");
        this.matchLanguageAttrCB.setToolTipText("Only include a field's value (e.g. gloss) if its language attribute matches the content language of the target tier");
        this.sameGramCategoryCB = new JCheckBox("Only suggest parses with same category constituents");
        this.sameGramCategoryCB.setToolTipText("Only produce suggestion sets where all fragments are of the same encoded grammatical category");
        this.outputCitationCB = new JCheckBox("Use the citation form of the lexical entry in the output");
        Insets insets = new Insets(4, 6, 4, 6);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.insets = insets;
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.gridwidth = 2;
        this.add((Component)this.variantCB, gbc);
        ++gbc.gridy;
        this.add((Component)this.longFragmentsCB, gbc);
        ++gbc.gridy;
        this.add((Component)this.excludeAbortParsesCB, gbc);
        ++gbc.gridy;
        this.add((Component)this.caseSensitiveCB, gbc);
        ++gbc.gridy;
        this.add((Component)this.matchLanguageAttrCB, gbc);
        ++gbc.gridy;
        this.add((Component)this.sameGramCategoryCB, gbc);
        ++gbc.gridy;
        this.add((Component)this.outputCitationCB, gbc);
        ++gbc.gridy;
        gbc.gridwidth = 1;
        this.add((Component)nparsesL, gbc);
        gbc.gridx = 1;
        this.add((Component)this.nparsesTF, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.add((Component)affixL, gbc);
        gbc.gridx = 1;
        this.add((Component)this.affixMarkerTF, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.add((Component)cliticL, gbc);
        gbc.gridx = 1;
        this.add((Component)this.cliticMarkerTF, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.add((Component)missingL, gbc);
        gbc.gridx = 1;
        this.add((Component)this.missingMarkerTF, gbc);
        ++gbc.gridy;
        gbc.gridx = 0;
        this.add((Component)replaceL, gbc);
        gbc.gridx = 1;
        this.add((Component)this.replaceTF, gbc);
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.setBorder(new TitledBorder(""));
        GridBagConstraints gbc2 = new GridBagConstraints();
        gbc2.anchor = 10;
        gbc2.insets = new Insets(2, 2, 2, 2);
        buttonPanel.add((Component)this.saveButton, gbc2);
        ++gbc.gridy;
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.weightx = 0.1;
        gbc.weighty = 0.0;
        gbc.insets = new Insets(8, 6, 4, 6);
        this.add((Component)buttonPanel, gbc);
        JPanel filler = new JPanel(null);
        filler.setPreferredSize(new Dimension(4, 4));
        ++gbc.gridy;
        gbc.fill = 3;
        gbc.weighty = 1.0;
        this.add((Component)filler, gbc);
    }

    private void loadSettings() {
        block4: {
            try {
                String cliticMarkSett;
                this.configHandler.loadCurrentSettings();
                this.nparsesTF.setText(String.valueOf(this.configHandler.getInt("NumberOfParses")));
                this.variantCB.setSelected(this.configHandler.getBoolean("ConsiderVariants"));
                this.affixMarkerTF.setText(this.configHandler.getString("AffixMarker"));
                this.excludeAbortParsesCB.setSelected(this.configHandler.getBoolean("ExcludeAbortedParses"));
                this.replaceTF.setText(this.configHandler.getString("ReplaceField"));
                this.missingMarkerTF.setText(this.configHandler.getString("MissingMarker"));
                this.longFragmentsCB.setSelected(this.configHandler.getBoolean("MatchLongerFragmentsFirst"));
                this.caseSensitiveCB.setSelected(this.configHandler.getBoolean("CaseSensitiveMatching"));
                this.sameGramCategoryCB.setSelected(this.configHandler.getBoolean("SameGramCategory"));
                if (this.matchLanguageAttrCB.isVisible()) {
                    this.matchLanguageAttrCB.setSelected(this.configHandler.getBoolean("MatchLanguageAttributes"));
                }
                if ((cliticMarkSett = this.configHandler.getString("CliticMarker")) != null) {
                    this.cliticMarkerTF.setText(cliticMarkSett);
                }
                this.outputCitationCB.setSelected(this.configHandler.getBoolean("OutputCitationForm"));
            }
            catch (SettingsException se) {
                if (!LOG.isLoggable(Level.WARNING)) break block4;
                LOG.warning(this.analyzerName + ": " + se.getMessage());
            }
        }
    }

    public void loadSettingsForKey(String settingsKey) {
        if (this.curSettingsKey == null && settingsKey == null) {
            return;
        }
        if (this.curSettingsKey != null && this.curSettingsKey.equals(settingsKey)) {
            return;
        }
        this.curSettingsKey = settingsKey;
        this.configHandler = new ParseConfigurator(this.dataDirectory, this.analyzerName, this.curSettingsKey);
        this.loadSettings();
    }

    private void saveSettings() {
        block3: {
            try {
                this.configHandler.saveCurrentSettings();
                if (this.settingsToRemove != null && !this.settingsToRemove.equals(this.curSettingsKey)) {
                    this.configHandler.removeSettings(this.settingsToRemove);
                }
            }
            catch (SettingsException se) {
                if (!LOG.isLoggable(Level.WARNING)) break block3;
                LOG.warning(this.analyzerName + ": " + se.getMessage());
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        if (ae.getSource() == this.saveButton) {
            String curCliticMark;
            this.configHandler.setBoolean("ConsiderVariants", this.variantCB.isSelected());
            try {
                this.configHandler.setInt("NumberOfParses", Integer.parseInt(this.nparsesTF.getText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.configHandler.setBoolean("MatchLongerFragmentsFirst", this.longFragmentsCB.isSelected());
            this.configHandler.setBoolean("ExcludeAbortedParses", this.excludeAbortParsesCB.isSelected());
            this.configHandler.setString("AffixMarker", this.affixMarkerTF.getText().trim());
            this.configHandler.setString("ReplaceField", this.replaceTF.getText().trim());
            this.configHandler.setString("MissingMarker", this.missingMarkerTF.getText().trim());
            this.configHandler.setBoolean("CaseSensitiveMatching", this.caseSensitiveCB.isSelected());
            this.configHandler.setBoolean("SameGramCategory", this.sameGramCategoryCB.isSelected());
            if (this.matchLanguageAttrCB.isVisible()) {
                this.configHandler.setBoolean("MatchLanguageAttributes", this.matchLanguageAttrCB.isSelected());
            }
            if ((curCliticMark = this.cliticMarkerTF.getText().trim()) != null && !curCliticMark.isEmpty()) {
                this.configHandler.setString("CliticMarker", curCliticMark);
            }
            this.configHandler.setBoolean("OutputCitationForm", this.outputCitationCB.isSelected());
            this.notifyListeners();
            this.saveSettings();
        }
    }

    public void addConfigurationChangeListener(ConfigurationChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ConfigurationChangeListener>(2);
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeConfigurationChangeListener(ConfigurationChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void removeAllListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
            this.listeners = null;
        }
    }

    public void notifyListeners() {
        if (this.listeners != null) {
            for (ConfigurationChangeListener l : this.listeners) {
                l.configurationChanged((ConfigurationChanger)this);
            }
        }
    }
}

