/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.parsebase;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import nl.mpi.lexan.analyzers.LexiconTextAnalyzer;
import nl.mpi.lexan.analyzers.TextAnalyzerContext;
import nl.mpi.lexan.analyzers.TextAnalyzerLexiconContext;
import nl.mpi.lexan.analyzers.helpers.ConfigurationChangeListener;
import nl.mpi.lexan.analyzers.helpers.ConfigurationChanger;
import nl.mpi.lexan.analyzers.helpers.Information;
import nl.mpi.lexan.analyzers.helpers.LexanSuggestionSelectionListener;
import nl.mpi.lexan.analyzers.helpers.Position;
import nl.mpi.lexan.analyzers.helpers.SourceTargetConfiguration;
import nl.mpi.lexan.analyzers.helpers.Suggestion;
import nl.mpi.lexan.analyzers.helpers.SuggestionSet;
import nl.mpi.lexan.analyzers.helpers.statistics.SuggestionMemory;
import nl.mpi.lexan.analyzers.lexicon.LexAtom;
import nl.mpi.lexan.analyzers.lexicon.LexEntry;
import nl.mpi.lexan.analyzers.lexicon.LexItem;
import nl.mpi.lexan.analyzers.lexicon.LexanLexicon;
import nl.mpi.lexan.analyzers.lexicon.LexiconChangeEvent;
import nl.mpi.lexan.analyzers.lexicon.LexiconChangeListener;
import nl.mpi.lexan.analyzers.parsebase.AbstractConfigurationPanel;
import nl.mpi.lexan.analyzers.parsebase.AbstractParser;
import nl.mpi.lexan.analyzers.parsebase.ParseConfigurator;
import nl.mpi.lexan.analyzers.parsebase.ParseFrag;

public abstract class AbstractParseAnalyzer
implements LexiconTextAnalyzer,
ConfigurationChangeListener,
LexanSuggestionSelectionListener,
LexiconChangeListener {
    protected String analyzerShortName = this.getClass().getSimpleName();
    public static final Logger LOG = Logger.getLogger(AbstractParseAnalyzer.class.getName());
    public static final String DEFAULT_REPLACE_FIELD = "replace";
    protected String statisticsFileName = "";
    protected Information info;
    protected List<SourceTargetConfiguration> configs = null;
    protected boolean paused = true;
    protected List<Position> pauseList = null;
    protected AbstractParser parser = null;
    protected TextAnalyzerContext analyzerContext;
    protected TextAnalyzerLexiconContext lexiconContext;
    protected File cacheFolder;
    protected LexanLexicon lexanLexicon;
    protected List<String> interestingFields;
    protected boolean needSetParserRules;
    protected SuggestionMemory suggestionMemory;
    protected File statisticsFile;
    protected ParseConfigurator configHandler;
    protected String loadedSettings = null;
    protected boolean considerVariants;
    protected String replaceField = "replace";
    protected boolean outputCitationForm;

    protected String getAnalyzerShortName() {
        return this.analyzerShortName;
    }

    public String getReplaceField() {
        return this.replaceField;
    }

    public void setReplaceField(String replaceField) {
        if (!this.replaceField.equals(replaceField)) {
            this.replaceField = replaceField;
            if (this.configs != null) {
                for (SourceTargetConfiguration stc : this.configs) {
                    stc.putFieldForKey(DEFAULT_REPLACE_FIELD, replaceField);
                }
            }
            this.setInterestingFields();
        }
    }

    public void setAnalyzerContext(TextAnalyzerContext lc) {
        if (this.analyzerContext != null) {
            this.analyzerContext.removeSuggestionSelectionListener((LexanSuggestionSelectionListener)this);
        }
        this.analyzerContext = lc;
    }

    public void setLexiconContext(TextAnalyzerLexiconContext lexiconContext) {
        this.lexiconContext = lexiconContext;
    }

    public Information getInformation() {
        return this.info;
    }

    protected abstract AbstractParser createParser();

    public boolean load(List<SourceTargetConfiguration> configurations) {
        if (configurations == null || configurations.size() == 0) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("Cannot initialize, no source-target configurations specified.");
            }
            return false;
        }
        if (this.configs != null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("The analyzer is already initialized, cannot initialize again.");
            }
            return false;
        }
        this.configs = new ArrayList<SourceTargetConfiguration>(configurations.size());
        this.lexanLexicon = null;
        if (!this.partLoad(configurations)) {
            this.unload();
            return false;
        }
        this.suggestionMemory = new SuggestionMemory(this.analyzerContext, this.statisticsFile);
        this.parser = this.createParser();
        this.paused = false;
        this.pauseList = new LinkedList<Position>();
        if (this.configHandler != null) {
            this.applySettings(this.configHandler);
        }
        this.analyzerContext.addSuggestionSelectionListener((LexanSuggestionSelectionListener)this);
        return true;
    }

    public boolean unload() {
        if (this.statisticsFile != null && this.suggestionMemory != null) {
            this.suggestionMemory.save(this.statisticsFile);
        }
        if (this.analyzerContext != null) {
            this.analyzerContext.removeSuggestionSelectionListener((LexanSuggestionSelectionListener)this);
        }
        if (this.lexanLexicon != null) {
            this.lexanLexicon.removeLexiconChangeListener((LexiconChangeListener)this);
        }
        this.configs = null;
        this.configHandler = null;
        this.parser = null;
        this.paused = true;
        this.pauseList = null;
        this.analyzerContext = null;
        this.lexiconContext = null;
        this.statisticsFile = null;
        this.suggestionMemory = null;
        this.lexanLexicon = null;
        return true;
    }

    public int partUnload(List<SourceTargetConfiguration> configurations) {
        if (configurations == null || configurations.isEmpty()) {
            return this.configs.size();
        }
        for (SourceTargetConfiguration conf : configurations) {
            int index = this.indexOfConfiguration(conf);
            if (index <= -1) continue;
            for (Position l : this.pauseList) {
                if (!l.getTierId().equals(conf.getSource().getTierId())) continue;
                this.pauseList.remove(l);
            }
            SourceTargetConfiguration sourceTargetConfiguration = this.configs.remove(index);
        }
        return this.configs.size();
    }

    protected boolean checkConfigurationRequirements(SourceTargetConfiguration stc) {
        if (stc == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("The tested configuration is null, ignoring.");
            }
            return false;
        }
        if (stc.getSource() == null) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("No source tier specified in a configuration, removing.");
            }
            return false;
        }
        if (stc.getTargetList().isEmpty()) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("No target tier specified in a configuration, removing.");
            }
            return false;
        }
        if (stc.getSource().equals(stc.getTargetList().get(0))) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning("The source tier and target tier are the same, removing.");
            }
            return false;
        }
        return true;
    }

    protected abstract int indexOfConfiguration(SourceTargetConfiguration var1);

    protected abstract void setInterestingFields();

    public void analyze(Position pos) {
        if (this.paused) {
            this.pauseList.add(pos);
            return;
        }
        this.setParserRulesIfNeeded();
        for (SourceTargetConfiguration stc : this.configs) {
            if (!stc.getSource().getTierId().equals(pos.getTierId())) continue;
            this.analyze(pos, stc);
        }
    }

    protected void analyze(Position source, SourceTargetConfiguration stc) {
        List input = this.analyzerContext.readAnnotation(source);
        String targetSplitTierId = stc.getPositionForKey("parse").getTierId();
        this.parser.setConfig(stc);
        for (Suggestion s : input) {
            List<List<ParseFrag>> parses = this.parser.parse(s.getContent());
            LinkedList<SuggestionSet> suggestionSets = new LinkedList<SuggestionSet>();
            Position splitPosition = new Position(targetSplitTierId, s.getPosition());
            int parsenr = 0;
            for (List<ParseFrag> parsefrags : parses) {
                SuggestionSet ss = new SuggestionSet(source);
                for (ParseFrag frag : parsefrags) {
                    Suggestion toaddSplit = new Suggestion(this.getSplitFragment(frag), splitPosition);
                    toaddSplit.setLexEntry(frag.getLexEntry());
                    ss.add(toaddSplit);
                }
                ss.setLabel("Parse #" + parsenr++);
                suggestionSets.add(ss);
            }
            if (this.suggestionMemory != null) {
                this.suggestionMemory.rearrangeByFrequency(s, suggestionSets);
            }
            this.analyzerContext.newAnnotations(suggestionSets);
        }
    }

    protected String getSplitFragment(ParseFrag frag) {
        LexItem citForm;
        if (this.outputCitationForm && frag.getLexEntry() != null && (citForm = frag.getLexEntry().getLexItem("citation")) instanceof LexAtom) {
            String citString = ((LexAtom)citForm).getLexValue();
            return citString != null ? citString : frag.getFrag();
        }
        return frag.getFrag();
    }

    public void pause() {
        this.paused = true;
    }

    public void unPause() {
        this.paused = false;
        for (Position p : this.pauseList) {
            this.analyze(p);
        }
    }

    public void saveState() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.analyzerShortName + " saveState");
        }
    }

    public void loadState() {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(this.analyzerShortName + " loadState");
        }
    }

    public void configurationChanged(ConfigurationChanger source) {
        if (!(source instanceof AbstractConfigurationPanel)) {
            return;
        }
        AbstractConfigurationPanel configComponent = (AbstractConfigurationPanel)source;
        if (configComponent.getConfigHandler() instanceof ParseConfigurator) {
            this.applySettings((ParseConfigurator)configComponent.getConfigHandler());
        }
        this.loadedSettings = configComponent.getCurrentSettingsKey();
    }

    protected void applySettings(ParseConfigurator configHandler) {
        if (configHandler != null) {
            String cliticMark;
            String missingMark;
            int numParses;
            this.configHandler = configHandler;
            String replaceFieldSett = configHandler.getString("ReplaceField");
            if (replaceFieldSett != null && !this.replaceField.equals(replaceFieldSett)) {
                this.setReplaceField(replaceFieldSett);
            }
            if (this.parser == null) {
                return;
            }
            String affixMark = configHandler.getString("AffixMarker");
            if (affixMark != null && !this.parser.getAffixMarker().equals(affixMark)) {
                this.parser.setAffixMarker(affixMark);
                this.needSetParserRules = true;
            }
            if ((numParses = configHandler.getInt("NumberOfParses")) > 0) {
                this.parser.setMaxParses(numParses);
            }
            if ((missingMark = configHandler.getString("MissingMarker")) != null && !this.parser.getMissingMarker().equals(missingMark)) {
                this.parser.setMissingMarker(missingMark);
            }
            this.parser.setExcludeAbortedParses(configHandler.getBoolean("ExcludeAbortedParses"));
            this.parser.setLongerFragmentsFirst(configHandler.getBoolean("MatchLongerFragmentsFirst"));
            boolean caseSensSett = configHandler.getBoolean("CaseSensitiveMatching");
            if (caseSensSett != this.parser.isCaseSensitiveParsing()) {
                this.parser.setCaseSensitiveParsing(caseSensSett);
                this.needSetParserRules = true;
            }
            if ((cliticMark = configHandler.getString("CliticMarker")) != null && this.parser.getCliticMarker() != null && !this.parser.getCliticMarker().equals(cliticMark)) {
                this.parser.setCliticMarker(cliticMark);
                this.needSetParserRules = true;
            }
            boolean curOutputCitation = this.outputCitationForm;
            this.outputCitationForm = configHandler.getBoolean("OutputCitationForm");
            if (curOutputCitation != this.outputCitationForm) {
                if (this.outputCitationForm) {
                    this.needSetParserRules = true;
                }
                this.setInterestingFields();
            }
            boolean curConsiderVariants = this.considerVariants;
            this.considerVariants = configHandler.getBoolean("ConsiderVariants");
            if (this.considerVariants != curConsiderVariants) {
                this.needSetParserRules = true;
                this.setInterestingFields();
            }
        }
    }

    protected void setParserRulesIfNeeded() {
        if (this.needSetParserRules) {
            this.parser.setRules(this.lexanLexicon, this.interestingFields, this.considerVariants);
            this.needSetParserRules = false;
        }
    }

    public void setCacheFolder(File f) {
        if (!(f != null && f.isDirectory() && f.canRead() && f.canWrite())) {
            if (LOG.isLoggable(Level.WARNING)) {
                LOG.warning(String.format("The provided cache folder cannot be used: %s", f));
            }
            return;
        }
        this.cacheFolder = f;
        this.statisticsFile = new File(this.cacheFolder, this.statisticsFileName);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("The cache file for the Parse analyzer is set to: %s", this.statisticsFile));
        }
    }

    public void setLexiconLinkForPosition(Position pos, LexanLexicon lexicon, String entryField) {
    }

    public void removeLexiconLinkForPosition(Position pos, String entryField) {
    }

    public void suggestionSelected(int nr, SuggestionSet selection) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("%s suggestionSelected: %d %s", this.analyzerShortName, nr, String.valueOf(selection)));
        }
        if (this.suggestionMemory == null) {
            this.suggestionMemory = new SuggestionMemory(this.analyzerContext, this.statisticsFile);
        }
        this.suggestionMemory.updateStatistics(selection);
    }

    public void suggestionIgnored(SuggestionSet ignored) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("%s suggestionIgnored: %s", this.analyzerShortName, String.valueOf(ignored)));
        }
    }

    public void suggestionClosed(SuggestionSet ignored) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("%s suggestionClosed: %s", this.analyzerShortName, String.valueOf(ignored)));
        }
        if (this.suggestionMemory != null) {
            this.suggestionMemory.save(this.statisticsFile);
        }
    }

    public void suggestionRemoved(SuggestionSet removed) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine(String.format("%s suggestionPermRemoved: %s", this.analyzerShortName, String.valueOf(removed)));
        }
        if (this.suggestionMemory == null) {
            this.suggestionMemory = new SuggestionMemory(this.analyzerContext, this.statisticsFile);
        }
        this.suggestionMemory.removePermanently(removed);
    }

    public void lexiconChanged(LexiconChangeEvent event) {
        if (event.getSource() == this.lexanLexicon) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.analyzerShortName + " lexiconChanged");
            }
            switch (event.getChangeType()) {
                case ADD: {
                    if (!(event.getChangedObject() instanceof LexEntry)) break;
                    this.parser.entryAdded((LexEntry)event.getChangedObject());
                    break;
                }
                case DELETE: {
                    if (!(event.getChangedObject() instanceof LexEntry)) break;
                    this.parser.entryDeleted((LexEntry)event.getChangedObject());
                    break;
                }
                default: {
                    this.needSetParserRules = true;
                }
            }
        }
    }
}

