/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.parsebase;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import nl.mpi.lexan.analyzers.helpers.SourceTargetConfiguration;
import nl.mpi.lexan.analyzers.lexicon.LexAtom;
import nl.mpi.lexan.analyzers.lexicon.LexEntry;
import nl.mpi.lexan.analyzers.lexicon.LexItem;
import nl.mpi.lexan.analyzers.lexicon.LexanLexicon;
import nl.mpi.lexan.analyzers.parsebase.InputState;
import nl.mpi.lexan.analyzers.parsebase.ParseFrag;

public abstract class AbstractParser {
    public static final Logger LOG = Logger.getLogger("Parser");
    public static final String VARIANT = "variant";
    public static final String MORPH_TYPE = "morph-type";
    public static final String LEXICAL_UNIT = "lexical-unit";
    public static final String PARSE_KEY = "parse";
    public static final String GLOSS_KEY = "gloss";
    public static final String REPLACE_KEY = "replace";
    public static final String LANG_KEY = "lang";
    public static final String SENSE = "sense";
    public static final String GRAM_CAT = "grammatical-category";
    public static final String SENSE_GRAM_CAT = "sense/grammatical-category";
    public static final String CITATION = "citation";
    public static final String HYPHEN = "-";
    public static final String STEM = "stem";
    public static final String STEM2 = "root";
    public static final String SUFFIX = "suffix";
    public static final String PREFIX = "prefix";
    public static final String ENCLITIC = "enclitic";
    public static final String PROCLITIC = "proclitic";
    public static final String INFIX = "infix";
    public static final String MISSING = "*";
    public static final int MORPH_TYPE_UKNOWN = 0;
    public static final int MORPH_TYPE_PREFIX = 1;
    public static final int MORPH_TYPE_STEM = 2;
    public static final int MORPH_TYPE_SUFFIX = 3;
    public static final int MORPH_TYPE_PROCLITIC = 4;
    public static final int MORPH_TYPE_ENCLITIC = 5;
    public static final int MORPH_TYPE_INFIX = 6;
    protected String affixMarker = "-";
    protected String missingMarker = "*";
    protected String cliticMarker = "";
    protected Map<String, List<LexEntry>> prefixMap = new HashMap<String, List<LexEntry>>();
    protected Map<String, List<LexEntry>> stemMap = new HashMap<String, List<LexEntry>>();
    protected Map<String, List<LexEntry>> suffixMap = new HashMap<String, List<LexEntry>>();
    protected Map<String, List<LexEntry>> infixMap = new HashMap<String, List<LexEntry>>();
    protected SourceTargetConfiguration sourceTargetConfig;
    protected int longestPrefix;
    protected int longestSuffix;
    protected int longestInfix;
    protected int longestStem;
    protected int longestPrefixAndStem;
    protected int maxParses = 256;
    protected boolean considerVariants = false;
    protected boolean excludeAbortedParses = false;
    protected boolean longerFragmentsFirst = false;
    protected boolean reversedParseOrder = false;
    protected boolean caseSensitiveParsing = true;

    public void clearRules() {
        this.prefixMap.clear();
        this.stemMap.clear();
        this.suffixMap.clear();
        this.infixMap.clear();
        this.longestStem = 0;
        this.longestPrefix = 0;
        this.longestSuffix = 0;
        this.longestInfix = 0;
        this.longestPrefixAndStem = 0;
    }

    public boolean setRules(LexanLexicon lexanLexicon, List<String> interestingFields, boolean considerVariants) {
        this.considerVariants = considerVariants;
        this.clearRules();
        if (lexanLexicon == null) {
            return false;
        }
        LexAtom queryAtom = new LexAtom(LEXICAL_UNIT, null);
        List entries = lexanLexicon.getEntries(queryAtom, interestingFields);
        for (LexEntry entry : entries) {
            this.addLexicalEntryToMaps(entry);
        }
        this.longestPrefixAndStem = Math.max(this.longestStem, this.longestPrefix);
        return true;
    }

    public int getMaxParses() {
        return this.maxParses;
    }

    public void setMaxParses(int maxParses) {
        if (maxParses > 0) {
            this.maxParses = maxParses;
        }
    }

    public String getAffixMarker() {
        return this.affixMarker;
    }

    public void setAffixMarker(String affixMarker) {
        if (affixMarker == null) {
            return;
        }
        this.affixMarker = affixMarker;
    }

    public String getMissingMarker() {
        return this.missingMarker;
    }

    public void setMissingMarker(String missingMarker) {
        if (missingMarker != null) {
            this.missingMarker = missingMarker;
        }
    }

    public boolean isExcludeAbortedParses() {
        return this.excludeAbortedParses;
    }

    public void setExcludeAbortedParses(boolean excludeAbortedParses) {
        this.excludeAbortedParses = excludeAbortedParses;
    }

    public boolean isLongerFragmentsFirst() {
        return this.longerFragmentsFirst;
    }

    public void setLongerFragmentsFirst(boolean longerFragmentsFirst) {
        this.longerFragmentsFirst = longerFragmentsFirst;
    }

    public boolean isCaseSensitiveParsing() {
        return this.caseSensitiveParsing;
    }

    public void setCaseSensitiveParsing(boolean caseSensitiveParsing) {
        this.caseSensitiveParsing = caseSensitiveParsing;
    }

    public boolean isReversedParseOrder() {
        return this.reversedParseOrder;
    }

    public void setReversedParseOrder(boolean reversedParseOrder) {
        this.reversedParseOrder = reversedParseOrder;
    }

    public String getCliticMarker() {
        return this.cliticMarker;
    }

    public void setCliticMarker(String cliticMarker) {
        this.cliticMarker = cliticMarker == null ? "" : cliticMarker;
    }

    public void entryAdded(LexEntry lexEntry) {
        if (lexEntry != null) {
            this.addLexicalEntryToMaps(lexEntry);
            this.longestPrefixAndStem = Math.max(this.longestStem, this.longestPrefix);
        }
    }

    public void entryDeleted(LexEntry lexEntry) {
        if (lexEntry != null) {
            this.removeLexicalEntryFromMaps(lexEntry);
        }
    }

    protected int getMorphType(LexEntry lexEntry) {
        LexAtom atomlexicalUnit;
        String lexUnit;
        LexItem lexicalUnit;
        String morphType;
        LexItem mtItem;
        if (lexEntry != null && (mtItem = lexEntry.getLexItem(MORPH_TYPE)) instanceof LexAtom && (morphType = ((LexAtom)mtItem).getLexValue()) != null) {
            if (PREFIX.equals(morphType)) {
                return 1;
            }
            if (SUFFIX.equals(morphType)) {
                return 3;
            }
            if (STEM.equals(morphType) || STEM2.equals(morphType)) {
                return 2;
            }
            if (INFIX.equals(morphType)) {
                return 6;
            }
            if (PROCLITIC.equals(morphType)) {
                return 4;
            }
            if (ENCLITIC.equals(morphType)) {
                return 5;
            }
        }
        if ((lexicalUnit = lexEntry.getLexItem(LEXICAL_UNIT)) instanceof LexAtom && (lexUnit = (atomlexicalUnit = (LexAtom)lexicalUnit).getLexValue()) != null) {
            int length = lexUnit.length();
            if (length > 1 && lexUnit.endsWith(this.affixMarker)) {
                return 1;
            }
            if (length > 1 && lexUnit.startsWith(this.affixMarker)) {
                return 3;
            }
            if (length > 2 && lexUnit.startsWith(this.affixMarker) && lexUnit.endsWith(this.affixMarker)) {
                return 6;
            }
            if (!this.cliticMarker.isEmpty()) {
                if (length > 1 && lexUnit.endsWith(this.cliticMarker)) {
                    return 4;
                }
                if (length > 1 && lexUnit.startsWith(this.cliticMarker)) {
                    return 5;
                }
            }
        }
        return 0;
    }

    protected String removeAffixes(String lexUnitString) {
        int length = lexUnitString.length();
        if (length > 1 && lexUnitString.endsWith(this.affixMarker)) {
            lexUnitString = lexUnitString.substring(0, --length);
        }
        if (length > 1 && lexUnitString.startsWith(this.affixMarker)) {
            lexUnitString = lexUnitString.substring(1);
        }
        if (this.cliticMarker.length() > 0) {
            if (length > 1 && lexUnitString.endsWith(this.cliticMarker)) {
                lexUnitString = lexUnitString.substring(0, --length);
            }
            if (length > 1 && lexUnitString.startsWith(this.cliticMarker)) {
                lexUnitString = lexUnitString.substring(1);
            }
        }
        return lexUnitString;
    }

    protected void addLexicalEntryToMaps(LexEntry entry) {
        LexItem lexicalUnit = entry.getLexItem(LEXICAL_UNIT);
        if (lexicalUnit instanceof LexAtom) {
            List variants;
            int mt;
            LexAtom atomlexicalUnit = (LexAtom)lexicalUnit;
            String lexUnitString = atomlexicalUnit.getLexValue();
            if (lexUnitString.isEmpty()) {
                return;
            }
            if (!this.caseSensitiveParsing) {
                lexUnitString = lexUnitString.toLowerCase();
            }
            if ((mt = this.getMorphType(entry)) == 1 || mt == 3 || mt == 6 || mt == 4 || mt == 5) {
                lexUnitString = this.removeAffixes(lexUnitString);
            }
            this.addLexicalUnit(lexUnitString, entry, mt);
            if (this.considerVariants && (variants = entry.getLexItems(VARIANT)) != null) {
                for (LexItem variant : variants) {
                    String var;
                    if (!(variant instanceof LexAtom) || (var = ((LexAtom)variant).getLexValue()).isEmpty()) continue;
                    if (!this.caseSensitiveParsing) {
                        var = var.toLowerCase();
                    }
                    var = this.removeAffixes(var);
                    this.addLexicalUnit(var, entry, mt);
                }
            }
        }
    }

    protected void addLexicalUnit(String lexicalUnit, LexEntry entry, int mt) {
        int length = lexicalUnit.length();
        switch (mt) {
            case 1: 
            case 4: {
                this.longestPrefix = Math.max(this.longestPrefix, length);
                this.addLexicalUnit(this.prefixMap, lexicalUnit, entry);
                break;
            }
            case 3: 
            case 5: {
                this.longestSuffix = Math.max(this.longestSuffix, length);
                this.addLexicalUnit(this.suffixMap, lexicalUnit, entry);
                break;
            }
            case 6: {
                this.longestInfix = Math.max(this.longestInfix, length);
                this.addLexicalUnit(this.infixMap, lexicalUnit, entry);
                break;
            }
            default: {
                this.longestStem = Math.max(this.longestStem, length);
                this.addLexicalUnit(this.stemMap, lexicalUnit, entry);
            }
        }
    }

    protected void addLexicalUnit(Map<String, List<LexEntry>> entrymap, String lexicalUnit, LexEntry entry) {
        List<LexEntry> list = entrymap.get(lexicalUnit);
        if (list == null) {
            list = new LinkedList<LexEntry>();
            entrymap.put(lexicalUnit, list);
        }
        list.add(entry);
    }

    protected void removeLexicalEntryFromMaps(LexEntry entry) {
        LexItem lexicalUnit = entry.getLexItem(LEXICAL_UNIT);
        if (lexicalUnit instanceof LexAtom) {
            List variants;
            int mt;
            LexAtom atomlexicalUnit = (LexAtom)lexicalUnit;
            String lexUnitString = atomlexicalUnit.getLexValue();
            if (lexUnitString.isEmpty()) {
                return;
            }
            if (!this.caseSensitiveParsing) {
                lexUnitString = lexUnitString.toLowerCase();
            }
            if ((mt = this.getMorphType(entry)) == 1 || mt == 3 || mt == 6 || mt == 4 || mt == 5) {
                lexUnitString = this.removeAffixes(lexUnitString);
            }
            this.removeLexicalUnit(lexUnitString, entry, mt);
            if (this.considerVariants && (variants = entry.getLexItems(VARIANT)) != null) {
                for (LexItem variant : variants) {
                    if (!(variant instanceof LexAtom)) continue;
                    String var = ((LexAtom)variant).getLexValue();
                    if (!this.caseSensitiveParsing) {
                        var = var.toLowerCase();
                    }
                    var = this.removeAffixes(var);
                    this.removeLexicalUnit(var, entry, mt);
                }
            }
        }
    }

    protected void removeLexicalUnit(String lexicalUnit, LexEntry entry, int morphType) {
        switch (morphType) {
            case 1: 
            case 4: {
                this.removeLexicalUnit(this.prefixMap, lexicalUnit, entry);
                break;
            }
            case 3: 
            case 5: {
                this.removeLexicalUnit(this.suffixMap, lexicalUnit, entry);
                break;
            }
            case 6: {
                this.removeLexicalUnit(this.infixMap, lexicalUnit, entry);
                break;
            }
            default: {
                this.removeLexicalUnit(this.stemMap, lexicalUnit, entry);
            }
        }
    }

    protected void removeLexicalUnit(Map<String, List<LexEntry>> entrymap, String lexicalUnit, LexEntry entry) {
        List<LexEntry> list = entrymap.get(lexicalUnit);
        if (list != null) {
            for (LexEntry le : list) {
                if (le.getId() == null || !le.getId().equals(entry.getId())) continue;
                list.remove(le);
                break;
            }
            if (list.isEmpty()) {
                entrymap.remove(lexicalUnit);
            }
        }
    }

    public void setConfig(SourceTargetConfiguration stc) {
        this.sourceTargetConfig = stc;
    }

    public abstract List<List<ParseFrag>> parse(String var1);

    public List<InputState> matchSuffixes(InputState is) {
        LinkedList<InputState> out = new LinkedList<InputState>();
        int minI = Math.max(0, is.surface.length() - this.longestSuffix);
        if (!this.longerFragmentsFirst) {
            for (int i = is.surface.length() - 1; i >= minI; --i) {
                String trigger = is.surface.substring(i);
                if (!this.suffixMap.containsKey(trigger)) continue;
                for (LexEntry entry : this.suffixMap.get(trigger)) {
                    is.applySuffix(out, trigger, entry, this.sourceTargetConfig);
                }
            }
        } else {
            for (int i = minI; i < is.surface.length(); ++i) {
                String trigger = is.surface.substring(i);
                if (!this.suffixMap.containsKey(trigger)) continue;
                for (LexEntry entry : this.suffixMap.get(trigger)) {
                    is.applySuffix(out, trigger, entry, this.sourceTargetConfig);
                }
            }
        }
        return out;
    }

    public List<InputState> matchPrefixesStems(InputState is) {
        LinkedList<InputState> out = new LinkedList<InputState>();
        int maxI = Math.min(this.longestPrefixAndStem, is.surface.length());
        if (!this.longerFragmentsFirst) {
            for (int i = 1; i <= maxI; ++i) {
                String trigger = is.surface.substring(0, i);
                if (i <= this.longestStem && this.stemMap.containsKey(trigger)) {
                    for (LexEntry entry : this.stemMap.get(trigger)) {
                        is.applyStem(out, trigger, entry, this.sourceTargetConfig);
                    }
                }
                if (i > this.longestPrefix || !this.prefixMap.containsKey(trigger)) continue;
                for (LexEntry entry : this.prefixMap.get(trigger)) {
                    is.applyPrefix(out, trigger, entry, this.sourceTargetConfig);
                }
            }
        } else {
            for (int i = maxI; i > 0; --i) {
                String trigger = is.surface.substring(0, i);
                if (i <= this.longestStem && this.stemMap.containsKey(trigger)) {
                    for (LexEntry entry : this.stemMap.get(trigger)) {
                        is.applyStem(out, trigger, entry, this.sourceTargetConfig);
                    }
                }
                if (i > this.longestPrefix || !this.prefixMap.containsKey(trigger)) continue;
                for (LexEntry entry : this.prefixMap.get(trigger)) {
                    is.applyPrefix(out, trigger, entry, this.sourceTargetConfig);
                }
            }
        }
        return out;
    }

    public List<InputState> matchInfixedStem(InputState is) {
        LinkedList<InputState> out = new LinkedList<InputState>();
        String trigger = is.surface;
        if (this.longestInfix > 0 && trigger.length() > 2) {
            List<String> stemCand = this.getStemCandidates(trigger);
            List<String> infCand = this.getInfixCandidates(trigger);
            if (stemCand.size() == 0 || infCand.size() == 0) {
                return out;
            }
            for (String stemKey : stemCand) {
                for (String infKey : infCand) {
                    for (int i = 0; i <= stemKey.length(); ++i) {
                        if (!(i == 0 && trigger.equals(infKey.concat(stemKey)) || i == stemKey.length() && trigger.equals(stemKey.concat(infKey))) && !trigger.equals(stemKey.substring(0, i).concat(infKey).concat(stemKey.substring(i)))) continue;
                        for (LexEntry stemEntry : this.stemMap.get(stemKey)) {
                            for (LexEntry infEntry : this.infixMap.get(infKey)) {
                                is.applyStemInfix(out, trigger, stemEntry, infEntry, i, infKey.length(), this.sourceTargetConfig);
                            }
                        }
                    }
                }
            }
            for (String stemKey : stemCand) {
                for (String infKey : infCand) {
                    String format = "%s" + infKey + "%s";
                    for (int i = 1; i < stemKey.length(); ++i) {
                        for (int j = 0; j < infKey.length(); ++j) {
                            String r;
                            String l = i == 0 ? "" : stemKey.substring(0, i);
                            String string = r = i + j < stemKey.length() ? stemKey.substring(i + j) : "";
                            if (!trigger.equals(String.format(format, l, r))) continue;
                            for (LexEntry stemEntry : this.stemMap.get(stemKey)) {
                                for (LexEntry infEntry : this.infixMap.get(infKey)) {
                                    is.applyStemInfix(out, trigger, stemEntry, infEntry, i, infKey.length(), this.sourceTargetConfig);
                                }
                            }
                        }
                    }
                }
            }
        }
        return out;
    }

    protected List<String> getStemCandidates(String trigger) {
        ArrayList<String> keys = new ArrayList<String>();
        for (String k : this.stemMap.keySet()) {
            if (k.length() > trigger.length() || !trigger.startsWith(k.substring(0, 1)) && !trigger.endsWith(k.substring(k.length() - 1))) continue;
            keys.add(k);
        }
        return keys;
    }

    protected List<String> getInfixCandidates(String trigger) {
        ArrayList<String> keys = new ArrayList<String>(10);
        for (String k : this.infixMap.keySet()) {
            int index = trigger.indexOf(k);
            if (index <= -1) continue;
            keys.add(k);
        }
        return keys;
    }

    public static enum ParseState {
        START,
        STEM,
        NOSTEM,
        OK,
        OKNOP,
        ABORT;

    }
}

