/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.parsebase;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import nl.mpi.lexan.analyzers.helpers.SourceTargetConfiguration;
import nl.mpi.lexan.analyzers.lexicon.LexEntry;
import nl.mpi.lexan.analyzers.parsebase.AbstractParser;
import nl.mpi.lexan.analyzers.parsebase.ParseFrag;

public abstract class InputState {
    public static final Logger LOG = Logger.getLogger(InputState.class.getName());
    public String surface;
    public ArrayList<ParseFrag> frags;
    public int insertionPoint;
    public AbstractParser.ParseState state;

    public InputState(String word) {
        this.surface = word;
        this.frags = new ArrayList();
        this.state = AbstractParser.ParseState.START;
    }

    protected InputState(InputState is) {
        this.surface = is.surface;
        this.state = is.state;
        this.insertionPoint = is.insertionPoint;
        this.frags = new ArrayList<ParseFrag>(is.frags);
    }

    public List<ParseFrag> getFrags() {
        return this.frags;
    }

    public void addFrag(ParseFrag frag, boolean leftToRight) {
        this.frags.add(this.insertionPoint, frag);
        if (leftToRight) {
            ++this.insertionPoint;
        }
    }

    public abstract void applyPrefix(List<InputState> var1, String var2, LexEntry var3, SourceTargetConfiguration var4);

    public abstract void applySuffix(List<InputState> var1, String var2, LexEntry var3, SourceTargetConfiguration var4);

    public abstract void applyStem(List<InputState> var1, String var2, LexEntry var3, SourceTargetConfiguration var4);

    public abstract void applyStemInfix(List<InputState> var1, String var2, LexEntry var3, LexEntry var4, int var5, int var6, SourceTargetConfiguration var7);

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InputState[");
        sb.append("state=");
        sb.append(String.valueOf((Object)this.state));
        sb.append(" surface=\"");
        sb.append(String.valueOf(this.surface));
        sb.append("\" insertionPoint=");
        sb.append(String.valueOf(this.insertionPoint));
        sb.append(" frags=");
        sb.append(String.valueOf(this.frags));
        sb.append("]");
        return sb.toString();
    }
}

