/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.lexan.analyzers.parsebase;

import java.io.File;
import nl.mpi.lexan.analyzers.helpers.ConfigurationHandler;
import nl.mpi.lexan.analyzers.helpers.settings.AnalyzerSet;
import nl.mpi.lexan.analyzers.helpers.settings.Setting;
import nl.mpi.lexan.analyzers.helpers.settings.SettingsException;
import nl.mpi.lexan.analyzers.helpers.settings.SettingsIO;

public class ParseConfigurator
extends ConfigurationHandler {
    static final int DEFAULT_NPARSES = 256;
    static final String AFFIX_MARKER = "-";
    static final String REPLACE_FIELD = "replace";
    public static final String NUM_PARSES_PREF = "NumberOfParses";
    public static final String INCL_VARIANTS_PREF = "ConsiderVariants";
    public static final String EXCL_PARTPARSES_PREF = "ExcludeAbortedParses";
    public static final String AFFIX_MARKER_PREF = "AffixMarker";
    public static final String MISSING_MARKER_PREF = "MissingMarker";
    public static final String REPLACE_FIELD_PREF = "ReplaceField";
    public static final String LONGER_FRAGMENTS_FIRST_PREF = "MatchLongerFragmentsFirst";
    public static final String REVERSED_ORDER_PREF = "ReversedOrderOfParses";
    public static final String CASE_SENSITIVE_PREF = "CaseSensitiveMatching";
    public static final String CLITIC_MARKER_PREF = "CliticMarker";
    public static final String MATCH_LANGUAGE_PREF = "MatchLanguageAttributes";
    public static final String SAME_CATEGORY_PREF = "SameGramCategory";
    public static final String OUTPUT_CITATION_PREF = "OutputCitationForm";
    protected boolean considerVariants;
    protected int nParses;
    protected boolean excludeAbortedParses;
    protected String affixMarker;
    protected String missingMarker;
    protected String replaceFieldName;
    protected boolean longFragmentsFirst;
    protected boolean caseSensitiveParsing;
    protected String cliticMarker;
    protected boolean matchLanguageAttr;
    protected boolean sameGramCategory;
    protected boolean outputCitation;

    public ParseConfigurator(File dataDirectory, String analyzerName, String settingsKey) {
        super(dataDirectory, analyzerName, settingsKey);
        this.initSettings();
    }

    private void initSettings() {
        this.considerVariants = true;
        this.nParses = 256;
        this.excludeAbortedParses = false;
        this.replaceFieldName = REPLACE_FIELD;
        this.affixMarker = AFFIX_MARKER;
        this.missingMarker = "*";
        this.longFragmentsFirst = false;
        this.caseSensitiveParsing = true;
        this.cliticMarker = "";
        this.matchLanguageAttr = true;
        this.sameGramCategory = false;
        this.outputCitation = false;
    }

    protected void applySettingsToFields() {
        if (this.currentSettings != null) {
            String preferCitationValue;
            String sameGramCatValue;
            String matchLangValue;
            String cliticMarkerValue;
            String caseSensitiveValue;
            String longFragmenstFirstValue;
            String missingMarkerValue;
            String affixMarkerValue;
            String replaceValue;
            String excludeAbParValue;
            String parValue;
            String varValue = this.currentSettings.getSettingValue(INCL_VARIANTS_PREF);
            if (varValue != null) {
                this.considerVariants = Boolean.parseBoolean(varValue);
            }
            if ((parValue = this.currentSettings.getSettingValue(NUM_PARSES_PREF)) != null) {
                try {
                    this.nParses = Integer.parseInt(parValue);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if ((excludeAbParValue = this.currentSettings.getSettingValue(EXCL_PARTPARSES_PREF)) != null) {
                this.excludeAbortedParses = Boolean.parseBoolean(excludeAbParValue);
            }
            if ((replaceValue = this.currentSettings.getSettingValue(REPLACE_FIELD_PREF)) != null) {
                this.replaceFieldName = replaceValue;
            }
            if ((affixMarkerValue = this.currentSettings.getSettingValue(AFFIX_MARKER_PREF)) != null) {
                this.affixMarker = affixMarkerValue;
            }
            if ((missingMarkerValue = this.currentSettings.getSettingValue(MISSING_MARKER_PREF)) != null) {
                this.missingMarker = missingMarkerValue;
            }
            if ((longFragmenstFirstValue = this.currentSettings.getSettingValue(LONGER_FRAGMENTS_FIRST_PREF)) != null) {
                this.longFragmentsFirst = Boolean.parseBoolean(longFragmenstFirstValue);
            }
            if ((caseSensitiveValue = this.currentSettings.getSettingValue(CASE_SENSITIVE_PREF)) != null) {
                this.caseSensitiveParsing = Boolean.parseBoolean(caseSensitiveValue);
            }
            if ((cliticMarkerValue = this.currentSettings.getSettingValue(CLITIC_MARKER_PREF)) != null) {
                this.cliticMarker = cliticMarkerValue;
            }
            if ((matchLangValue = this.currentSettings.getSettingValue(MATCH_LANGUAGE_PREF)) != null) {
                this.matchLanguageAttr = Boolean.parseBoolean(matchLangValue);
            }
            if ((sameGramCatValue = this.currentSettings.getSettingValue(SAME_CATEGORY_PREF)) != null) {
                this.sameGramCategory = Boolean.parseBoolean(sameGramCatValue);
            }
            if ((preferCitationValue = this.currentSettings.getSettingValue(OUTPUT_CITATION_PREF)) != null) {
                this.outputCitation = Boolean.parseBoolean(preferCitationValue);
            }
        }
    }

    protected void applyFieldsToSettings() {
        AnalyzerSet anSet = SettingsIO.getInstance().createEmptySettings(this.analyzerName);
        anSet.getSettingList().add(new Setting(INCL_VARIANTS_PREF, String.valueOf(this.considerVariants)));
        anSet.getSettingList().add(new Setting(NUM_PARSES_PREF, String.valueOf(this.nParses)));
        anSet.getSettingList().add(new Setting(EXCL_PARTPARSES_PREF, String.valueOf(this.excludeAbortedParses)));
        anSet.getSettingList().add(new Setting(REPLACE_FIELD_PREF, this.replaceFieldName));
        anSet.getSettingList().add(new Setting(AFFIX_MARKER_PREF, this.affixMarker));
        anSet.getSettingList().add(new Setting(MISSING_MARKER_PREF, this.missingMarker));
        anSet.getSettingList().add(new Setting(LONGER_FRAGMENTS_FIRST_PREF, String.valueOf(this.longFragmentsFirst)));
        anSet.getSettingList().add(new Setting(CASE_SENSITIVE_PREF, String.valueOf(this.caseSensitiveParsing)));
        anSet.getSettingList().add(new Setting(SAME_CATEGORY_PREF, String.valueOf(this.sameGramCategory)));
        anSet.getSettingList().add(new Setting(MATCH_LANGUAGE_PREF, String.valueOf(this.matchLanguageAttr)));
        if (this.cliticMarker != null && !this.cliticMarker.isEmpty()) {
            anSet.getSettingList().add(new Setting(CLITIC_MARKER_PREF, this.cliticMarker));
        }
        anSet.getSettingList().add(new Setting(OUTPUT_CITATION_PREF, String.valueOf(this.outputCitation)));
        anSet.setKey(this.curSettingsKey);
        this.currentSettings = anSet;
    }

    public void loadCurrentSettings() throws SettingsException {
        super.loadCurrentSettings();
        this.applySettingsToFields();
    }

    public AnalyzerSet getCurrentSettings() {
        this.applyFieldsToSettings();
        return super.getCurrentSettings();
    }

    public void setCurrentSettings(AnalyzerSet settings) {
        if (settings != null) {
            super.setCurrentSettings(settings);
            this.applySettingsToFields();
        }
    }

    public void saveCurrentSettings() throws SettingsException {
        this.applyFieldsToSettings();
        super.saveCurrentSettings();
    }

    public String getString(String prefKey) {
        if (prefKey == null) {
            return null;
        }
        switch (prefKey) {
            case "AffixMarker": {
                return this.affixMarker;
            }
            case "ReplaceField": {
                return this.replaceFieldName;
            }
            case "MissingMarker": {
                return this.missingMarker;
            }
            case "CliticMarker": {
                return this.cliticMarker;
            }
        }
        return null;
    }

    public int getInt(String prefKey) {
        if (prefKey == null) {
            return 0;
        }
        switch (prefKey) {
            case "NumberOfParses": {
                return this.nParses;
            }
        }
        return 0;
    }

    public boolean getBoolean(String prefKey) {
        if (prefKey == null) {
            return false;
        }
        switch (prefKey) {
            case "ConsiderVariants": {
                return this.considerVariants;
            }
            case "ExcludeAbortedParses": {
                return this.excludeAbortedParses;
            }
            case "MatchLongerFragmentsFirst": {
                return this.longFragmentsFirst;
            }
            case "CaseSensitiveMatching": {
                return this.caseSensitiveParsing;
            }
            case "MatchLanguageAttributes": {
                return this.matchLanguageAttr;
            }
            case "SameGramCategory": {
                return this.sameGramCategory;
            }
            case "OutputCitationForm": {
                return this.outputCitation;
            }
        }
        return false;
    }

    public void setString(String prefKey, String prefValue) {
        if (prefKey == null) {
            return;
        }
        switch (prefKey) {
            case "AffixMarker": {
                this.affixMarker = prefValue;
                break;
            }
            case "ReplaceField": {
                this.replaceFieldName = prefValue;
                break;
            }
            case "MissingMarker": {
                this.missingMarker = prefValue;
                break;
            }
            case "CliticMarker": {
                this.cliticMarker = prefValue;
                break;
            }
            default: {
                return;
            }
        }
    }

    public void setInt(String prefKey, int prefValue) {
        if (prefKey == null) {
            return;
        }
        switch (prefKey) {
            case "NumberOfParses": {
                this.nParses = prefValue;
            }
        }
    }

    public void setBoolean(String prefKey, boolean prefValue) {
        if (prefKey == null) {
            return;
        }
        switch (prefKey) {
            case "ConsiderVariants": {
                this.considerVariants = prefValue;
                break;
            }
            case "ExcludeAbortedParses": {
                this.excludeAbortedParses = prefValue;
                break;
            }
            case "MatchLongerFragmentsFirst": {
                this.longFragmentsFirst = prefValue;
                break;
            }
            case "CaseSensitiveMatching": {
                this.caseSensitiveParsing = prefValue;
                break;
            }
            case "MatchLanguageAttributes": {
                this.matchLanguageAttr = prefValue;
                break;
            }
            case "SameGramCategory": {
                this.sameGramCategory = prefValue;
                break;
            }
            case "OutputCitationForm": {
                this.outputCitation = prefValue;
                break;
            }
            default: {
                return;
            }
        }
    }
}

